/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.bulk;

import com.atlassian.bitbucket.scm.CommandResult;
import com.atlassian.bitbucket.scm.CommandSummary;
import com.atlassian.bitbucket.scm.CommandSummaryHandler;
import com.atlassian.bitbucket.scm.bulk.BulkChangeType;
import com.atlassian.stash.internal.scm.git.bulk.FileChange;
import com.atlassian.stash.internal.scm.git.bulk.FileChangeWithSize;
import com.atlassian.stash.internal.scm.git.command.catfile.AbstractBatchCheckCatFileStdioHandler;
import com.atlassian.stash.internal.scm.git.command.catfile.BatchHeader;
import com.atlassian.stash.internal.scm.git.io.NullTerminatedReader;
import com.atlassian.stash.internal.scm.git.io.NullTerminatedWriter;
import jakarta.annotation.Nonnull;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.UncheckedIOException;

public class BulkBatchCheckCatFileStdioHandler
extends AbstractBatchCheckCatFileStdioHandler<CommandResult>
implements CommandSummaryHandler {
    private final NullTerminatedReader reader;
    private final NullTerminatedWriter writer;
    private FileChange fileChange;
    private CommandResult result;

    public BulkBatchCheckCatFileStdioHandler(BufferedReader reader, BufferedWriter writer) {
        this.reader = new NullTerminatedReader(reader);
        this.writer = new NullTerminatedWriter(writer);
    }

    public CommandResult getOutput() {
        return this.result;
    }

    public void onComplete(@Nonnull CommandSummary summary) {
        this.result = summary.getResult();
    }

    @Override
    protected String getNextObjectId() {
        try {
            while (true) {
                this.fileChange = FileChange.read(this.reader);
                if (this.fileChange == null) {
                    return null;
                }
                if (this.fileChange.getChangeType() != BulkChangeType.DELETE) break;
                FileChangeWithSize.write(this.fileChange, 0L, this.writer);
            }
            return this.fileChange.getContentId();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed reading next file change", e);
        }
    }

    @Override
    protected void onMissing(@Nonnull String objectId) {
        throw new IllegalStateException("Object with ID " + objectId + " was missing");
    }

    @Override
    protected void onObject(@Nonnull BatchHeader header) {
        try {
            FileChangeWithSize.write(this.fileChange, header.getSize(), this.writer);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed writing file change for [" + header.getObjectId() + "]", e);
        }
    }
}

