/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.bulk;

import com.atlassian.bitbucket.scm.bulk.BulkChangeType;
import com.atlassian.bitbucket.scm.bulk.BulkFile;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.atlassian.stash.internal.scm.git.bulk.FileChange;
import com.atlassian.stash.internal.scm.git.io.NullTerminatedReader;
import com.atlassian.stash.internal.scm.git.io.NullTerminatedWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.Objects;

public class FileChangeWithSize
extends FileChange
implements BulkFile {
    private final long size;

    private FileChangeWithSize(String path, BulkChangeType changeType, String contentId, long size) {
        super(path, changeType, contentId);
        this.size = size;
    }

    @Nullable
    public static FileChangeWithSize read(NullTerminatedReader reader) throws IOException {
        FileChange fileChange = FileChange.read(reader);
        if (fileChange == null) {
            return null;
        }
        String sizeString = reader.readSegment();
        if (sizeString == null) {
            return null;
        }
        long size = Long.parseLong(sizeString);
        return new FileChangeWithSize(fileChange.getPath(), fileChange.getChangeType(), fileChange.getContentId(), size);
    }

    public static void write(FileChange change, long size, NullTerminatedWriter writer) throws IOException {
        FileChangeWithSize.write(change.getPath(), change.getChangeType(), change.getContentId(), size, writer);
    }

    public static void write(String path, BulkChangeType changeType, String contentId, long size, NullTerminatedWriter writer) throws IOException {
        FileChangeWithSize.write(path, changeType, contentId, writer);
        writer.writeSegment(String.valueOf(size));
    }

    public long getSize() {
        return this.size;
    }

    public static class Builder
    extends BuilderSupport {
        private BulkChangeType changeType;
        private String contentId;
        private String path;
        private long size;

        @Nonnull
        public FileChangeWithSize build() {
            return new FileChangeWithSize(this.path, this.changeType, this.contentId, this.size);
        }

        @Nonnull
        public Builder changeType(@Nonnull BulkChangeType value) {
            this.changeType = Objects.requireNonNull(value, "changeType");
            return this;
        }

        @Nonnull
        public Builder contentId(@Nonnull String value) {
            this.contentId = Objects.requireNonNull(value, "contentId");
            return this;
        }

        @Nonnull
        public Builder path(@Nonnull String value) {
            this.path = Objects.requireNonNull(value, "path");
            return this;
        }

        @Nonnull
        public Builder size(long value) {
            this.size = value;
            return this;
        }
    }
}

