/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.command;

import com.atlassian.bitbucket.dmz.process.NioStdoutHandler;
import com.atlassian.bitbucket.io.TypeAwareOutputSupplier;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.Objects;

public class SupplierStdoutHandler
implements NioStdoutHandler<Void> {
    private final String contentType;
    private final TypeAwareOutputSupplier outputSupplier;
    private WritableByteChannel channel;

    public SupplierStdoutHandler(@Nonnull TypeAwareOutputSupplier outputSupplier) {
        this(outputSupplier, "text/plain; charset=UTF-8");
    }

    public SupplierStdoutHandler(@Nonnull TypeAwareOutputSupplier outputSupplier, @Nonnull String contentType) {
        this.contentType = Objects.requireNonNull(contentType, "contentType");
        this.outputSupplier = Objects.requireNonNull(outputSupplier, "outputSupplier");
    }

    public Void getOutput() {
        return null;
    }

    public void onExit(int exitCode) {
        WritableByteChannel channel = this.channel;
        if (channel != null && channel.isOpen()) {
            try {
                channel.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to close output channel", e);
            }
        }
    }

    public void onStdout(@Nonnull ByteBuffer buffer, boolean closed) {
        try {
            if (this.channel == null) {
                if (closed && !buffer.hasRemaining()) {
                    return;
                }
                this.channel = Channels.newChannel(this.outputSupplier.getStream(this.contentType));
            }
            if (buffer.hasRemaining()) {
                this.channel.write(buffer);
            }
            if (closed) {
                this.channel.close();
                this.channel = null;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to copy output", e);
        }
    }
}

