/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.command.archive;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.repository.InvalidRefNameException;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.git.command.GitCommandExitHandler;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Locale;
import java.util.Objects;

public class ArchiveCommandExitHandler
extends GitCommandExitHandler {
    private final String commitId;

    public ArchiveCommandExitHandler(@Nonnull I18nService i18nService, @Nullable Repository repository, @Nonnull String commitId) {
        super(i18nService, repository);
        this.commitId = Objects.requireNonNull(commitId, "commitId");
    }

    protected void evaluateStdErr(String stdErr, String command) {
        String check = stdErr.toLowerCase(Locale.ROOT);
        if (check.startsWith("fatal: not a tree object")) {
            throw this.newNoSuchCommitException(this.commitId);
        }
        if (check.startsWith("fatal: not a valid object name")) {
            throw this.newInvalidRefNameException();
        }
        super.evaluateStdErr(stdErr, command);
    }

    private InvalidRefNameException newInvalidRefNameException() {
        throw new InvalidRefNameException(this.i18nService.createKeyedMessage("bitbucket.git.archive.invalidref", new Object[]{this.commitId}), this.commitId);
    }
}

