/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.command.catfile;

import com.atlassian.stash.internal.scm.git.command.catfile.BatchHeader;
import com.atlassian.stash.internal.scm.git.command.catfile.BatchedCatFileStdioHandlerSupport;
import com.atlassian.stash.internal.scm.git.io.ByteSegmentScanner;
import jakarta.annotation.Nonnull;
import java.nio.ByteBuffer;

public abstract class AbstractBatchCheckCatFileStdioHandler<T>
extends BatchedCatFileStdioHandlerSupport<T> {
    private final ByteSegmentScanner segmentScanner = new ByteSegmentScanner();

    protected AbstractBatchCheckCatFileStdioHandler() {
    }

    public void onStdout(@Nonnull ByteBuffer buffer, boolean closed) {
        while (buffer.hasRemaining()) {
            ByteBuffer headerBytes = this.segmentScanner.scan(buffer, closed);
            if (headerBytes == null || !headerBytes.hasRemaining()) {
                return;
            }
            BatchHeader header = BatchHeader.parse(headerBytes);
            if (header.isMissing()) {
                this.onMissing(header.getObjectId());
            } else {
                this.onObject(header);
            }
            if (closed) continue;
            this.pumpIfRunning();
        }
    }

    protected abstract void onMissing(@Nonnull String var1);

    protected abstract void onObject(@Nonnull BatchHeader var1);
}

