/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.command.catfile;

import com.atlassian.bitbucket.scm.git.GitUtils;
import jakarta.annotation.Nonnull;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Scanner;

public class BatchHeader {
    public static int MAX_SIZE_IN_BYTES = 100;
    private final String objectId;
    private final String type;
    private final long size;

    private BatchHeader(String objectId, String type, long size) {
        this.objectId = objectId;
        this.type = type;
        this.size = size;
    }

    @Nonnull
    public static BatchHeader parse(@Nonnull ByteBuffer buffer) {
        return BatchHeader.parse(new Scanner(StandardCharsets.UTF_8.decode(buffer)));
    }

    @Nonnull
    public static BatchHeader parse(@Nonnull String value) {
        return BatchHeader.parse(new Scanner(value));
    }

    @Nonnull
    public static BatchHeader parse(byte[] bytes) {
        return BatchHeader.parse(new String(bytes, StandardCharsets.UTF_8));
    }

    @Nonnull
    public String getObjectId() {
        return this.objectId;
    }

    @Nonnull
    public String getType() {
        return this.type;
    }

    public long getSize() {
        return this.size;
    }

    public boolean isMissing() {
        return "missing".equals(this.type);
    }

    private static String getSha1(Scanner headerScanner) {
        if (headerScanner.hasNext()) {
            return headerScanner.next();
        }
        throw new IllegalStateException("Expected a SHA1");
    }

    private static long getSize(Scanner headerScanner) {
        if (headerScanner.hasNext()) {
            String hdrSize = headerScanner.next();
            try {
                long size = Long.parseLong(hdrSize);
                if (size < 0L) {
                    throw new IllegalStateException("The size cannot be negative");
                }
                return size;
            }
            catch (NumberFormatException e) {
                throw new IllegalStateException("The size field did not contain a valid number");
            }
        }
        throw new IllegalStateException("Content size expected but not found");
    }

    private static String getType(Scanner headerScanner) {
        if (headerScanner.hasNext()) {
            return headerScanner.next();
        }
        throw new IllegalStateException("Object type expected, but not found");
    }

    private static BatchHeader parse(Scanner scanner) {
        String sha1 = BatchHeader.getSha1(scanner);
        String type = BatchHeader.getType(scanner);
        if ("missing".equals(type)) {
            return new BatchHeader(sha1, type, 0L);
        }
        if (!GitUtils.isHash((String)sha1)) {
            throw new IllegalStateException("The SHA1 received was not exactly 40 characters in size, was: " + sha1);
        }
        return new BatchHeader(sha1, type, BatchHeader.getSize(scanner));
    }
}

