/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.command.catfile;

import com.atlassian.bitbucket.dmz.process.AbstractNioHandler;
import com.atlassian.bitbucket.dmz.process.NioProcess;
import com.atlassian.bitbucket.dmz.process.NioStdioHandler;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BatchedCatFileStdioHandlerSupport<T>
extends AbstractNioHandler
implements NioStdioHandler<T> {
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    protected BatchedCatFileStdioHandlerSupport() {
    }

    public void onStart(@Nonnull NioProcess process) {
        super.onStart(process);
        process.wantWrite();
    }

    public boolean onStdinReady(@Nonnull ByteBuffer buffer) {
        String objectId = this.getNextObjectId();
        if (objectId == null) {
            this.closeStdin();
        } else {
            buffer.put(StandardCharsets.UTF_8.encode(objectId));
            buffer.put((byte)10);
        }
        buffer.flip();
        return false;
    }

    @Nullable
    protected abstract String getNextObjectId();

    protected void pumpIfRunning() {
        if (this.isCanceled()) {
            this.closeStdin();
        } else {
            this.pump();
        }
    }

    protected void requestObject(String objectId) {
        this.process.writeStdin(ByteBuffer.wrap((objectId + "\n").getBytes(StandardCharsets.UTF_8)));
    }

    private void pump() {
        String objectId = this.getNextObjectId();
        if (objectId == null) {
            this.closeStdin();
        } else {
            this.requestObject(objectId);
        }
    }
}

