/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.command.catfile;

import com.atlassian.bitbucket.content.FileContentCallback;
import com.atlassian.bitbucket.content.FileContext;
import com.atlassian.bitbucket.content.FileSummary;
import com.atlassian.bitbucket.dmz.process.LinePump;
import com.atlassian.bitbucket.dmz.process.LineStdoutHandler;
import com.atlassian.bitbucket.scm.CommandResult;
import com.atlassian.bitbucket.scm.CommandSummary;
import com.atlassian.bitbucket.scm.CommandSummaryHandler;
import com.atlassian.bitbucket.util.AbstractSummary;
import com.atlassian.bitbucket.util.PageRequest;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.UncheckedIOException;

public class CallbackCatFileStdoutHandler
extends LineStdoutHandler<Void>
implements CommandSummaryHandler {
    private final FileContentCallback callback;
    private final FileContext context;
    private final PageRequest pageRequest;
    private int added;
    private int lines;

    public CallbackCatFileStdoutHandler(FileContentCallback callback, FileContext context, PageRequest pageRequest) {
        super(null, LinePump.Mode.CRLF_OR_LF, context.getMaxLineLength());
        this.callback = callback;
        this.context = context;
        this.pageRequest = pageRequest;
    }

    public Void getOutput() {
        return null;
    }

    public void onComplete(@Nonnull CommandSummary summary) {
        try {
            if (this.added > 0) {
                this.callback.onEnd(((FileSummary.Builder)((FileSummary.Builder)((FileSummary.Builder)new FileSummary.Builder((AbstractSummary)summary).lastPage(this.added <= this.pageRequest.getLimit())).pageRequest(this.pageRequest)).size(Math.min(this.added, this.pageRequest.getLimit()))).build());
            } else if (summary.getResult() == CommandResult.SUCCEEDED) {
                this.callback.onStart(this.context);
                this.callback.onEnd(((FileSummary.Builder)((FileSummary.Builder)new FileSummary.Builder((AbstractSummary)summary).lastPage(true)).pageRequest(this.pageRequest)).build());
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    protected void onBinary() {
        try {
            this.callback.onBinary();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    protected boolean onStdout(@Nonnull String line, boolean truncated) {
        if (this.lines++ < this.pageRequest.getStart()) {
            return true;
        }
        try {
            if (this.added++ == 0) {
                this.callback.onStart(this.context);
            }
            if (this.added > this.pageRequest.getLimit() || !this.callback.onLine(this.lines, line, truncated)) {
                return false;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return true;
    }
}

