/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.command.countobjects;

import com.atlassian.bitbucket.scm.RepositorySize;
import jakarta.annotation.Nonnull;

public class SimpleRepositorySize
implements RepositorySize {
    private final long garbageSize;
    private final long inPackSize;
    private final long looseSize;

    private SimpleRepositorySize(Builder builder) {
        this.garbageSize = builder.garbageSize;
        this.inPackSize = builder.inPackSize;
        this.looseSize = builder.looseSize;
    }

    public long getTotal() {
        return this.garbageSize * 1024L + this.inPackSize * 1024L + this.looseSize * 1024L;
    }

    public static class Builder {
        private long garbageSize;
        private long inPackSize;
        private long looseSize;

        @Nonnull
        public SimpleRepositorySize build() {
            return new SimpleRepositorySize(this);
        }

        @Nonnull
        public Builder garbageSize(long value) {
            this.garbageSize = value;
            return this;
        }

        @Nonnull
        public Builder inPackSize(long value) {
            this.inPackSize = value;
            return this;
        }

        @Nonnull
        public Builder looseSize(long value) {
            this.looseSize = value;
            return this;
        }
    }
}

