/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.command.log;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcRevListOptionsOrBuilder;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.CommandUsageException;
import com.atlassian.stash.internal.scm.git.command.revlist.RevCoreExitHandler;
import jakarta.annotation.Nonnull;
import java.util.Collections;
import java.util.Set;

public class LogCommandExitHandler
extends RevCoreExitHandler {
    private static final String FOLLOW_ONE_PATH = "fatal: --follow requires exactly one pathspec";

    public LogCommandExitHandler(@Nonnull I18nService i18nService, @Nonnull Repository repository, boolean ignoreMissing) {
        this(i18nService, repository, Collections.emptySet(), Collections.emptySet(), ignoreMissing);
    }

    public LogCommandExitHandler(@Nonnull I18nService i18nService, @Nonnull Repository repository, @Nonnull RpcRevListOptionsOrBuilder options) {
        super(i18nService, repository, options);
    }

    public LogCommandExitHandler(@Nonnull I18nService i18nService, @Nonnull Repository repository, @Nonnull Set<String> includes, @Nonnull Set<String> excludes, boolean ignoreMissing) {
        super(i18nService, repository, includes, excludes, ignoreMissing);
    }

    @Override
    protected void onError(String command, int exitCode, String stderr, Throwable thrown) {
        if (stderr != null && stderr.startsWith(FOLLOW_ONE_PATH)) {
            throw new CommandUsageException(this.i18nService.createKeyedMessage("bitbucket.git.log.followonepath", new Object[0]), command, stderr);
        }
        super.onError(command, exitCode, stderr, thrown);
    }
}

