/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.command.revlist;

import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.commit.SimpleCommit;
import com.atlassian.bitbucket.dmz.process.CommitPump;
import com.atlassian.bitbucket.dmz.process.CommitSink;
import com.atlassian.bitbucket.dmz.process.LineStdoutHandler;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.git.GitUtils;
import com.atlassian.bitbucket.scm.git.command.CommitReaderSettings;
import com.atlassian.bitbucket.scm.git.command.diff.GitChangeType;
import com.atlassian.stash.internal.scm.git.command.revlist.RevListStdoutHandler;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import jakarta.annotation.Nonnull;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractCommitRevListStdoutHandler<T>
extends LineStdoutHandler<T>
implements RevListStdoutHandler<T> {
    public static final String NAME_STATUS_CHANGE = "change";
    private final CommitPump commitPump;
    private final boolean withPaths;
    private Commit commit;
    private String path;
    private LineType nextLineType;

    protected AbstractCommitRevListStdoutHandler(Repository repository, boolean withMessages, boolean withPaths, int maxMessageLength, String path) {
        this(new CommitReaderSettings.Builder().repository(repository).withMessages(withMessages).maxMessageLength(maxMessageLength).build(), withPaths, path);
    }

    protected AbstractCommitRevListStdoutHandler(Repository repository, boolean withMessages, boolean withPaths, int maxMessageLength, Iterable<String> paths) {
        this(new CommitReaderSettings.Builder().repository(repository).withMessages(withMessages).maxMessageLength(maxMessageLength).build(), withPaths, withPaths && paths != null ? (String)Iterables.getFirst(paths, null) : null);
    }

    private AbstractCommitRevListStdoutHandler(CommitReaderSettings settings, boolean withPaths, String path) {
        super(StandardCharsets.UTF_8);
        Preconditions.checkArgument((!withPaths || path != null ? 1 : 0) != 0);
        this.nextLineType = LineType.COMMIT;
        this.path = path;
        this.withPaths = withPaths;
        this.commitPump = new CommitPump(settings, new CommitSink(){

            public void onCommit(@Nonnull Commit commit) {
                AbstractCommitRevListStdoutHandler.this.commit = commit;
            }

            public void onPartialMessage(int maxLength) {
                AbstractCommitRevListStdoutHandler.this.setMaxLineLength(maxLength);
            }
        });
    }

    @Override
    @Nonnull
    public String getFormat() {
        return this.commitPump.getFormat();
    }

    protected boolean onStdout(@Nonnull String line, boolean ignored) {
        if (this.nextLineType != LineType.COMMIT && line.startsWith("commit") && !this.flushCommit(LineType.COMMIT)) {
            return false;
        }
        if (this.nextLineType == LineType.COMMIT) {
            this.commitPump.onStdout(line);
            if (this.commit != null && this.withPaths) {
                this.nextLineType = LineType.NAME_STATUS;
                return true;
            }
            return this.flushCommit();
        }
        if (this.nextLineType == LineType.NAME_STATUS && StringUtils.isNotEmpty((CharSequence)line) && this.maybeParseNameStatus(line)) {
            return this.flushCommit(LineType.SKIP);
        }
        return true;
    }

    protected void onStdoutClosed() {
        if (this.commit != null) {
            this.onCommit(this.commit);
        }
    }

    protected abstract boolean onCommit(Commit var1);

    private boolean flushCommit(LineType to) {
        try {
            boolean bl = this.flushCommit();
            return bl;
        }
        finally {
            this.nextLineType = to;
        }
    }

    private boolean flushCommit() {
        Commit current = this.commit;
        this.commit = null;
        return current == null || this.onCommit(current);
    }

    private boolean maybeParseNameStatus(String line) {
        String beforePath;
        String afterPath;
        int firstTab = line.indexOf(9);
        if (firstTab == -1) {
            throw new IllegalArgumentException("[" + line + "] does not contain a tab");
        }
        String metadata = line.substring(0, firstTab);
        String paths = line.substring(firstTab + 1);
        GitChangeType type = GitChangeType.fromStatus((String)metadata.substring(0, 1));
        if (type == GitChangeType.COPY || type == GitChangeType.RENAME) {
            int secondTab = paths.indexOf(9);
            if (secondTab == -1) {
                throw new IllegalStateException("[" + line + "] indicates a copy or rename, but only a single path was provided");
            }
            afterPath = GitUtils.unescapeQuoted((String)paths.substring(secondTab + 1));
            beforePath = GitUtils.unescapeQuoted((String)paths.substring(0, secondTab));
        } else {
            afterPath = GitUtils.unescapeQuoted((String)paths);
            beforePath = null;
        }
        if (afterPath.equals(this.path)) {
            ImmutableMap.Builder builder = ImmutableMap.builder().put((Object)"type", (Object)type.getType()).put((Object)"path", (Object)afterPath);
            if (beforePath != null) {
                builder.put((Object)"srcPath", (Object)beforePath).put((Object)"percentUnchanged", (Object)Integer.parseInt(metadata.substring(1, firstTab)));
                this.path = beforePath;
            }
            this.commit = ((SimpleCommit.Builder)new SimpleCommit.Builder(this.commit).property(NAME_STATUS_CHANGE, (Object)builder.build())).build();
            return true;
        }
        return false;
    }

    private static enum LineType {
        COMMIT,
        NAME_STATUS,
        SKIP;

    }
}

