/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.command.revlist;

import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.commit.CommitCallback;
import com.atlassian.bitbucket.commit.CommitContext;
import com.atlassian.bitbucket.commit.CommitSummary;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.CommandResult;
import com.atlassian.bitbucket.scm.CommandSummary;
import com.atlassian.bitbucket.scm.CommandSummaryHandler;
import com.atlassian.bitbucket.scm.CommitsCommandParameters;
import com.atlassian.bitbucket.util.AbstractSummary;
import com.atlassian.stash.internal.scm.git.command.revlist.AbstractCommitRevListStdoutHandler;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;

public class CallbackRevListStdoutHandler
extends AbstractCommitRevListStdoutHandler<Void>
implements CommandSummaryHandler {
    private final CommitCallback callback;
    private final CommitContext context;
    private int added;
    private int toSkip;

    public CallbackRevListStdoutHandler(Repository repository, CommitCallback callback) {
        this(repository, callback, new CommitContext.Builder().build(), true, false, -1, null);
    }

    public CallbackRevListStdoutHandler(Repository repository, CommitCallback callback, int maxMessageLength) {
        this(repository, callback, new CommitContext.Builder().build(), maxMessageLength != 0, false, maxMessageLength, null);
    }

    public CallbackRevListStdoutHandler(Repository repository, CommitCallback callback, CommitsCommandParameters parameters) {
        this(repository, callback, parameters.toContext(), parameters.isWithMessages(), parameters.isFollowingRenames(), parameters.getMaxMessageLength(), parameters.getPaths());
    }

    private CallbackRevListStdoutHandler(Repository repository, CommitCallback callback, CommitContext context, boolean withMessages, boolean withPaths, int maxMessageLength, Collection<String> paths) {
        super(repository, withMessages, withPaths, maxMessageLength, paths);
        this.callback = callback;
        this.context = context;
    }

    public Void getOutput() {
        return null;
    }

    public void onComplete(@Nonnull CommandSummary summary) throws IOException {
        if (this.added > 0) {
            this.callback.onEnd(new CommitSummary.Builder((AbstractSummary)summary).build());
        } else if (summary.getResult() == CommandResult.SUCCEEDED) {
            this.callback.onStart(this.context);
            this.callback.onEnd(new CommitSummary.Builder((AbstractSummary)summary).build());
        }
    }

    public void setSkip(int value) {
        this.toSkip = value;
    }

    @Override
    protected boolean onCommit(Commit commit) {
        if (this.toSkip > 0) {
            --this.toSkip;
            return true;
        }
        try {
            if (this.added++ == 0) {
                this.callback.onStart(this.context);
            }
            return this.callback.onCommit(commit);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

