/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.command.revlist;

import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.CommitsCommandParameters;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.stash.internal.scm.git.command.revlist.AbstractCommitRevListStdoutHandler;
import java.util.ArrayList;
import java.util.List;

public class PagedCommitRevListStdoutHandler
extends AbstractCommitRevListStdoutHandler<Page<Commit>> {
    private final List<Commit> commits;
    private final PageRequest pageRequest;
    private int toSkip;

    public PagedCommitRevListStdoutHandler(Repository repository, CommitsCommandParameters parameters, PageRequest pageRequest) {
        this(repository, parameters, 0, pageRequest);
    }

    public PagedCommitRevListStdoutHandler(Repository repository, CommitsCommandParameters parameters, int skip, PageRequest pageRequest) {
        super(repository, parameters.isWithMessages(), parameters.isFollowingRenames(), parameters.getMaxMessageLength(), parameters.getPaths());
        this.pageRequest = pageRequest;
        this.commits = new ArrayList<Commit>(pageRequest.getLimit() + 1);
        this.toSkip = skip;
    }

    public Page<Commit> getOutput() {
        return PageUtils.createPage(this.commits, (PageRequest)this.pageRequest);
    }

    @Override
    protected boolean onCommit(Commit commit) {
        if (this.toSkip > 0) {
            --this.toSkip;
            return true;
        }
        this.commits.add(commit);
        return this.commits.size() <= this.pageRequest.getLimit();
    }
}

