/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.command.revlist;

import com.atlassian.bitbucket.commit.NoSuchCommitException;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.mesh.rpc.util.ByteStringUtils;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcRevListOptionsOrBuilder;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.git.command.GitCommandExitHandler;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;

public class RevCoreExitHandler
extends GitCommandExitHandler {
    private final boolean ignoreMissing;
    private final Set<String> revs;

    public RevCoreExitHandler(@Nonnull I18nService i18nService, @Nonnull Repository repository, @Nonnull Collection<String> revs, boolean ignoreMissing) {
        this(i18nService, repository, revs.stream(), ignoreMissing);
    }

    public RevCoreExitHandler(@Nonnull I18nService i18nService, @Nonnull Repository repository, @Nonnull RpcRevListOptionsOrBuilder options) {
        this(i18nService, repository, ByteStringUtils.toStrings((List)options.getRevsList()), options.getIgnoreMissing());
    }

    public RevCoreExitHandler(@Nonnull I18nService i18nService, @Nonnull Repository repository, @Nonnull Set<String> includes, @Nonnull Set<String> excludes, boolean ignoreMissing) {
        this(i18nService, repository, Stream.concat(includes.stream().limit(3L), excludes.stream().limit(3L)), ignoreMissing);
    }

    private RevCoreExitHandler(@Nonnull I18nService i18nService, @Nonnull Repository repository, @Nonnull Stream<String> revs, boolean ignoreMissing) {
        super(i18nService, repository);
        this.ignoreMissing = ignoreMissing;
        this.revs = (Set)revs.limit(6L).collect(MoreCollectors.toImmutableSet());
    }

    protected void onError(String command, int exitCode, String stderr, Throwable thrown) {
        if (stderr != null && stderr.startsWith("usage")) {
            if (this.ignoreMissing) {
                return;
            }
            if (!this.revs.isEmpty()) {
                throw new NoSuchCommitException(this.i18nService.createKeyedMessage("bitbucket.service.repository.commitsnotfound", new Object[]{this.repository.getName(), Joiner.on((String)", ").join(this.revs)}), (String)Iterables.getFirst(this.revs, null));
            }
        }
        super.onError(command, exitCode, stderr, thrown);
    }
}

