/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.command.revlist;

import com.atlassian.bitbucket.dmz.process.LineStdinHandler;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import java.util.Set;

public class RevListStdinHandler
extends LineStdinHandler {
    public RevListStdinHandler(Iterable<String> refs) {
        super(refs);
    }

    @Nonnull
    public static RevListStdinHandler excludingRefs(@Nonnull Set<String> refs) {
        return new RevListStdinHandler(RevListStdinHandler.asExclusions(refs));
    }

    @Nonnull
    public static RevListStdinHandler forRefs(Set<String> include, Set<String> exclude) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        if (include != null) {
            builder.addAll(include);
        }
        if (exclude != null) {
            builder.addAll(RevListStdinHandler.asExclusions(exclude));
        }
        return new RevListStdinHandler((Iterable<String>)builder.build());
    }

    private static Set<String> asExclusions(@Nonnull Set<String> refs) {
        return (Set)refs.stream().map(ref -> "^" + ref).collect(MoreCollectors.toImmutableSet());
    }
}

