/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.command.revlist;

import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.commit.MinimalCommit;
import com.atlassian.bitbucket.commit.SimpleCommit;
import com.atlassian.bitbucket.content.NoSuchPathException;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.stash.internal.scm.git.command.revlist.AbstractCommitRevListStdoutHandler;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class SingleCommitRevListStdoutHandler
extends AbstractCommitRevListStdoutHandler<Commit> {
    private final String commitId;
    private final Map<String, Commit> commitsById;
    private final I18nService i18nService;
    private final String path;

    public SingleCommitRevListStdoutHandler(I18nService i18nService, Repository repository, String commitId, String path) {
        this(i18nService, repository, commitId, path, true, false);
    }

    public SingleCommitRevListStdoutHandler(I18nService i18nService, Repository repository, String commitId, String path, boolean withMessages, boolean withPaths) {
        this(i18nService, repository, commitId, path, withMessages, withPaths, -1);
    }

    public SingleCommitRevListStdoutHandler(I18nService i18nService, Repository repository, String commitId, String path, boolean withMessages, boolean withPaths, int maxMessageSize) {
        super(repository, withMessages, withPaths, maxMessageSize, path);
        this.commitId = commitId;
        this.i18nService = i18nService;
        this.path = path;
        this.commitsById = new LinkedHashMap<String, Commit>();
    }

    public Commit getOutput() {
        Commit commit = this.commitsById.get(this.commitId);
        if (commit == null && (commit = (Commit)Iterables.getFirst(this.commitsById.values(), null)) == null) {
            throw new NoSuchPathException(this.i18nService.createKeyedMessage("bitbucket.service.repository.pathnotfound.atrevision", new Object[]{this.path, this.commitId}), this.path, this.commitId);
        }
        return this.replaceParents(commit);
    }

    @Override
    protected boolean onCommit(Commit commit) {
        this.commitsById.put(commit.getId(), commit);
        return true;
    }

    private Commit replaceParents(Commit commit) {
        Collection minimalParents = commit.getParents();
        ArrayList<MinimalCommit> parents = new ArrayList<MinimalCommit>(minimalParents.size());
        for (MinimalCommit minimalParent : minimalParents) {
            parents.add((MinimalCommit)MoreObjects.firstNonNull((Object)((MinimalCommit)this.commitsById.get(minimalParent.getId())), (Object)minimalParent));
        }
        return new SimpleCommit.Builder(commit).clearParents().parents(parents).build();
    }
}

