/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.hosting;

import com.atlassian.bitbucket.scm.git.protocol.GitScmRequestType;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.atlassian.stash.internal.scm.git.hosting.HookResult;
import com.atlassian.util.contentcache.CacheResult;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;

public class HostingResult {
    private final CacheResult cacheResult;
    private final String filter;
    private final HookResult hookResult;
    private final GitScmRequestType operationType;
    private final Integer protocolVersion;

    private HostingResult(@Nonnull Builder builder) {
        this.cacheResult = builder.cacheResult;
        this.filter = builder.filter;
        this.hookResult = Objects.requireNonNull(builder.hookResult, "hookResult");
        this.operationType = builder.operationType;
        this.protocolVersion = builder.protocolVersion;
    }

    @Nullable
    public CacheResult getCacheResult() {
        return this.cacheResult;
    }

    @Nullable
    public String getFilter() {
        return this.filter;
    }

    @Nonnull
    public HookResult getHookResult() {
        return this.hookResult;
    }

    @Nonnull
    public GitScmRequestType getOperationType() {
        return this.operationType;
    }

    @Nullable
    public Integer getProtocolVersion() {
        return this.protocolVersion;
    }

    public static class Builder
    extends BuilderSupport {
        private CacheResult cacheResult;
        private String filter;
        private HookResult hookResult;
        private GitScmRequestType operationType;
        private Integer protocolVersion;

        public Builder(@Nonnull GitScmRequestType operationType) {
            this.operationType = Objects.requireNonNull(operationType, "operationType");
        }

        @Nonnull
        public HostingResult build() {
            return new HostingResult(this);
        }

        @Nonnull
        public Builder cacheResult(@Nullable CacheResult value) {
            this.cacheResult = value;
            return this;
        }

        @Nonnull
        public Builder filter(@Nullable String value) {
            this.filter = value;
            return this;
        }

        @Nonnull
        public Builder hookResult(@Nonnull HookResult hookResult) {
            this.hookResult = hookResult;
            return this;
        }

        @Nonnull
        public Builder operationType(@Nonnull GitScmRequestType value) {
            this.operationType = Objects.requireNonNull(value, "operationType");
            return this;
        }

        @Nonnull
        public Builder protocolVersion(@Nullable Integer value) {
            this.protocolVersion = value;
            return this;
        }
    }
}

