/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.io;

import com.atlassian.stash.internal.scm.git.command.catfile.BatchHeader;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;

public class ByteSegmentReader {
    private final ByteArrayOutputStream buffer;
    private final InputStream inputStream;
    private final int maxBufferSize;
    private final int terminator;

    public ByteSegmentReader(@Nonnull InputStream inputStream) {
        this(inputStream, 10, BatchHeader.MAX_SIZE_IN_BYTES);
    }

    public ByteSegmentReader(@Nonnull InputStream inputStream, byte terminator, int maxBufferSize) {
        this.inputStream = Objects.requireNonNull(inputStream, "inputStream");
        this.maxBufferSize = maxBufferSize;
        this.terminator = terminator;
        this.buffer = new ByteArrayOutputStream(maxBufferSize);
    }

    @Nullable
    public byte[] readSegment() throws IOException {
        int read;
        this.buffer.reset();
        while ((read = this.inputStream.read()) != -1) {
            if (read == this.terminator) {
                return this.buffer.toByteArray();
            }
            if (this.buffer.size() < this.maxBufferSize) {
                this.buffer.write(read);
                continue;
            }
            throw new IllegalStateException("Maximum buffer size of " + this.maxBufferSize + " exceeded");
        }
        if (this.buffer.size() > 0) {
            return this.buffer.toByteArray();
        }
        return null;
    }
}

