/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.io;

import com.atlassian.stash.internal.scm.git.command.catfile.BatchHeader;
import jakarta.annotation.Nonnull;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;

public class ByteSegmentScanner {
    private final int maxSegmentSize;
    private final int terminator;

    public ByteSegmentScanner() {
        this(10, BatchHeader.MAX_SIZE_IN_BYTES);
    }

    public ByteSegmentScanner(byte terminator, int maxSegmentSize) {
        this.maxSegmentSize = maxSegmentSize;
        this.terminator = terminator;
    }

    public ByteBuffer scan(@Nonnull ByteBuffer output, boolean closed) {
        if (output.remaining() == 0) {
            return null;
        }
        int limit = output.limit();
        for (int i = output.position(); i < limit; ++i) {
            if (output.get(i) != this.terminator) continue;
            ByteBuffer segment = output.slice();
            segment.limit(i - output.position());
            output.position(i + 1);
            return segment;
        }
        int remaining = output.remaining();
        if (closed && remaining <= this.maxSegmentSize) {
            ByteBuffer segment = output.slice();
            output.position(output.position() + output.remaining());
            return segment;
        }
        if (remaining > this.maxSegmentSize) {
            output.mark();
            String actualData = StandardCharsets.UTF_8.decode(output).toString();
            output.reset();
            throw new IllegalStateException("Maximum segment size of " + this.maxSegmentSize + " exceeded. Data was '" + actualData + "'");
        }
        return null;
    }
}

