/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.io;

import jakarta.annotation.Nullable;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.util.Objects;

public class NullTerminatedReader
implements Closeable {
    private final BufferedReader reader;
    private final StringBuilder buffer;

    public NullTerminatedReader(BufferedReader reader) {
        this.reader = Objects.requireNonNull(reader, "reader");
        this.buffer = new StringBuilder();
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    @Nullable
    public String readSegment() throws IOException {
        int read;
        this.buffer.setLength(0);
        while ((read = this.reader.read()) != -1 && read != 0) {
            this.buffer.append((char)read);
        }
        if (read == -1) {
            return null;
        }
        return this.buffer.toString();
    }
}

