/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.merge;

import com.atlassian.bitbucket.mesh.rpc.v1.RpcMergeStrategy;
import com.atlassian.bitbucket.scm.PluginMergeStrategy;
import jakarta.annotation.Nonnull;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;

public enum GitMergeStrategy implements PluginMergeStrategy
{
    FF("ff", "--ff", RpcMergeStrategy.MERGE_STRATEGY_FF),
    FF_ONLY("ff-only", "--ff-only", RpcMergeStrategy.MERGE_STRATEGY_FF_ONLY),
    NO_FF("no-ff", "--no-ff", true, RpcMergeStrategy.MERGE_STRATEGY_NO_FF),
    REBASE_FF_ONLY("rebase-ff-only", "rebase + merge --ff-only", RpcMergeStrategy.MERGE_STRATEGY_REBASE_FF_ONLY),
    REBASE_NO_FF("rebase-no-ff", "rebase + merge --no-ff", RpcMergeStrategy.MERGE_STRATEGY_REBASE_NO_FF),
    SQUASH("squash", "--squash", RpcMergeStrategy.MERGE_STRATEGY_SQUASH),
    SQUASH_FF_ONLY("squash-ff-only", "--squash --ff-only", RpcMergeStrategy.MERGE_STRATEGY_SQUASH_FF_ONLY);

    private final String descriptionKey;
    private final String flag;
    private final String id;
    private final boolean isDefault;
    private final RpcMergeStrategy rpcMergeStrategy;
    private final String nameKey;

    private GitMergeStrategy(String id, String flag, RpcMergeStrategy rpcMergeStrategy) {
        this(id, flag, false, rpcMergeStrategy);
    }

    private GitMergeStrategy(String id, String flag, boolean isDefault, RpcMergeStrategy rpcMergeStrategy) {
        this.flag = flag;
        this.id = id;
        this.isDefault = isDefault;
        this.rpcMergeStrategy = rpcMergeStrategy;
        this.nameKey = "bitbucket.git.mergestrategy." + id;
        this.descriptionKey = this.nameKey + ".description";
    }

    @Nonnull
    public static Optional<GitMergeStrategy> fromId(@Nonnull String id) {
        Objects.requireNonNull(id, "id");
        return Arrays.stream(GitMergeStrategy.values()).filter(strategy -> id.equals(strategy.id)).findFirst();
    }

    public static GitMergeStrategy fromRpc(@Nonnull RpcMergeStrategy rpc) {
        switch (Objects.requireNonNull(rpc, "rpc")) {
            case MERGE_STRATEGY_FF: {
                return FF;
            }
            case MERGE_STRATEGY_FF_ONLY: {
                return FF_ONLY;
            }
            case MERGE_STRATEGY_REBASE_FF_ONLY: {
                return REBASE_FF_ONLY;
            }
            case MERGE_STRATEGY_REBASE_NO_FF: {
                return REBASE_NO_FF;
            }
            case MERGE_STRATEGY_SQUASH: {
                return SQUASH;
            }
            case MERGE_STRATEGY_SQUASH_FF_ONLY: {
                return SQUASH_FF_ONLY;
            }
        }
        return NO_FF;
    }

    @Nonnull
    public String getDescriptionKey() {
        return this.descriptionKey;
    }

    @Nonnull
    public Optional<String> getFlag() {
        return Optional.of(this.flag);
    }

    @Nonnull
    public String getId() {
        return this.id;
    }

    @Nonnull
    public String getNameKey() {
        return this.nameKey;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    @Nonnull
    public RpcMergeStrategy toRpc() {
        return this.rpcMergeStrategy;
    }
}

