/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.dmz.process.NioStdioHandler;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.mesh.rpc.util.ByteStringUtils;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcStreamChunk;
import com.atlassian.bitbucket.scm.CommandExitHandler;
import com.atlassian.stash.internal.scm.git.hosting.HostingResult;
import com.atlassian.stash.internal.scm.git.mesh.AbstractHostingFragmentResponseObserver;
import com.atlassian.stash.internal.scm.git.mesh.ErrorTranslator;
import com.atlassian.stash.internal.scm.git.mesh.RequestFragmentCreator;
import com.google.protobuf.ByteString;
import io.grpc.Status;
import io.grpc.stub.ClientCallStreamObserver;
import jakarta.annotation.Nonnull;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;

abstract class AbstractBidirectionalHostingFragmentResponseObserver<ReqT, RespT>
extends AbstractHostingFragmentResponseObserver<ReqT, RespT> {
    protected BidirectionalRemoteProcess process;
    private final RequestFragmentCreator<ReqT> fragmentCreator;

    AbstractBidirectionalHostingFragmentResponseObserver(@Nonnull NioStdioHandler<Void> stdioHandler, @Nonnull ErrorTranslator errorTranslator, @Nonnull CommandExitHandler exitHandler, @Nonnull RequestFragmentCreator<ReqT> fragmentCreator, @Nonnull I18nService i18nService) {
        super(stdioHandler, errorTranslator, exitHandler, i18nService);
        this.fragmentCreator = Objects.requireNonNull(fragmentCreator, "fragmentCreator");
    }

    @Override
    protected AbstractHostingFragmentResponseObserver.RemoteProcess<ReqT> createProcess(ClientCallStreamObserver<ReqT> requestStream) {
        return this.setProcess(new BidirectionalRemoteProcess(requestStream));
    }

    protected <T extends BidirectionalRemoteProcess> T setProcess(T process) {
        this.process = process;
        return process;
    }

    @Override
    HostingResult asResult() {
        this.addListener((result, thrown) -> this.process.onComplete());
        this.process.run();
        return super.asResult();
    }

    protected class BidirectionalRemoteProcess
    extends AbstractHostingFragmentResponseObserver.RemoteProcess<ReqT>
    implements Runnable {
        protected final AtomicBoolean closeRequested;
        private final AtomicBoolean closeSent;
        private final ByteBuffer stdin;
        private final BlockingQueue<Runnable> tasks;
        private final AtomicBoolean writeRequested;

        BidirectionalRemoteProcess(ClientCallStreamObserver<ReqT> requestStream) {
            super(requestStream);
            this.closeRequested = new AtomicBoolean();
            this.closeSent = new AtomicBoolean();
            this.stdin = ByteBuffer.allocate(65536);
            this.tasks = new LinkedBlockingQueue<Runnable>();
            this.writeRequested = new AtomicBoolean();
            requestStream.setOnReadyHandler(this::onReady);
        }

        @Override
        public void cancel() {
            super.cancel();
        }

        public void closeStdin(boolean force) {
            if (force) {
                this.closeRequested.set(true);
                if (this.closeSent.compareAndSet(false, true)) {
                    this.callOnNext(ByteString.EMPTY, true);
                }
            } else if (this.closeRequested.compareAndSet(false, true)) {
                this.tasks.offer(() -> {
                    if (this.closeSent.compareAndSet(false, true)) {
                        this.sendStdin(ByteString.EMPTY, true);
                    }
                });
            }
        }

        public boolean hasPendingWrites() {
            return !this.requestStream.isReady();
        }

        @Override
        public void run() {
            this.requestStream.onNext(AbstractBidirectionalHostingFragmentResponseObserver.this.fragmentCreator.getInitial());
            try {
                Runnable task;
                while ((task = this.tasks.take()) != this) {
                    try {
                        task.run();
                    }
                    catch (Exception e) {
                        this.requestStream.onError((Throwable)e);
                        break;
                    }
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.requestStream.onError((Throwable)Status.ABORTED.withDescription("Interrupted while waiting for the request to complete").asRuntimeException());
            }
        }

        public void wantWrite() {
            if (!this.isStarted()) {
                throw new IllegalStateException("Wait until onStart to call wantWrite");
            }
            if (this.closeRequested.get()) {
                throw new IllegalStateException("wantWrite cannot be called after stdin is closed");
            }
            this.writeRequested.set(true);
            this.tasks.offer(this::runStdinLoop);
        }

        public void writeStdin(@Nonnull ByteBuffer buffer) {
            if (!this.isStarted()) {
                throw new IllegalStateException("Wait until onStart to call writeStdin");
            }
            if (this.closeRequested.get()) {
                throw new IllegalStateException("writeStdin cannot be called after stdin is closed");
            }
            this.callOnNext(ByteStringUtils.unsafeWrap((ByteBuffer)buffer), false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void onComplete() {
            this.tasks.offer(this);
            ByteBuffer byteBuffer = this.stdin;
            synchronized (byteBuffer) {
                this.stdin.notifyAll();
            }
        }

        private void callOnNext(ByteString data, boolean closed) {
            this.requestStream.onNext(AbstractBidirectionalHostingFragmentResponseObserver.this.fragmentCreator.forStdin(RpcStreamChunk.newBuilder().setClosed(closed).setData(data).build()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onReady() {
            ByteBuffer byteBuffer = this.stdin;
            synchronized (byteBuffer) {
                this.stdin.notify();
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean requireReady() {
            if (this.requestStream.isReady()) {
                return true;
            }
            ByteBuffer byteBuffer = this.stdin;
            synchronized (byteBuffer) {
                while (!(this.isCanceled() || AbstractBidirectionalHostingFragmentResponseObserver.this.isDone() || this.closeSent.get())) {
                    if (this.requestStream.isReady()) {
                        return true;
                    }
                    try {
                        this.stdin.wait(3000L);
                    }
                    catch (InterruptedException e) {
                        if (this.isCanceled()) {
                            AbstractBidirectionalHostingFragmentResponseObserver.this.log.debug("Canceled while waiting to write stdin");
                            return false;
                        }
                        Thread.currentThread().interrupt();
                        throw Status.ABORTED.withCause((Throwable)e).withDescription("Interrupted while waiting to write stdin").asRuntimeException();
                    }
                }
                return false;
            }
        }

        private void runStdinLoop() {
            boolean more;
            if (!this.writeRequested.compareAndSet(true, false) || this.closeRequested.get() || AbstractBidirectionalHostingFragmentResponseObserver.this.isDone()) {
                return;
            }
            do {
                more = AbstractBidirectionalHostingFragmentResponseObserver.this.stdioHandler.onStdinReady(this.stdin);
                boolean closed = this.closeRequested.get();
                boolean hasStdin = this.stdin.hasRemaining();
                if (hasStdin || closed) {
                    this.sendStdin(ByteStringUtils.unsafeWrap((ByteBuffer)this.stdin), closed);
                    if (closed) {
                        this.closeSent.set(true);
                        break;
                    }
                    if (AbstractBidirectionalHostingFragmentResponseObserver.this.isDone()) break;
                }
                this.stdin.clear();
            } while (more);
        }

        private void sendStdin(ByteString data, boolean closed) {
            if (this.requireReady()) {
                this.callOnNext(data, closed);
            }
        }
    }
}

