/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.dmz.process.NioProcess;
import com.atlassian.bitbucket.dmz.process.NioStdioHandler;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcStreamChunk;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcStreamFragment;
import com.atlassian.bitbucket.scm.CommandExitHandler;
import com.atlassian.bitbucket.scm.CommandFailedException;
import com.atlassian.bitbucket.scm.CommandResult;
import com.atlassian.bitbucket.scm.CommandSummary;
import com.atlassian.bitbucket.scm.CommandSummaryHandler;
import com.atlassian.bitbucket.scm.CommandTimeoutException;
import com.atlassian.bitbucket.scm.ProcessFailedException;
import com.atlassian.stash.internal.scm.git.mesh.AbstractFutureResponseObserver;
import com.atlassian.stash.internal.scm.git.mesh.ErrorTranslator;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.ClientCallStreamObserver;
import jakarta.annotation.Nonnull;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractFragmentResponseObserver<ReqT, T>
extends AbstractFutureResponseObserver<ReqT, RpcStreamFragment, T> {
    protected final Logger log;
    protected final NioStdioHandler<T> stdioHandler;
    private final CommandExitHandler exitHandler;
    private final I18nService i18nService;
    private final StderrCallback stderrCallback;
    private final StdoutCallback stdoutCallback;
    private int exitCode;
    private RemoteProcess<ReqT> process;
    private HandlerState state;
    private StringBuilder stderrBuffer;
    private Throwable thrown;

    AbstractFragmentResponseObserver(@Nonnull NioStdioHandler<T> stdioHandler, @Nonnull ErrorTranslator errorTranslator, @Nonnull CommandExitHandler exitHandler, @Nonnull I18nService i18nService) {
        super(Objects.requireNonNull(errorTranslator, "errorTranslator"));
        this.exitHandler = Objects.requireNonNull(exitHandler, "exitHandler");
        this.i18nService = Objects.requireNonNull(i18nService, "i18nService");
        this.stdioHandler = Objects.requireNonNull(stdioHandler, "stdioHandler");
        this.exitCode = -1002;
        this.log = LoggerFactory.getLogger(this.getClass());
        this.state = HandlerState.CREATED;
        this.stderrCallback = new StderrCallback();
        this.stdoutCallback = new StdoutCallback();
    }

    @Override
    public void beforeStart(ClientCallStreamObserver<ReqT> requestStream) {
        super.beforeStart(requestStream);
        this.process = this.createProcess(requestStream);
        this.invokeCallback(() -> this.stdioHandler.onPreStart(this.process));
    }

    @Override
    public void onCompleted() {
    }

    @Override
    public void onError(Throwable t) {
        Status.Code code = Status.fromThrowable((Throwable)t).getCode();
        if (code == Status.Code.CANCELLED) {
            if (this.isCanceled()) {
                t = null;
            }
        } else if (this.thrown == null && code == Status.Code.DEADLINE_EXCEEDED) {
            t = new CommandTimeoutException(this.i18nService.createKeyedMessage("bitbucket.scm.command.timeout", new Object[]{this.getCommandLine(), "unknown"}));
        }
        if (t != null) {
            this.setOrUpdateThrown(t);
        }
        this.finish(-1001);
    }

    public void onNext(RpcStreamFragment fragment) {
        switch (fragment.getFragmentOneofCase()) {
            case RESULT: {
                this.callOnExit(fragment.getResult().getExitCode());
                break;
            }
            case START: {
                this.callOnStart(fragment.getStart().getCommandLine().toStringUtf8());
                break;
            }
            case STDERR: {
                this.stderrCallback.onChunk(fragment.getStderr());
                break;
            }
            case STDOUT: {
                this.stdoutCallback.onChunk(fragment.getStdout());
            }
        }
    }

    protected abstract RemoteProcess<ReqT> createProcess(ClientCallStreamObserver<ReqT> var1);

    @Override
    T asResult() {
        super.asResult();
        this.callExitHandler();
        return (T)this.stdioHandler.getOutput();
    }

    @Override
    boolean isCanceled() {
        return super.isCanceled() || this.process != null && this.process.isCanceled();
    }

    private void callExitHandler() {
        String stderr;
        boolean canceled = this.isCanceled();
        String commandLine = this.getCommandLine();
        String string = stderr = this.stderrBuffer == null ? null : StringUtils.chomp((String)this.stderrBuffer.toString());
        if (this.thrown == null && !canceled && this.exitCode != 0) {
            KeyedMessage message = StringUtils.isBlank((CharSequence)stderr) ? this.i18nService.createKeyedMessage("bitbucket.scm.command.failed", new Object[]{commandLine, this.exitCode}) : this.i18nService.createKeyedMessage("bitbucket.scm.command.failed.saying", new Object[]{commandLine, this.exitCode, stderr});
            this.thrown = new ProcessFailedException(message, this.exitCode);
        } else if (this.thrown instanceof StatusRuntimeException) {
            this.thrown = this.errorTranslator.maybeTranslate(this.thrown);
        }
        if (canceled) {
            this.exitHandler.onCancel(commandLine, this.exitCode, stderr, this.thrown);
        } else {
            this.exitHandler.onExit(commandLine, this.exitCode, stderr, this.thrown);
        }
    }

    private void callOnExit(int exitCode) {
        this.process.onExit();
        try {
            this.stdioHandler.onExit(exitCode);
        }
        catch (Throwable t) {
            if (this.thrown != null) {
                t.addSuppressed(this.thrown);
            }
            this.thrown = t;
        }
        this.finish(exitCode);
    }

    private void callOnStart(String commandLine) {
        this.process.onStart(commandLine);
        this.state = HandlerState.STARTED;
        this.invokeCallback(() -> this.stdioHandler.onStart(this.process));
    }

    private void ensureStarted() {
        if (this.state == HandlerState.CREATED) {
            CommandFailedException e = new CommandFailedException(this.i18nService.createKeyedMessage("bitbucket.scm.command.not-started", new Object[]{"Unknown"}));
            this.setOrUpdateThrown((Throwable)e);
        }
    }

    private void finish(int code) {
        if (this.state == HandlerState.FINISHED) {
            return;
        }
        this.exitCode = code;
        try {
            this.ensureStarted();
            this.maybeSummarize();
            super.onCompleted();
        }
        finally {
            this.state = HandlerState.FINISHED;
        }
    }

    private String getCommandLine() {
        return this.process == null ? "<Unknown>" : this.process.toString();
    }

    private void invokeCallback(Runnable callback) {
        try {
            callback.run();
        }
        catch (Throwable t) {
            this.setOrUpdateThrown(t);
            this.log.debug("[{}]: Destroying after handler failure", this.process, (Object)t);
            this.process.abort();
        }
    }

    private boolean maybeAbort() {
        if (this.thrown == null) {
            return false;
        }
        this.log.debug("[{}]: Dropping callback invocation", this.process, (Object)this.thrown);
        this.process.abort();
        return true;
    }

    private void maybeSummarize() {
        if (this.stdioHandler instanceof CommandSummaryHandler) {
            CommandResult result = this.isCanceled() ? CommandResult.CANCELED : (this.exitCode == 0 && this.thrown == null ? CommandResult.SUCCEEDED : CommandResult.FAILED);
            CommandSummary summary = new CommandSummary.Builder(result).build();
            try {
                ((CommandSummaryHandler)this.stdioHandler).onComplete(summary);
            }
            catch (Exception e) {
                this.setOrUpdateThrown(e);
            }
        }
    }

    private void setOrUpdateThrown(Throwable t) {
        if (this.thrown == null) {
            this.thrown = t;
        } else {
            this.thrown.addSuppressed(t);
        }
    }

    private static enum HandlerState {
        CREATED,
        FINISHED,
        STARTED;

    }

    private class StderrCallback
    extends AbstractChunkCallback {
        private StderrCallback() {
        }

        @Override
        protected void accept(ByteBuffer buffer, boolean closed) {
            AbstractFragmentResponseObserver.this.stdioHandler.onStderr(buffer, closed);
        }

        @Override
        protected boolean shouldProxy(ByteBuffer buffer, boolean closed) {
            if (buffer.position() == 0) {
                if (AbstractFragmentResponseObserver.this.stderrBuffer == null) {
                    AbstractFragmentResponseObserver.this.stderrBuffer = new StringBuilder();
                }
                AbstractFragmentResponseObserver.this.stderrBuffer.append(StandardCharsets.UTF_8.decode(buffer));
                return false;
            }
            return super.shouldProxy(buffer, closed);
        }
    }

    private class StdoutCallback
    extends AbstractChunkCallback {
        private StdoutCallback() {
        }

        @Override
        protected void accept(ByteBuffer buffer, boolean closed) {
            AbstractFragmentResponseObserver.this.stdioHandler.onStdout(buffer, closed);
        }
    }

    protected static abstract class RemoteProcess<ReqT>
    implements NioProcess {
        protected final ClientCallStreamObserver<ReqT> requestStream;
        private final AtomicBoolean canceled;
        private volatile String commandLine;
        private volatile boolean running;

        RemoteProcess(ClientCallStreamObserver<ReqT> requestStream) {
            this.requestStream = requestStream;
            this.canceled = new AtomicBoolean();
        }

        public void cancel() {
            if (this.canceled.compareAndSet(false, true)) {
                this.requestStream.cancel("The request was canceled by a handler", null);
            }
        }

        public boolean isCanceled() {
            return this.canceled.get();
        }

        public boolean isRunning() {
            return this.running;
        }

        public String toString() {
            return this.commandLine == null ? "<Not started>" : this.commandLine;
        }

        protected boolean isStarted() {
            return this.commandLine != null;
        }

        protected void onExit() {
            this.running = false;
        }

        protected void onStart(@Nonnull String commandLine) {
            this.commandLine = commandLine;
            this.running = true;
        }

        void abort() {
            if (this.canceled.compareAndSet(false, true)) {
                this.requestStream.cancel("The request was aborted after a handler failure", null);
            }
        }
    }

    private abstract class AbstractChunkCallback {
        private ByteBuffer proxy;

        private AbstractChunkCallback() {
        }

        public void onChunk(RpcStreamChunk chunk) {
            List buffers = chunk.getData().asReadOnlyByteBufferList();
            for (int i = 0; i < buffers.size(); ++i) {
                boolean closed;
                ByteBuffer buffer = (ByteBuffer)buffers.get(i);
                boolean bl = closed = i == buffers.size() - 1 && chunk.getClosed();
                if (this.proxy == null) {
                    this.handleOutput(buffer, closed);
                    if (!buffer.hasRemaining() || !this.shouldProxy(buffer, closed)) continue;
                    this.proxy = ByteBuffer.allocate(65536);
                    this.proxy.put(buffer);
                    continue;
                }
                this.pumpViaProxy(buffer, closed);
            }
        }

        protected abstract void accept(ByteBuffer var1, boolean var2);

        protected boolean shouldProxy(ByteBuffer buffer, boolean closed) {
            return !closed && !AbstractFragmentResponseObserver.this.isCanceled();
        }

        private void handleOutput(ByteBuffer buffer, boolean closed) {
            AbstractFragmentResponseObserver.this.invokeCallback(() -> {
                if (AbstractFragmentResponseObserver.this.maybeAbort()) {
                    buffer.position(buffer.position() + buffer.remaining());
                } else {
                    this.accept(buffer, closed);
                }
            });
        }

        private void pumpViaProxy(ByteBuffer buffer, boolean closed) {
            int remaining = buffer.remaining();
            do {
                int available;
                if (remaining > (available = this.proxy.remaining())) {
                    ByteBuffer slice = buffer.slice();
                    slice.limit(available);
                    this.proxy.put(slice);
                    buffer.position(buffer.position() + available);
                    remaining -= available;
                } else {
                    this.proxy.put(buffer);
                    remaining = 0;
                }
                this.proxy.flip();
                this.handleOutput(this.proxy, remaining == 0 && closed);
                if (AbstractFragmentResponseObserver.this.isCanceled() || remaining == 0 && !this.proxy.hasRemaining()) {
                    this.proxy = null;
                    break;
                }
                this.proxy.compact();
            } while (remaining > 0);
        }
    }
}

