/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.stash.internal.scm.git.mesh.ErrorTranslator;
import com.google.common.base.Throwables;
import io.grpc.Status;
import io.grpc.stub.ClientCallStreamObserver;
import io.grpc.stub.ClientResponseObserver;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;

abstract class AbstractFutureResponseObserver<ReqT, RespT, T>
implements ClientResponseObserver<ReqT, RespT> {
    protected volatile ClientCallStreamObserver<ReqT> requestStream;
    protected final ErrorTranslator errorTranslator;
    private final CompletableFuture<T> future;
    private final AtomicBoolean requestCanceled;
    private volatile T result;

    AbstractFutureResponseObserver() {
        this(null);
    }

    AbstractFutureResponseObserver(@Nullable ErrorTranslator errorTranslator) {
        this.errorTranslator = errorTranslator;
        this.requestCanceled = new AtomicBoolean();
        this.future = new ResponseFuture();
        this.future.whenComplete((result, exception) -> {
            ClientCallStreamObserver<ReqT> r;
            if (this.future.isCancelled() && this.requestCanceled.compareAndSet(false, true) && (r = this.requestStream) != null) {
                r.cancel("The request was canceled by the caller", exception);
            }
        });
    }

    public void beforeStart(ClientCallStreamObserver<ReqT> requestStream) {
        if (this.future.isCancelled() && this.requestCanceled.compareAndSet(false, true)) {
            requestStream.cancel("The request was canceled before it could be started", null);
        } else {
            this.requestStream = requestStream;
        }
    }

    public void onCompleted() {
        this.future.complete(this.result);
    }

    public void onError(Throwable t) {
        if (this.future.isDone()) {
            return;
        }
        Status status = Status.fromThrowable((Throwable)t);
        if (status.getCode() == Status.Code.CANCELLED && this.requestCanceled.compareAndSet(false, true)) {
            this.future.cancel(true);
        } else {
            this.future.completeExceptionally(t);
        }
    }

    void addListener(@Nonnull BiConsumer<? super T, ? super Throwable> listener) {
        this.future.whenComplete(listener);
    }

    @Nonnull
    CompletableFuture<T> asFuture() {
        return this.future.exceptionally(ex -> {
            ex = this.maybeTranslate((Throwable)ex);
            Throwables.throwIfUnchecked((Throwable)ex);
            throw new CompletionException("TODO: Handle unexpected errors better", (Throwable)ex);
        });
    }

    T asResult() {
        return this.asResult(null);
    }

    <E extends Throwable> T asResult(@Nullable Class<E> exceptionClass) throws E {
        try {
            return this.future.get();
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            Throwables.throwIfUnchecked((Throwable)cause);
            if (exceptionClass != null) {
                Throwables.propagateIfPossible((Throwable)cause, exceptionClass);
            }
            throw new RuntimeException("TODO: Handle unexpected errors better", cause);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("TODO: Handle interrupts better", e);
        }
    }

    void cancel(String message) {
        if (this.requestStream != null && this.requestCanceled.compareAndSet(false, true)) {
            this.requestStream.cancel(message, null);
        }
    }

    boolean isCanceled() {
        return this.future.isCancelled() || this.requestCanceled.get();
    }

    boolean isDone() {
        return this.future.isDone();
    }

    @Nonnull
    Throwable maybeTranslate(@Nonnull Throwable cause) {
        return this.errorTranslator == null ? cause : this.errorTranslator.maybeTranslate(cause);
    }

    void setResult(T result) {
        this.result = result;
    }

    private class ResponseFuture
    extends CompletableFuture<T> {
        private ResponseFuture() {
        }

        @Override
        public T get() throws InterruptedException, ExecutionException {
            try {
                return super.get();
            }
            catch (ExecutionException e) {
                throw this.translateCause(e);
            }
        }

        @Override
        public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            try {
                return super.get(timeout, unit);
            }
            catch (ExecutionException e) {
                throw this.translateCause(e);
            }
        }

        @Override
        public T getNow(T valueIfAbsent) {
            try {
                return super.getNow(valueIfAbsent);
            }
            catch (CompletionException e) {
                throw this.translateCause(e);
            }
        }

        @Override
        public T join() {
            try {
                return super.join();
            }
            catch (CompletionException e) {
                throw this.translateCause(e);
            }
        }

        private CompletionException translateCause(CompletionException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                return e;
            }
            Throwable translated = AbstractFutureResponseObserver.this.maybeTranslate(cause);
            if (cause == translated) {
                return e;
            }
            return new CompletionException(e.getMessage(), translated);
        }

        private ExecutionException translateCause(ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause == null) {
                return e;
            }
            Throwable translated = AbstractFutureResponseObserver.this.maybeTranslate(cause);
            if (cause == translated) {
                return e;
            }
            return new ExecutionException(e.getMessage(), translated);
        }
    }
}

