/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.mesh.MeshNode;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcGitTimeouts;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.git.worktree.GitWorkTree;
import com.atlassian.stash.internal.scm.git.mesh.AbstractFutureResponseObserver;
import com.atlassian.stash.internal.scm.git.mesh.GitRequestHelper;
import com.atlassian.stash.internal.scm.git.mesh.MeshConstants;
import com.atlassian.stash.internal.scm.git.mesh.MeshStub;
import com.atlassian.stash.internal.scm.git.mesh.worktree.MeshGitWorkTree;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.MessageOrBuilder;
import io.grpc.stub.AbstractStub;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;

public abstract class AbstractGrpcClient<T extends AbstractStub<T>> {
    protected final I18nService i18nService;
    protected final GitRequestHelper requestHelper;
    protected final MeshStub<T> stub;

    public AbstractGrpcClient(I18nService i18nService, GitRequestHelper requestHelper, MeshStub<T> stub) {
        this.i18nService = i18nService;
        this.requestHelper = requestHelper;
        this.stub = stub;
    }

    protected static <ReqT, RespT, T> List<T> awaitAll(Iterable<? extends AbstractFutureResponseObserver<ReqT, RespT, T>> observers) {
        RuntimeException exception = null;
        ImmutableList.Builder builder = ImmutableList.builder();
        for (AbstractFutureResponseObserver<ReqT, RespT, T> observer : observers) {
            try {
                T result = observer.asResult();
                if (result == null) continue;
                builder.add(result);
            }
            catch (RuntimeException e) {
                if (exception == null) {
                    exception = e;
                    continue;
                }
                exception.addSuppressed(e);
            }
        }
        if (exception != null) {
            throw exception;
        }
        return builder.build();
    }

    @Nonnull
    protected static Duration calculateDeadline(@Nonnull RpcGitTimeouts timeouts, double paddingFraction, @Nullable Duration extraPadding) {
        long deadline = TimeUnit.SECONDS.toMillis(Objects.requireNonNull(timeouts, "timeouts").getExecution());
        deadline += Math.max(0L, (long)Math.ceil((double)deadline * paddingFraction));
        if (extraPadding == null || extraPadding.isNegative()) {
            return Duration.ofMillis(deadline);
        }
        return extraPadding.plusMillis(deadline);
    }

    protected Stream<T> getAllStubsWithDeadline(@Nonnull MessageOrBuilder message) {
        Objects.requireNonNull(message, "message");
        return this.stub.forAllNodes().map(innerStub -> this.requestHelper.applyTimeout(innerStub, Objects.requireNonNull(message, "message"), null));
    }

    protected T getAnyStubWithDeadline(@Nonnull MessageOrBuilder message) {
        return this.getAnyStubWithDeadline(message, null);
    }

    protected T getAnyStubWithDeadline(@Nonnull MessageOrBuilder message, @Nullable Duration timeout) {
        AbstractStub anyStub = this.stub.forSidecar().orElseGet(() -> this.stub.forAllNodes().findFirst().orElse(null));
        if (anyStub == null) {
            throw new IllegalStateException("There are no configured nodes");
        }
        return (T)this.requestHelper.applyTimeout(anyStub, Objects.requireNonNull(message, "message"), timeout);
    }

    protected T getStubWithDeadline(@Nonnull Repository repository, @Nonnull MessageOrBuilder message) {
        return this.getStubWithDeadline(repository, message, null);
    }

    protected T getStubWithDeadline(@Nonnull Repository repository, @Nonnull MessageOrBuilder message, @Nullable Duration timeout) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(message, "message");
        return this.requestHelper.applyTimeout(this.stub.forRepository(repository), message, timeout);
    }

    protected T getStubWithDeadline(@Nonnull Repository repository, @Nonnull Set<Repository> related, @Nonnull MessageOrBuilder message) {
        return this.getStubWithDeadline(repository, related, message, null);
    }

    protected T getStubWithDeadline(@Nonnull Repository repository, @Nonnull Set<Repository> related, @Nonnull MessageOrBuilder message, @Nullable Duration timeout) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(related, "related");
        Objects.requireNonNull(message, "message");
        return this.requestHelper.applyTimeout(this.stub.forRepositories(repository, related), message, timeout);
    }

    protected T getStubWithDeadline(@Nonnull MeshGitWorkTree workTree, @Nonnull MessageOrBuilder message) {
        return this.getStubWithDeadline(workTree, message, null);
    }

    protected T getStubWithDeadline(@Nonnull MeshGitWorkTree workTree, @Nonnull MessageOrBuilder message, @Nullable Duration timeout) {
        Objects.requireNonNull(workTree, "workTree");
        Objects.requireNonNull(message, "message");
        return this.requestHelper.applyTimeout(this.stub.forWorkTree(workTree), message, timeout);
    }

    protected MeshNode getTargetNode(T stub) {
        return (MeshNode)stub.getCallOptions().getOption(MeshConstants.OPT_TARGET_NODE);
    }

    protected <B extends GeneratedMessageV3.Builder<B>> B prepareBuilder(B builder) {
        return this.requestHelper.prepareBuilder(builder);
    }

    protected <B extends GeneratedMessageV3.Builder<B>> B prepareBuilder(Repository repository, B builder) {
        return this.requestHelper.prepareBuilder(repository, builder);
    }

    protected <B extends GeneratedMessageV3.Builder<B>> B prepareBuilder(GitWorkTree workTree, B builder) {
        return this.requestHelper.prepareBuilder(workTree, builder);
    }
}

