/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.ServerException;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcNonTag;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcResolveAnnotatedTagRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcResolveAnnotatedTagResponse;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcResolveAnnotatedTagResponseFragment;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.CommandResult;
import com.atlassian.bitbucket.scm.git.ref.GitAnnotatedTagCallback;
import com.atlassian.bitbucket.scm.git.ref.GitAnnotatedTagContext;
import com.atlassian.bitbucket.scm.git.ref.GitAnnotatedTagSummary;
import com.atlassian.stash.internal.scm.git.mesh.AbstractFutureResponseObserver;
import com.atlassian.stash.internal.scm.git.mesh.DefaultErrorTranslator;
import com.atlassian.stash.internal.scm.git.mesh.RpcUtils;
import io.grpc.Status;
import io.grpc.stub.ClientCallStreamObserver;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.util.Objects;

class AnnotatedTagsResponseObserver
extends AbstractFutureResponseObserver<RpcResolveAnnotatedTagRequest, RpcResolveAnnotatedTagResponseFragment, Void> {
    private final GitAnnotatedTagCallback callback;
    private final I18nService i18nService;
    private volatile ClientCallStreamObserver<RpcResolveAnnotatedTagRequest> requestStream;
    private volatile Throwable thrown;

    AnnotatedTagsResponseObserver(@Nonnull GitAnnotatedTagCallback callback, @Nonnull I18nService i18nService, @Nonnull Repository repository) {
        super(new DefaultErrorTranslator(i18nService, repository));
        this.callback = Objects.requireNonNull(callback, "callback");
        this.i18nService = Objects.requireNonNull(i18nService, "i18nService");
    }

    @Override
    public void beforeStart(ClientCallStreamObserver<RpcResolveAnnotatedTagRequest> requestStream) {
        this.fireOnStart();
        this.requestStream = requestStream;
        super.beforeStart(this.requestStream);
    }

    @Override
    public void onCompleted() {
        Throwable t = this.fireOnEnd(this.thrown);
        if (t == null) {
            super.onCompleted();
        } else {
            super.onError(t);
        }
    }

    @Override
    public void onError(Throwable t) {
        Status status = Status.fromThrowable((Throwable)t);
        if (status.getCode() == Status.Code.CANCELLED && (t = status.getCause()) == null) {
            this.onCompleted();
            return;
        }
        super.onError(this.fireOnEnd(t));
    }

    public void onNext(RpcResolveAnnotatedTagResponseFragment fragment) {
        try {
            for (RpcResolveAnnotatedTagResponse response : fragment.getResponsesList()) {
                if (this.fireCallback(response)) continue;
                this.requestStream.cancel("Canceled by callback", null);
                break;
            }
        }
        catch (IOException e) {
            this.thrown = this.wrapException(e);
            this.requestStream.onError(this.thrown);
        }
    }

    private boolean fireCallback(RpcResolveAnnotatedTagResponse res) throws IOException {
        switch (res.getResultOneofCase()) {
            case MISSING: {
                return this.callback.onMissing(res.getMissing().toStringUtf8());
            }
            case NON_TAG: {
                RpcNonTag nonTag = res.getNonTag();
                return this.callback.onOtherType(nonTag.getObjectId().toStringUtf8(), RpcUtils.toObjectType(nonTag.getObjectType()));
            }
            case TAG: {
                return this.callback.onTag(RpcUtils.toAnnotatedTag(res.getTag()));
            }
        }
        return true;
    }

    private Throwable fireOnEnd(Throwable thrown) {
        try {
            this.callback.onEnd(new GitAnnotatedTagSummary.Builder(thrown == null ? CommandResult.SUCCEEDED : CommandResult.FAILED).build());
        }
        catch (IOException e) {
            if (thrown == null) {
                thrown = this.wrapException(e);
            }
            thrown.addSuppressed(e);
        }
        return thrown;
    }

    private void fireOnStart() {
        try {
            this.callback.onStart(new GitAnnotatedTagContext.Builder().build());
        }
        catch (IOException e) {
            throw this.wrapException(this.fireOnEnd(e));
        }
    }

    private ServerException wrapException(Throwable cause) {
        return new ServerException(this.i18nService.createKeyedMessage("bitbucket.service.externalprocess.exception", new Object[]{cause.getMessage()}), cause);
    }
}

