/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.util.BuilderSupport;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Optional;

public class ApplyTransactionsResult {
    private final RuntimeException exception;
    private final int unprocessedCount;

    private ApplyTransactionsResult(Builder builder) {
        this.exception = builder.exception;
        this.unprocessedCount = builder.unprocessedCount;
    }

    @Nonnull
    public Optional<RuntimeException> getException() {
        return Optional.ofNullable(this.exception);
    }

    public int getUnprocessedCount() {
        return this.unprocessedCount;
    }

    public boolean isSuccess() {
        return this.exception == null;
    }

    public static class Builder
    extends BuilderSupport {
        private RuntimeException exception;
        private int unprocessedCount;

        @Nonnull
        public ApplyTransactionsResult build() {
            return new ApplyTransactionsResult(this);
        }

        @Nonnull
        public Builder exception(@Nullable RuntimeException value) {
            this.exception = value;
            return this;
        }

        @Nonnull
        public Builder unprocessedCount(int value) {
            this.unprocessedCount = Math.max(0, value);
            return this;
        }
    }
}

