/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import io.grpc.stub.ClientCallStreamObserver;
import jakarta.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackoffClientCallStreamObserver<ReqT>
extends ClientCallStreamObserver<ReqT> {
    private static final Logger log = LoggerFactory.getLogger(BackoffClientCallStreamObserver.class);
    private final ClientCallStreamObserver<ReqT> delegate;
    private final Object monitor;
    private volatile boolean abort;
    private Runnable readyHandler;

    public BackoffClientCallStreamObserver(ClientCallStreamObserver<ReqT> delegate) {
        this.delegate = delegate;
        this.monitor = new Object();
        delegate.setOnReadyHandler(this::onReady);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort() {
        Object object = this.monitor;
        synchronized (object) {
            this.abort = true;
            this.monitor.notifyAll();
        }
    }

    public void cancel(@Nullable String message, @Nullable Throwable cause) {
        this.delegate.cancel(message, cause);
    }

    public void disableAutoRequestWithInitial(int request) {
        this.delegate.disableAutoRequestWithInitial(request);
    }

    public boolean isReady() {
        return this.delegate.isReady();
    }

    public void setOnReadyHandler(Runnable onReadyHandler) {
        this.readyHandler = onReadyHandler;
    }

    public void disableAutoInboundFlowControl() {
        this.delegate.disableAutoInboundFlowControl();
    }

    public void request(int count) {
        this.delegate.request(count);
    }

    public void setMessageCompression(boolean enable) {
        this.delegate.setMessageCompression(enable);
    }

    public void onNext(ReqT value) {
        this.requireReady();
        this.delegate.onNext(value);
    }

    public void onError(Throwable t) {
        this.delegate.onError(t);
    }

    public void onCompleted() {
        this.delegate.onCompleted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onReady() {
        Object object = this.monitor;
        synchronized (object) {
            this.monitor.notifyAll();
        }
        if (this.readyHandler != null) {
            this.readyHandler.run();
        }
    }

    private void requireReady() {
        if (this.abort || this.delegate.isReady()) {
            return;
        }
        long start = log.isDebugEnabled() ? System.nanoTime() : 0L;
        try {
            Object object = this.monitor;
            synchronized (object) {
                while (true) {
                    if (this.abort || this.delegate.isReady()) {
                        long waitMs;
                        if (start != 0L && (waitMs = (System.nanoTime() - start) / 1000000L) > 10L) {
                            log.debug("Waited {}ms for the client to be ready", (Object)waitMs);
                        }
                        return;
                    }
                    this.monitor.wait(3000L);
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return;
        }
    }
}

