/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.ServerException;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcBatchChange;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcBatchChangesRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcBatchChangesResponseFragment;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcFile;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.stash.internal.scm.git.bulk.BatchChangeCallback;
import com.atlassian.stash.internal.scm.git.bulk.FileChangeWithSize;
import com.atlassian.stash.internal.scm.git.mesh.AbstractFutureResponseObserver;
import com.atlassian.stash.internal.scm.git.mesh.DefaultErrorTranslator;
import com.atlassian.stash.internal.scm.git.mesh.RpcUtils;
import io.grpc.Status;
import jakarta.annotation.Nonnull;
import java.util.Objects;

class BatchChangesResponseObserver
extends AbstractFutureResponseObserver<RpcBatchChangesRequest, RpcBatchChangesResponseFragment, Void> {
    private final BatchChangeCallback callback;
    private final I18nService i18nService;
    private volatile ServerException thrown;

    BatchChangesResponseObserver(@Nonnull BatchChangeCallback callback, @Nonnull I18nService i18nService, @Nonnull Repository repository) {
        super(new DefaultErrorTranslator(i18nService, repository));
        this.callback = Objects.requireNonNull(callback, "callback");
        this.i18nService = Objects.requireNonNull(i18nService, "i18nService");
    }

    @Override
    public void onCompleted() {
        if (this.thrown == null) {
            super.onCompleted();
        } else {
            super.onError((Throwable)this.thrown);
        }
    }

    @Override
    public void onError(Throwable t) {
        Status status = Status.fromThrowable((Throwable)t);
        if (status.getCode() == Status.Code.CANCELLED && (t = status.getCause()) == null) {
            this.onCompleted();
            return;
        }
        super.onError(t);
    }

    public void onNext(RpcBatchChangesResponseFragment fragment) {
        try {
            for (RpcBatchChange response : fragment.getBatchChangesList()) {
                this.fireOnBatchChange(response);
            }
        }
        catch (RuntimeException e) {
            this.thrown = new ServerException(this.i18nService.createKeyedMessage("bitbucket.service.externalprocess.exception", new Object[]{e.getMessage()}), (Throwable)e);
            throw this.thrown;
        }
    }

    private void fireOnBatchChange(RpcBatchChange response) {
        RpcFile file = response.getFile();
        this.callback.onFileChange(new FileChangeWithSize.Builder().changeType(RpcUtils.toBulkChangeType(response.getChangeType())).contentId(file.getContentId()).path(file.getPath().toStringUtf8()).size(file.getSize()).build());
    }
}

