/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.mesh.rpc.v1.RpcBatchRescopePullRequestRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcBatchRescopePullRequestResponseFragment;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcCommit;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcPullRequestRescopeOutcome;
import com.atlassian.bitbucket.pull.RescopeDetails;
import com.atlassian.bitbucket.pull.SimpleRescopeDetails;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.pull.BulkRescopeContext;
import com.atlassian.bitbucket.scm.pull.PullRequestRescope;
import com.atlassian.stash.internal.scm.git.mesh.AbstractFutureResponseObserver;
import com.atlassian.stash.internal.scm.git.mesh.RpcUtils;
import java.util.List;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchRescopePullRequestResponseObserver
extends AbstractFutureResponseObserver<RpcBatchRescopePullRequestRequest, RpcBatchRescopePullRequestResponseFragment, Void> {
    private static final Logger log = LoggerFactory.getLogger(BatchRescopePullRequestResponseObserver.class);
    private final BulkRescopeContext context;
    private final Repository repository;
    private final Function<Long, PullRequestRescope> rescopeSupplier;

    public BatchRescopePullRequestResponseObserver(Repository repository, BulkRescopeContext context, Function<Long, PullRequestRescope> rescopeSupplier) {
        this.context = context;
        this.repository = repository;
        this.rescopeSupplier = rescopeSupplier;
    }

    public void onNext(RpcBatchRescopePullRequestResponseFragment fragment) {
        block5: for (RpcPullRequestRescopeOutcome outcome : fragment.getOutcomesList()) {
            PullRequestRescope rescope = this.rescopeSupplier.apply(outcome.getRescopeId());
            if (rescope == null) {
                log.error("[{}] Could not match rescope ID {} to a rescope", (Object)this.repository, (Object)outcome.getRescopeId());
                continue;
            }
            switch (outcome.getOutcomeOneofCase()) {
                case DECLINED: {
                    this.context.decline(rescope);
                    continue block5;
                }
                case MERGED: {
                    RpcPullRequestRescopeOutcome.Merged merged = outcome.getMerged();
                    this.context.merge(rescope, merged.hasMergeCommit() ? merged.getMergeCommit() : null);
                    continue block5;
                }
                case UPDATED: {
                    RpcPullRequestRescopeOutcome.Updated updated = outcome.getUpdated();
                    this.context.update(rescope, this.toRescopeDetails(updated.getAddedCommitsList(), updated.getTotalAddedCommits()), this.toRescopeDetails(updated.getRemovedCommitsList(), updated.getTotalRemovedCommits()));
                    continue block5;
                }
            }
            log.warn("[{}] Rescope {} could not be analysed", (Object)this.repository, (Object)rescope);
        }
    }

    private RescopeDetails toRescopeDetails(List<RpcCommit> commits, int totalCommits) {
        SimpleRescopeDetails.Builder builder = new SimpleRescopeDetails.Builder().total(totalCommits);
        commits.forEach(commit -> builder.commit(RpcUtils.toCommit(commit, this.repository)));
        return builder.build();
    }
}

