/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.dmz.process.NioStdioHandler;
import com.atlassian.bitbucket.hook.ScmHookDetails;
import com.atlassian.bitbucket.hook.repository.RepositoryHookRequest;
import com.atlassian.bitbucket.hook.repository.RepositoryHookResult;
import com.atlassian.bitbucket.hook.repository.RepositoryHookVeto;
import com.atlassian.bitbucket.hook.repository.RepositoryPushHookRequest;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.mesh.MeshNode;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcHookChunk;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcHostingPostReceiveRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcHostingPostReceiveResponse;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcHostingPreReceiveRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcHostingPreReceiveResponse;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcHostingWriteStreamFragment;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.CommandExitHandler;
import com.atlassian.stash.internal.hook.repository.InternalRepositoryHookService;
import com.atlassian.stash.internal.scm.git.mesh.AbstractBidirectionalHostingFragmentResponseObserver;
import com.atlassian.stash.internal.scm.git.mesh.AbstractHostingFragmentResponseObserver;
import com.atlassian.stash.internal.scm.git.mesh.ErrorTranslator;
import com.atlassian.stash.internal.scm.git.mesh.GitRequestHelper;
import com.atlassian.stash.internal.scm.git.mesh.HostingWriteRequestFragmentCreator;
import com.atlassian.stash.internal.scm.git.mesh.RpcUtils;
import com.google.protobuf.ByteString;
import io.grpc.stub.ClientCallStreamObserver;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;

class BidirectionalHostingWriteFragmentResponseObserver<ReqT>
extends AbstractBidirectionalHostingFragmentResponseObserver<ReqT, RpcHostingWriteStreamFragment> {
    private final AtomicBoolean onCompletedSent;
    private final HostingWriteRequestFragmentCreator<ReqT> fragmentCreator;
    private final InternalRepositoryHookService hookService;
    private final Repository repository;
    private final GitRequestHelper requestHelper;
    private final MeshNode targetNode;
    private BidirectionalHookedRemoteProcess process;
    private RepositoryPushHookRequest.Builder pushHookRequestBuilder;

    BidirectionalHostingWriteFragmentResponseObserver(@Nonnull NioStdioHandler<Void> stdioHandler, @Nonnull ErrorTranslator errorTranslator, @Nonnull CommandExitHandler exitHandler, @Nonnull Repository repository, @Nonnull HostingWriteRequestFragmentCreator<ReqT> fragmentCreator, @Nonnull InternalRepositoryHookService hookService, @Nonnull I18nService i18nService, @Nonnull GitRequestHelper requestHelper, @Nonnull MeshNode targetNode) {
        super(stdioHandler, errorTranslator, exitHandler, fragmentCreator, i18nService);
        this.repository = Objects.requireNonNull(repository, "repository");
        this.hookService = Objects.requireNonNull(hookService, "hookService");
        this.fragmentCreator = fragmentCreator;
        this.requestHelper = Objects.requireNonNull(requestHelper, "requestHelper");
        this.targetNode = Objects.requireNonNull(targetNode, "targetNode");
        this.onCompletedSent = new AtomicBoolean();
    }

    public void onNext(RpcHostingWriteStreamFragment fragment) {
        switch (fragment.getFragmentOneofCase()) {
            case RESULT: {
                this.maybeSendOnCompleted();
                this.callOnExit(fragment.getResult());
                break;
            }
            case START: {
                this.callOnStart(fragment.getStart().getCommandLine().toStringUtf8());
                break;
            }
            case STDERR: {
                this.stderrCallback.onChunk(fragment.getStderr());
                break;
            }
            case STDOUT: {
                this.stdoutCallback.onChunk(fragment.getStdout());
                break;
            }
            case PRE_RECEIVE: {
                this.runPreReceiveHooks(fragment.getPreReceive());
                break;
            }
            case POST_RECEIVE: {
                this.runPostReceiveHooks(fragment.getPostReceive());
            }
        }
    }

    @Override
    protected AbstractHostingFragmentResponseObserver.RemoteProcess<ReqT> createProcess(ClientCallStreamObserver<ReqT> requestStream) {
        this.process = this.setProcess(new BidirectionalHookedRemoteProcess(this, requestStream));
        return this.process;
    }

    private void maybeSendOnCompleted() {
        if (this.onCompletedSent.compareAndSet(false, true)) {
            this.process.sendOnCompleted();
        }
    }

    private void runPostReceiveHooks(RpcHostingPostReceiveRequest request) {
        if (this.pushHookRequestBuilder == null) {
            this.pushHookRequestBuilder = new RepositoryPushHookRequest.Builder(this.repository);
        }
        request.getRefUpdatesList().stream().map(RpcUtils::toRefChange).forEach(x$0 -> {
            RepositoryPushHookRequest.Builder cfr_ignored_0 = (RepositoryPushHookRequest.Builder)this.pushHookRequestBuilder.refChanges(x$0, new RefChange[0]);
        });
        if (request.getMoreRefUpdates()) {
            return;
        }
        MeshScmHookDetails hookDetails = new MeshScmHookDetails("post-receive");
        RepositoryPushHookRequest pushHookRequest = ((RepositoryPushHookRequest.Builder)this.pushHookRequestBuilder.scmHookDetails((ScmHookDetails)hookDetails)).build();
        this.pushHookRequestBuilder = null;
        this.hookService.postUpdateSynchronous((RepositoryHookRequest)pushHookRequest);
        this.process.writeHookResponse(RpcHostingPostReceiveResponse.newBuilder().addAllOutput(hookDetails.getOutput()).build(), this.fragmentCreator::forPostReceive);
        this.maybeSendOnCompleted();
    }

    private void runPreReceiveHooks(RpcHostingPreReceiveRequest request) {
        if (this.pushHookRequestBuilder == null) {
            this.pushHookRequestBuilder = new RepositoryPushHookRequest.Builder(this.repository);
        }
        request.getRefUpdatesList().stream().map(RpcUtils::toRefChange).forEach(x$0 -> {
            RepositoryPushHookRequest.Builder cfr_ignored_0 = (RepositoryPushHookRequest.Builder)this.pushHookRequestBuilder.refChanges(x$0, new RefChange[0]);
        });
        if (request.getMoreRefUpdates()) {
            return;
        }
        this.requestHelper.withQuarantine(this.repository, this.targetNode, request.getRepository(), () -> {
            MeshScmHookDetails hookDetails = new MeshScmHookDetails("pre-receive");
            RepositoryPushHookRequest pushHookRequest = ((RepositoryPushHookRequest.Builder)this.pushHookRequestBuilder.scmHookDetails((ScmHookDetails)hookDetails)).build();
            this.pushHookRequestBuilder = null;
            RepositoryHookResult result = this.hookService.preUpdate((RepositoryHookRequest)pushHookRequest);
            PrintWriter err = hookDetails.err();
            String separator = "";
            for (RepositoryHookVeto veto : result.getVetoes()) {
                String detailedMessage = veto.getDetailedMessage();
                String summary = veto.getSummaryMessage();
                Object message = StringUtils.isNotEmpty((CharSequence)detailedMessage) && !detailedMessage.equals(summary) ? StringUtils.appendIfMissing((String)summary, (CharSequence)"\n", (CharSequence[])new CharSequence[0]) + detailedMessage : summary;
                err.append(separator).println((String)message);
                separator = ((String)message).indexOf(10) == -1 || ((String)message).endsWith("\n") ? "" : "\n";
            }
            this.process.writeHookResponse(RpcHostingPreReceiveResponse.newBuilder().addAllOutput(hookDetails.getOutput()).setRejected(result.isRejected()).build(), this.fragmentCreator::forPreReceive);
            return null;
        });
    }

    private class BidirectionalHookedRemoteProcess
    extends AbstractBidirectionalHostingFragmentResponseObserver.BidirectionalRemoteProcess {
        BidirectionalHookedRemoteProcess(BidirectionalHostingWriteFragmentResponseObserver bidirectionalHostingWriteFragmentResponseObserver, ClientCallStreamObserver<ReqT> requestStream) {
            super(bidirectionalHostingWriteFragmentResponseObserver, requestStream);
        }

        public void sendOnCompleted() {
            this.requestStream.onCompleted();
        }

        public <T> void writeHookResponse(T response, Function<T, ReqT> fragmentCreator) {
            if (!this.isStarted()) {
                throw new IllegalStateException("Wait until onStart to call writeHookResponse");
            }
            this.requestStream.onNext(fragmentCreator.apply(response));
        }
    }

    private static class MeshScmHookDetails
    implements ScmHookDetails {
        private final PrintWriter err;
        private final String hookName;
        private final Queue<RpcHookChunk> hookOutput;
        private final PrintWriter out;

        MeshScmHookDetails(@Nonnull String hookName) {
            this.hookName = Objects.requireNonNull(hookName, "hookName");
            this.hookOutput = new ConcurrentLinkedQueue<RpcHookChunk>();
            this.err = new PrintWriter(new RpcHookChunkStream(RpcHookChunk.Channel.CHANNEL_STDERR, this.hookOutput));
            this.out = new PrintWriter(new RpcHookChunkStream(RpcHookChunk.Channel.CHANNEL_STDOUT, this.hookOutput));
        }

        @Nonnull
        public PrintWriter err() {
            return this.err;
        }

        @Nonnull
        public Optional<String> getHookName() {
            return Optional.of(this.hookName);
        }

        @Nonnull
        public PrintWriter out() {
            return this.out;
        }

        private Queue<RpcHookChunk> getOutput() {
            this.err.flush();
            this.out.flush();
            return this.hookOutput;
        }
    }

    private static class RpcHookChunkStream
    extends OutputStream {
        private final RpcHookChunk.Channel channel;
        private final Queue<RpcHookChunk> sink;

        RpcHookChunkStream(RpcHookChunk.Channel channel, Queue<RpcHookChunk> sink) {
            this.channel = channel;
            this.sink = sink;
        }

        @Override
        public void write(int b) {
            ByteString.Output out = ByteString.newOutput();
            out.write(b);
            this.onOutput(out);
        }

        @Override
        public void write(@Nonnull byte[] b) throws IOException {
            ByteString.Output out = ByteString.newOutput((int)b.length);
            out.write(b);
            this.onOutput(out);
        }

        @Override
        public void write(@Nonnull byte[] b, int off, int len) {
            ByteString.Output out = ByteString.newOutput((int)len);
            out.write(b, off, len);
            this.onOutput(out);
        }

        private void onOutput(ByteString.Output output) {
            this.sink.add(RpcHookChunk.newBuilder().setData(output.toByteString()).setChannel(this.channel).build());
        }
    }
}

