/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.ServerException;
import com.atlassian.bitbucket.content.Blame;
import com.atlassian.bitbucket.content.FileContentCallback;
import com.atlassian.bitbucket.content.FileContext;
import com.atlassian.bitbucket.content.FileSummary;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcBlame;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcBlameEvent;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcBlameResponseFragment;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcBlameStreamRequest;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.CommandResult;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.stash.internal.scm.git.mesh.AbstractFutureResponseObserver;
import com.atlassian.stash.internal.scm.git.mesh.DefaultErrorTranslator;
import com.atlassian.stash.internal.scm.git.mesh.RpcUtils;
import io.grpc.Status;
import io.grpc.stub.ClientCallStreamObserver;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;

class BlameResponseObserver
extends AbstractFutureResponseObserver<RpcBlameStreamRequest, RpcBlameResponseFragment, Void> {
    private final FileContentCallback callback;
    private final FileContext fileContext;
    private final I18nService i18nService;
    private final PageRequest pageRequest;
    private volatile ClientCallStreamObserver<RpcBlameStreamRequest> requestStream;
    private volatile Throwable thrown;
    private int added = 0;

    BlameResponseObserver(@Nonnull FileContentCallback callback, @Nonnull FileContext fileContext, @Nonnull I18nService i18nService, @Nonnull PageRequest pageRequest, @Nonnull Repository repository) {
        super(new DefaultErrorTranslator(i18nService, repository));
        this.callback = Objects.requireNonNull(callback, "callback");
        this.fileContext = Objects.requireNonNull(fileContext, "fileContext");
        this.i18nService = Objects.requireNonNull(i18nService, "i18nService");
        this.pageRequest = Objects.requireNonNull(pageRequest, "pageRequest");
    }

    @Override
    public void beforeStart(ClientCallStreamObserver<RpcBlameStreamRequest> requestStream) {
        this.fireOnStart();
        this.requestStream = requestStream;
        super.beforeStart(this.requestStream);
    }

    @Override
    public void onCompleted() {
        Throwable t = this.fireOnEnd(this.thrown);
        if (t == null) {
            super.onCompleted();
        } else {
            super.onError(t);
        }
    }

    @Override
    public void onError(Throwable t) {
        Status status = Status.fromThrowable((Throwable)t);
        if (status.getCode() == Status.Code.CANCELLED && (t = status.getCause()) == null) {
            this.onCompleted();
            return;
        }
        super.onError(this.fireOnEnd(t));
    }

    public void onNext(RpcBlameResponseFragment fragment) {
        try {
            ArrayList<Blame> blames = new ArrayList<Blame>();
            for (RpcBlameEvent response : fragment.getResponsesList()) {
                if (response.hasOnBinary()) {
                    this.added = -1;
                    this.callback.onBinary();
                    continue;
                }
                if (response.hasBlame()) {
                    RpcBlame rpcBlame = response.getBlame();
                    blames.add(RpcUtils.toBlame(rpcBlame));
                    continue;
                }
                if (!response.hasOnLine()) continue;
                RpcBlameEvent.OnLine onLine = response.getOnLine();
                ++this.added;
                this.callback.onLine(onLine.getLineNumber(), onLine.getLine().toStringUtf8(), onLine.getTruncated());
            }
            if (!blames.isEmpty()) {
                this.callback.offerBlame(PageUtils.createPage(blames, (PageRequest)this.pageRequest));
            }
        }
        catch (IOException e) {
            this.thrown = this.wrapException(e);
            this.requestStream.onError(this.thrown);
        }
    }

    private Throwable fireOnEnd(Throwable thrown) {
        try {
            CommandResult result;
            if (this.added < 0) {
                return thrown;
            }
            CommandResult commandResult = result = thrown == null ? CommandResult.SUCCEEDED : CommandResult.FAILED;
            if (this.added > 0) {
                this.callback.onEnd(((FileSummary.Builder)((FileSummary.Builder)((FileSummary.Builder)new FileSummary.Builder(result).lastPage(this.added <= this.pageRequest.getLimit())).pageRequest(this.pageRequest)).size(Math.min(this.added, this.pageRequest.getLimit()))).build());
            } else {
                this.callback.onEnd(((FileSummary.Builder)((FileSummary.Builder)new FileSummary.Builder(result).lastPage(true)).pageRequest(this.pageRequest)).build());
            }
        }
        catch (IOException e) {
            if (thrown == null) {
                thrown = this.wrapException(e);
            }
            thrown.addSuppressed(e);
        }
        return thrown;
    }

    private void fireOnStart() {
        try {
            this.callback.onStart(this.fileContext);
        }
        catch (IOException e) {
            throw this.wrapException(this.fireOnEnd(e));
        }
    }

    private ServerException wrapException(Throwable cause) {
        return new ServerException(this.i18nService.createKeyedMessage("bitbucket.service.externalprocess.exception", new Object[]{cause.getMessage()}), cause);
    }
}

