/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.ServerException;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcBranch;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcBranchResponseFragment;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcBranchesRequest;
import com.atlassian.bitbucket.repository.BranchCallback;
import com.atlassian.bitbucket.repository.BranchContext;
import com.atlassian.bitbucket.repository.BranchSummary;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.CommandResult;
import com.atlassian.stash.internal.scm.git.mesh.AbstractFutureResponseObserver;
import com.atlassian.stash.internal.scm.git.mesh.DefaultErrorTranslator;
import com.atlassian.stash.internal.scm.git.mesh.RpcUtils;
import io.grpc.Status;
import io.grpc.stub.ClientCallStreamObserver;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.util.Objects;

class BranchesResponseObserver
extends AbstractFutureResponseObserver<RpcBranchesRequest, RpcBranchResponseFragment, Void> {
    private final BranchCallback callback;
    private final I18nService i18nService;
    private volatile ClientCallStreamObserver<RpcBranchesRequest> requestStream;
    private volatile Throwable thrown;

    BranchesResponseObserver(@Nonnull BranchCallback callback, @Nonnull I18nService i18nService, @Nonnull Repository repository) {
        super(new DefaultErrorTranslator(i18nService, repository));
        this.callback = Objects.requireNonNull(callback, "callback");
        this.i18nService = Objects.requireNonNull(i18nService, "i18nService");
    }

    @Override
    public void beforeStart(ClientCallStreamObserver<RpcBranchesRequest> requestStream) {
        this.fireOnStart();
        this.requestStream = requestStream;
        super.beforeStart(this.requestStream);
    }

    @Override
    public void onCompleted() {
        Throwable t = this.fireOnEnd(this.thrown);
        if (t == null) {
            super.onCompleted();
        } else {
            super.onError(t);
        }
    }

    @Override
    public void onError(Throwable t) {
        Status status = Status.fromThrowable((Throwable)t);
        if (status.getCode() == Status.Code.CANCELLED && (t = status.getCause()) == null) {
            this.onCompleted();
            return;
        }
        super.onError(this.fireOnEnd(t));
    }

    public void onNext(RpcBranchResponseFragment fragment) {
        try {
            for (RpcBranch response : fragment.getResponsesList()) {
                if (this.callback.onBranch(RpcUtils.toBranch(response))) continue;
                this.requestStream.cancel("Canceled by callback", null);
                break;
            }
        }
        catch (IOException e) {
            this.thrown = this.wrapException(e);
            this.requestStream.onError(this.thrown);
        }
    }

    private Throwable fireOnEnd(Throwable thrown) {
        try {
            this.callback.onEnd(new BranchSummary.Builder(thrown == null ? CommandResult.SUCCEEDED : CommandResult.FAILED).build());
        }
        catch (IOException e) {
            if (thrown == null) {
                thrown = this.wrapException(e);
            }
            thrown.addSuppressed(e);
        }
        return thrown;
    }

    private void fireOnStart() {
        try {
            this.callback.onStart(new BranchContext.Builder().build());
        }
        catch (IOException e) {
            throw this.wrapException(this.fireOnEnd(e));
        }
    }

    private ServerException wrapException(Throwable cause) {
        return new ServerException(this.i18nService.createKeyedMessage("bitbucket.service.externalprocess.exception", new Object[]{cause.getMessage()}), cause);
    }
}

