/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.ServerException;
import com.atlassian.bitbucket.commit.Changeset;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcChangeset;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcChangesetPageRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcChangesetResponseFragment;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.SatiableConsumer;
import com.atlassian.stash.internal.scm.git.mesh.AbstractFutureResponseObserver;
import com.atlassian.stash.internal.scm.git.mesh.DefaultErrorTranslator;
import com.atlassian.stash.internal.scm.git.mesh.RpcUtils;
import io.grpc.Status;
import io.grpc.stub.ClientCallStreamObserver;
import jakarta.annotation.Nonnull;
import java.util.Objects;

class ChangesetResponseObserver
extends AbstractFutureResponseObserver<RpcChangesetPageRequest, RpcChangesetResponseFragment, Void> {
    private final SatiableConsumer<Changeset> callback;
    private final PageRequest changesPageRequest;
    private final I18nService i18nService;
    private final Repository repository;
    private volatile ClientCallStreamObserver<RpcChangesetPageRequest> requestStream;
    private volatile Throwable thrown;

    ChangesetResponseObserver(@Nonnull SatiableConsumer<Changeset> callback, @Nonnull I18nService i18nService, @Nonnull Repository repository, @Nonnull PageRequest changesPageRequest) {
        super(new DefaultErrorTranslator(i18nService, repository));
        this.callback = Objects.requireNonNull(callback, "callback");
        this.changesPageRequest = Objects.requireNonNull(changesPageRequest, "changesPageRequest");
        this.i18nService = Objects.requireNonNull(i18nService, "i18nService");
        this.repository = Objects.requireNonNull(repository, "repository");
    }

    @Override
    public void beforeStart(ClientCallStreamObserver<RpcChangesetPageRequest> requestStream) {
        this.requestStream = requestStream;
        super.beforeStart(this.requestStream);
    }

    @Override
    public void onCompleted() {
        if (this.thrown == null) {
            super.onCompleted();
        } else {
            super.onError(this.thrown);
        }
    }

    @Override
    public void onError(Throwable t) {
        Status status = Status.fromThrowable((Throwable)t);
        if (status.getCode() == Status.Code.CANCELLED && (t = status.getCause()) == null) {
            this.onCompleted();
            return;
        }
        super.onError(t);
    }

    public void onNext(RpcChangesetResponseFragment fragment) {
        try {
            for (RpcChangeset response : fragment.getResponsesList()) {
                if (this.callback.accept((Object)RpcUtils.toChangeset(response, this.changesPageRequest, this.repository))) continue;
                this.requestStream.cancel("Canceled by callback", null);
                break;
            }
        }
        catch (Exception e) {
            this.thrown = this.wrapException(e);
            this.requestStream.onError(this.thrown);
        }
    }

    private ServerException wrapException(Throwable cause) {
        return new ServerException(this.i18nService.createKeyedMessage("bitbucket.service.externalprocess.exception", new Object[]{cause.getMessage()}), cause);
    }
}

