/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.ServerException;
import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.commit.CommitCallback;
import com.atlassian.bitbucket.commit.CommitContext;
import com.atlassian.bitbucket.commit.CommitSummary;
import com.atlassian.bitbucket.commit.SimpleCommit;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcChange;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcCommit;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcGetCommitsResponseFragment;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.CommandResult;
import com.atlassian.bitbucket.util.Timer;
import com.atlassian.bitbucket.util.TimerUtils;
import com.atlassian.stash.internal.scm.git.mesh.AbstractFutureResponseObserver;
import com.atlassian.stash.internal.scm.git.mesh.DefaultErrorTranslator;
import com.atlassian.stash.internal.scm.git.mesh.RpcUtils;
import com.google.common.collect.ImmutableMap;
import io.grpc.Status;
import io.grpc.stub.ClientCallStreamObserver;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

class CommitsResponseObserver<T>
extends AbstractFutureResponseObserver<T, RpcGetCommitsResponseFragment, Void> {
    private final AtomicInteger added;
    private final CommitCallback callback;
    private final boolean hasAlternates;
    private final I18nService i18nService;
    private final Repository repository;
    private volatile ClientCallStreamObserver<T> requestStream;
    private volatile Throwable thrown;

    CommitsResponseObserver(@Nonnull CommitCallback callback, @Nonnull I18nService i18nService, @Nonnull Repository repository, boolean hasAlternates) {
        super(new DefaultErrorTranslator(i18nService, repository));
        this.callback = callback;
        this.hasAlternates = hasAlternates;
        this.i18nService = i18nService;
        this.repository = repository;
        this.added = new AtomicInteger();
    }

    @Override
    public void beforeStart(ClientCallStreamObserver<T> requestStream) {
        this.requestStream = requestStream;
        super.beforeStart(this.requestStream);
    }

    @Override
    public void onCompleted() {
        Throwable t = this.fireOnEnd(this.thrown);
        if (t == null) {
            super.onCompleted();
        } else {
            super.onError(t);
        }
    }

    @Override
    public void onError(Throwable t) {
        Status status = Status.fromThrowable((Throwable)t);
        if (status.getCode() == Status.Code.CANCELLED && (t = status.getCause()) == null) {
            this.onCompleted();
            return;
        }
        super.onError(this.fireOnEnd(t));
    }

    public void onNext(RpcGetCommitsResponseFragment fragment) {
        if (this.isCanceled() || this.thrown != null) {
            return;
        }
        try (Timer ignored = TimerUtils.start((String)(CommitsResponseObserver.class.getSimpleName() + ".onNext"));){
            Map renames = fragment.getRenameChangesMap();
            for (RpcCommit commit : fragment.getCommitsList()) {
                if (this.added.getAndIncrement() == 0) {
                    this.callback.onStart(new CommitContext.Builder().build());
                }
                if (this.callback.onCommit(this.transformCommit(commit, renames))) continue;
                this.cancel("Canceled by callback");
                break;
            }
        }
        catch (IOException | RuntimeException e) {
            this.thrown = this.wrapException(e);
            this.requestStream.onError(this.thrown);
        }
    }

    private Throwable fireOnEnd(Throwable thrown) {
        try {
            CommandResult result;
            CommandResult commandResult = this.isCanceled() ? CommandResult.CANCELED : (result = thrown == null ? CommandResult.SUCCEEDED : CommandResult.FAILED);
            if (this.added.get() > 0) {
                this.callback.onEnd(new CommitSummary.Builder(result).build());
            } else if (result == CommandResult.SUCCEEDED) {
                this.callback.onStart(new CommitContext.Builder().build());
                this.callback.onEnd(new CommitSummary.Builder(result).build());
            }
        }
        catch (IOException e) {
            if (thrown == null) {
                thrown = this.wrapException(e);
            }
            thrown.addSuppressed(e);
        }
        return thrown;
    }

    private Commit transformCommit(RpcCommit rpc, Map<String, RpcChange> renames) {
        Commit commit = RpcUtils.toCommit(rpc, this.hasAlternates ? null : this.repository);
        RpcChange change = renames.get(commit.getId());
        if (change == null) {
            return commit;
        }
        ImmutableMap.Builder builder = ImmutableMap.builder().put((Object)"type", (Object)RpcUtils.toChangeType(change.getType()).getType()).put((Object)"path", (Object)change.getPath().toStringUtf8());
        if (change.hasSrcPath()) {
            builder.put((Object)"srcPath", (Object)change.getSrcPath().toStringUtf8());
        }
        if (change.hasPercentUnchanged()) {
            builder.put((Object)"percentUnchanged", (Object)change.getPercentUnchanged());
        }
        return ((SimpleCommit.Builder)new SimpleCommit.Builder(commit).property("change", (Object)builder.build())).build();
    }

    private ServerException wrapException(Throwable cause) {
        return new ServerException(this.i18nService.createKeyedMessage("bitbucket.service.externalprocess.exception", new Object[]{cause.getMessage()}), cause);
    }
}

