/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.ServiceException;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcGitError;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.git.command.merge.GitNoCommonAncestorException;
import com.atlassian.stash.internal.scm.git.mesh.DefaultErrorTranslator;
import com.google.common.collect.Iterables;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;

public class CommonAncestorErrorTranslator
extends DefaultErrorTranslator {
    private final Collection<String> commits;

    public CommonAncestorErrorTranslator(@Nonnull I18nService i18nService, @Nullable Repository repository, @Nonnull Collection<String> commits) {
        super(i18nService, repository);
        this.commits = Objects.requireNonNull(commits, "commits");
    }

    @Override
    protected ServiceException translate(RpcGitError error, Throwable cause) {
        if (error.getErrorOneofCase() == RpcGitError.ErrorOneofCase.NO_MERGE_BASE) {
            return new GitNoCommonAncestorException(this.i18nService.createKeyedMessage("bitbucket.git.no.common.ancestor", new Object[]{Iterables.getFirst(this.commits, null), this.commits.stream().skip(1L).collect(Collectors.joining(", "))}));
        }
        return super.translate(error, cause);
    }
}

