/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.ServiceException;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.mesh.MeshNodeAuthenticationException;
import com.atlassian.bitbucket.mesh.MeshNodeConnectionException;
import com.atlassian.stash.internal.scm.git.mesh.ErrorTranslator;
import io.grpc.Status;
import jakarta.annotation.Nonnull;
import java.nio.channels.UnresolvedAddressException;
import java.util.Objects;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;

class ConnectivityErrorTranslator
implements ErrorTranslator {
    private final I18nService i18nService;
    private final String rpcUrl;

    ConnectivityErrorTranslator(@Nonnull I18nService i18nService, @Nonnull String rpcUrl) {
        this.i18nService = i18nService;
        this.rpcUrl = rpcUrl;
    }

    @Override
    @Nonnull
    public Throwable maybeTranslate(@Nonnull Throwable cause) {
        return this.toServiceException(Objects.requireNonNull(cause, "cause"));
    }

    @Override
    @Nonnull
    public ServiceException translate(@Nonnull Throwable cause) {
        return this.toServiceException(Objects.requireNonNull(cause, "cause"));
    }

    private ServiceException toServiceException(Throwable cause) {
        String key;
        if (cause instanceof ServiceException) {
            return (ServiceException)cause;
        }
        Status status = Status.fromThrowable((Throwable)cause);
        Status.Code code = status.getCode();
        if (cause instanceof IllegalArgumentException) {
            key = "bitbucket.service.mesh.node.connectivity.invalidargument";
        } else if (code == Status.Code.DEADLINE_EXCEEDED) {
            key = "bitbucket.service.mesh.node.connectivity.timeout";
        } else {
            if (code == Status.Code.UNAUTHENTICATED) {
                return new MeshNodeAuthenticationException(this.i18nService.createKeyedMessage("bitbucket.service.mesh.node.connectivity.authfailed", new Object[]{this.rpcUrl}), cause);
            }
            key = code == Status.Code.UNAVAILABLE ? ((cause = status.getCause()) instanceof SSLHandshakeException ? "bitbucket.service.mesh.node.connectivity.invalidsslcertificate" : (cause instanceof SSLException ? "bitbucket.service.mesh.node.connectivity.incorrectprotocol" : (cause instanceof UnresolvedAddressException ? "bitbucket.service.mesh.node.connectivity.unresolvedaddress" : "bitbucket.service.mesh.node.connectivity.unavailable"))) : "bitbucket.service.mesh.node.connectivity.failed";
        }
        return new MeshNodeConnectionException(this.i18nService.createKeyedMessage(key, new Object[]{this.rpcUrl}), cause);
    }
}

