/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.stash.internal.scm.git.mesh.AbstractFutureResponseObserver;
import com.atlassian.stash.internal.scm.git.mesh.ErrorTranslator;
import com.atlassian.stash.internal.scm.git.mesh.RequestMessageCreator;
import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.ClientCallStreamObserver;
import jakarta.annotation.Nonnull;
import java.util.Objects;

class ConversationalResponseObserver<ReqT, RespT>
extends AbstractFutureResponseObserver<ReqT, RespT, RespT> {
    private final RequestMessageCreator<ReqT, RespT> messageCreator;
    private ClientCallStreamObserver<ReqT> clientCallStreamObserver;

    ConversationalResponseObserver(@Nonnull ErrorTranslator errorTranslator, @Nonnull RequestMessageCreator<ReqT, RespT> messageCreator) {
        super(Objects.requireNonNull(errorTranslator, "errorTranslator"));
        this.messageCreator = Objects.requireNonNull(messageCreator, "messageCreator");
    }

    @Override
    public void beforeStart(ClientCallStreamObserver<ReqT> clientCallStreamObserver) {
        this.clientCallStreamObserver = clientCallStreamObserver;
    }

    @Override
    public void onError(Throwable t) {
        Status.Code code = Status.fromThrowable((Throwable)t).getCode();
        if (code == Status.Code.CANCELLED && (t instanceof StatusRuntimeException || t instanceof StatusException)) {
            t = t.getCause();
        }
        if (t == null) {
            this.onCompleted();
        } else {
            super.onError(this.maybeTranslate(t));
        }
    }

    public void onNext(RespT message) {
        Object next;
        Object v0 = next = this.messageCreator.hasMore() ? this.messageCreator.getNext(message) : null;
        if (next == null) {
            this.setResult(message);
            this.clientCallStreamObserver.onCompleted();
            this.onCompleted();
        } else {
            this.clientCallStreamObserver.onNext(next);
        }
    }

    @Override
    @Nonnull
    RespT asResult() {
        this.start();
        return (RespT)super.asResult();
    }

    private void start() {
        this.clientCallStreamObserver.onNext(this.messageCreator.getFirst());
    }
}

