/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.dmz.mesh.MeshConfigProvider;
import com.atlassian.stash.internal.scm.git.mesh.MeshProperty;
import com.atlassian.stash.internal.scm.git.mesh.MeshPropertyMapping;
import com.atlassian.stash.internal.utils.ExpressionUtils;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.core.convert.ConversionFailedException;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;

@Order(value=-2147483648)
public class CoreMeshConfigProvider
implements MeshConfigProvider {
    private static final Logger log = LoggerFactory.getLogger(CoreMeshConfigProvider.class);
    private static final Pattern PATTERN_PROPERTY_PLACEHOLDER = Pattern.compile("\\$\\{([^:}]+)([:}])");
    private static final MeshPropertyMapping PROPERTY_MAPPING = new MeshPropertyMapping.Builder().stringProperty("plugin.bitbucket-git.mesh.authentication.allowed-clock-skew", "authentication.allowed-clock-skew").stringProperty("plugin.bitbucket-git.mesh.authentication.expiry-interval", "authentication.expiry-interval").intProperty("commit.message.max").stringProperty("git.fsync").stringProperty("git.fsync-method").longProperty("plugin.bitbucket-git.commit-graph.threshold.full", "gc.commit-graph.threshold.full").longProperty("plugin.bitbucket-git.gc.convert.stash-refs", "gc.convert.stash-refs").longProperty("plugin.bitbucket-git.gc.delay", "gc.delay").longProperty("plugin.bitbucket-git.gc.log.retention", "gc.log.retention").intProperty("plugin.bitbucket-git.gc.max.attempts", "gc.max-attempts").intProperty("plugin.bitbucket-git.gc.threads", "gc.threads").longProperty("plugin.bitbucket-git.packrefs.interval", "gc.packrefs.interval").longProperty("plugin.bitbucket-git.packrefs.timeout", "gc.packrefs.timeout").longProperty("plugin.bitbucket-git.prune.expire.default", "gc.prune.expire.default").longProperty("plugin.bitbucket-git.prune.expire.shared-objects", "gc.prune.expire.shared-objects").longProperty("plugin.bitbucket-git.repack.interval", "gc.repack.interval").intProperty("plugin.bitbucket-git.repack.threshold.loose", "gc.repack.threshold.loose").longProperty("plugin.bitbucket-git.repack.threshold.loose-size", "gc.repack.threshold.loose-size").intProperty("plugin.bitbucket-git.repack.threshold.pack", "gc.repack.threshold.pack").longProperty("plugin.bitbucket-git.repack.timeout", "gc.repack.timeout").longProperty("plugin.bitbucket-git.vacuum.full.interval", "gc.vacuum.full.interval").longProperty("plugin.bitbucket-git.vacuum.interval", "gc.vacuum.interval").longProperty("mesh.hooks.buffer.capacity", "hooks.buffer.capacity").longProperty("mesh.hooks.callback.timeout", "hooks.callback.timeout").booleanProperty("plugin.bitbucket-git.hosting.allow-filter", "hosting.allow-filter").longProperty("grpc.fragment-size").longProperty("grpc.max-fragment-size").intProperty("plugin.bitbucket-git.mesh.grpc.max-message-size", "grpc.max-message-size").intProperty("plugin.bitbucket-git.mesh.grpc.max-metadata-size", "grpc.max-metadata-size").longProperty("grpc.server.keep-alive.time").booleanProperty("grpc.server.keep-alive.without-calls").booleanProperty("grpc.server.restart-on-configuration-change").intProperty("grpc.server.shutdown-timeout").booleanProperty("plugin.bitbucket-git.mesh.grpc.zero-copy", "grpc.zero-copy").longProperty("process.timeout.execution").longProperty("process.timeout.idle").booleanProperty("mesh.profiling.enabled", "profiling.enabled").intProperty("mesh.profiling.min-frame-time", "profiling.min-frame-time").intProperty("mesh.profiling.min-trace-time", "profiling.min-trace-time").intProperty("mesh.profiling.max-frame-name-length", "profiling.max-frame-name-length").doubleProperty("mesh.replication.content-hash-forced-recalculation-frequency", "replication.content-hash-forced-recalculation-frequency").stringProperty("mesh.replication.quorum-mode", "replication.quorum-mode").intProperty("storage.temp-expiry").doubleProperty("mesh.scaling.concurrency", "scaling.concurrency", true).intProperty("throttle.resource.mirror-hosting", true).intProperty("throttle.resource.mirror-hosting.fixed.limit", true).longProperty("throttle.resource.mirror-hosting.timeout").intProperty("throttle.resource.scm-command", true).intProperty("throttle.resource.scm-command.fixed.limit", true).longProperty("throttle.resource.scm-command.timeout").intProperty("throttle.resource.scm-hosting", true).doubleProperty("throttle.resource.scm-hosting.adaptive.cpu.target", true).intProperty("throttle.resource.scm-hosting.adaptive.limit.max", true).intProperty("throttle.resource.scm-hosting.adaptive.limit.min", true).longProperty("throttle.resource.scm-hosting.adaptive.mem.per.ticket", true).doubleProperty("throttle.resource.scm-hosting.adaptive.mem.threshold.high", true).doubleProperty("throttle.resource.scm-hosting.adaptive.mem.threshold.low", true).intProperty("throttle.resource.scm-hosting.fixed.limit", true).stringProperty("throttle.resource.scm-hosting.strategy").longProperty("throttle.resource.scm-hosting.timeout").intProperty("throttle.resource.scm-refs", true).intProperty("throttle.resource.scm-refs.fixed.limit", true).longProperty("throttle.resource.scm-refs.timeout").build();
    private static final Map<String, Object> SUPPORTED_UNMAPPED_PLACEHOLDERS = ImmutableMap.of((Object)"scaling.concurrency", (Object)"cpu");
    private final Resource[] configResources;
    private final Object lock;
    private int failures;
    private volatile Map<String, String> coreProperties;

    public CoreMeshConfigProvider(Resource ... configResources) {
        this.configResources = configResources;
        this.lock = new Object();
    }

    public void mergeConfig(@Nonnull MeshConfigProvider.ConfigBuilder builder) {
        this.getConfigMap().forEach((arg_0, arg_1) -> ((MeshConfigProvider.ConfigBuilder)builder).put(arg_0, arg_1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        Object object = this.lock;
        synchronized (object) {
            this.failures = 0;
            this.coreProperties = null;
        }
    }

    private static Map<String, String> buildConfigMap(Properties properties) {
        StandardEnvironment limitedEnvironment = new StandardEnvironment();
        limitedEnvironment.getPropertySources().addFirst((PropertySource)new PropertiesPropertySource("properties", properties));
        ImmutableMap.Builder builder = ImmutableMap.builder();
        PROPERTY_MAPPING.forEach((key, meshProperty) -> {
            String propertyValue = properties.getProperty((String)key);
            if (StringUtils.isBlank((CharSequence)propertyValue)) {
                return;
            }
            if (CoreMeshConfigProvider.hasCorrectType((PropertyResolver)limitedEnvironment, key, meshProperty)) {
                propertyValue = CoreMeshConfigProvider.maybeMapPlaceholders(properties.getProperty((String)key));
                if (StringUtils.isNotBlank((CharSequence)propertyValue)) {
                    builder.put((Object)meshProperty.getName(), (Object)propertyValue);
                }
            } else {
                log.info("Not propagating property {} to the mesh. It appears to be invalid ({})", key, (Object)propertyValue);
            }
        });
        properties.stringPropertyNames().stream().filter(key -> key.startsWith("mesh.logging.") || key.startsWith("mesh.git.version.")).forEach(key -> {
            String propertyValue = CoreMeshConfigProvider.maybeMapPlaceholders(properties.getProperty((String)key));
            if (StringUtils.isNotBlank((CharSequence)propertyValue)) {
                builder.put((Object)key.substring(5), (Object)propertyValue);
            }
        });
        return builder.build();
    }

    private static boolean hasCorrectType(PropertyResolver resolver, String key, MeshProperty meshProperty) {
        Class<?> type = meshProperty.getType();
        try {
            resolver.getProperty(key, type);
            return true;
        }
        catch (ConversionFailedException e) {
            if (meshProperty.isExpressionSupported()) {
                String property = resolver.getProperty(key);
                if (Double.class.equals(type)) {
                    return ExpressionUtils.parseExpressionAsDouble((String)property).isPresent();
                }
                if (Long.class.equals(type)) {
                    return ExpressionUtils.parseExpressionAsLong((String)property).isPresent();
                }
                if (Integer.class.equals(type)) {
                    return ExpressionUtils.parseExpressionAsInt((String)property).isPresent();
                }
            }
            return false;
        }
    }

    private static String maybeMapPlaceholders(String value) {
        if (value == null) {
            return null;
        }
        Matcher matcher = PATTERN_PROPERTY_PLACEHOLDER.matcher(value);
        if (!matcher.find()) {
            return value;
        }
        StringBuffer builder = new StringBuffer();
        do {
            String propertyName;
            MeshProperty meshProperty;
            if ((meshProperty = PROPERTY_MAPPING.get(propertyName = matcher.group(1))) == null) {
                if (SUPPORTED_UNMAPPED_PLACEHOLDERS.containsKey(propertyName)) continue;
                return null;
            }
            if (propertyName.equals(meshProperty.getName())) continue;
            String replacement = "\\$\\{" + meshProperty.getName() + matcher.group(2);
            matcher.appendReplacement(builder, replacement);
        } while (matcher.find());
        matcher.appendTail(builder);
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> getConfigMap() {
        if (this.coreProperties == null) {
            Object object = this.lock;
            synchronized (object) {
                block7: {
                    if (this.coreProperties == null) {
                        try {
                            this.coreProperties = CoreMeshConfigProvider.buildConfigMap(this.loadProperties());
                        }
                        catch (IOException e) {
                            log.warn("Could not read one or more config resources", (Throwable)e);
                            if (++this.failures < 5) break block7;
                            this.coreProperties = Collections.emptyMap();
                        }
                    }
                }
            }
        }
        return this.coreProperties == null ? Collections.emptyMap() : this.coreProperties;
    }

    private Properties loadProperties() throws IOException {
        Properties properties = new Properties();
        for (Resource resource : this.configResources) {
            try {
                PropertiesLoaderUtils.fillProperties((Properties)properties, (Resource)resource);
            }
            catch (FileNotFoundException | NoSuchFileException e) {
                log.debug("Config resource {} not found", (Object)resource.getFilename());
            }
        }
        return properties;
    }
}

