/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.NoSuchObjectException;
import com.atlassian.bitbucket.ServiceException;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.mesh.rpc.util.ByteStringUtils;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcGitError;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcInvalidRefName;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcInvalidTagName;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcRefNameConflict;
import com.atlassian.bitbucket.repository.ConflictingRefNameException;
import com.atlassian.bitbucket.repository.DuplicateRefException;
import com.atlassian.bitbucket.repository.InvalidRefNameException;
import com.atlassian.bitbucket.repository.MinimalRef;
import com.atlassian.bitbucket.repository.RefType;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.SimpleMinimalRef;
import com.atlassian.bitbucket.repository.StandardRefType;
import com.atlassian.bitbucket.scm.git.GitRefPattern;
import com.atlassian.stash.internal.scm.git.mesh.SigningErrorTranslator;
import com.google.protobuf.ByteString;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CreateTagErrorTranslator
extends SigningErrorTranslator {
    private static final Logger log = LoggerFactory.getLogger(CreateTagErrorTranslator.class);
    private final I18nService i18nService;

    CreateTagErrorTranslator(@Nonnull I18nService i18nService, @Nullable Repository repository) {
        super(i18nService, repository);
        this.i18nService = i18nService;
    }

    @Override
    @Nonnull
    protected ServiceException translate(@Nonnull RpcGitError error, @Nullable Throwable cause) {
        switch (Objects.requireNonNull(error, "error").getErrorOneofCase()) {
            case INVALID_REF_NAME: {
                return this.translate(error.getInvalidRefName());
            }
            case INVALID_TAG_NAME: {
                return this.translate(error.getInvalidTagName());
            }
            case REF_NAME_CONFLICT: {
                return this.translate(error.getRefNameConflict());
            }
        }
        return super.translate(error, cause);
    }

    private ServiceException translate(RpcInvalidRefName error) {
        String refName = error.getRefName().toStringUtf8();
        if (error.getReason() == RpcInvalidRefName.Reason.INVALID) {
            return new InvalidRefNameException(this.i18nService.createKeyedMessage("bitbucket.service.repository.tag.nameinvalid", new Object[]{refName}), refName);
        }
        return this.translateInvalidRefName(error);
    }

    private ServiceException translate(RpcRefNameConflict error) {
        String refName = error.getRefName().toStringUtf8();
        SimpleMinimalRef ref = ((SimpleMinimalRef.Builder)((SimpleMinimalRef.Builder)new SimpleMinimalRef.Builder().type((RefType)StandardRefType.TAG).id(refName)).displayId(GitRefPattern.TAGS.unqualify(refName))).build();
        String conflict = ByteStringUtils.emptyToNull((ByteString)error.getConflictName());
        if (conflict == null) {
            return new ConflictingRefNameException(this.i18nService.createKeyedMessage("bitbucket.git.tag.create.looserefconflict", new Object[]{ref.getDisplayId()}), (MinimalRef)ref);
        }
        return new ConflictingRefNameException(this.i18nService.createKeyedMessage("bitbucket.git.tag.create.packedrefconflict", new Object[]{ref.getDisplayId(), GitRefPattern.TAGS.unqualify(conflict)}), (MinimalRef)ref);
    }

    private ServiceException translate(RpcInvalidTagName error) {
        String tagName = Objects.requireNonNull(error, "error").getTagName().toStringUtf8();
        switch (error.getReason()) {
            default: {
                log.warn("Unexpected InvalidTagName error: {}", (Object)error.getReason());
            }
            case NAME_INVALID: {
                return new InvalidRefNameException(this.i18nService.createKeyedMessage("bitbucket.service.repository.tag.nameinvalid", new Object[]{tagName}), tagName);
            }
            case DUPLICATE: {
                return new DuplicateRefException(this.i18nService.createKeyedMessage("bitbucket.service.repository.tag.duplicate", new Object[]{tagName, this.repository.getName()}), tagName);
            }
            case START_POINT_NOT_FOUND: 
        }
        return new NoSuchObjectException(this.i18nService.createKeyedMessage("bitbucket.service.repository.tag.startpointinvalid", new Object[]{tagName}), tagName);
    }
}

