/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.util.concurrent.ExecutorUtils;
import com.atlassian.stash.internal.concurrent.ConcurrencyUtils;
import com.atlassian.stash.internal.scm.git.mesh.MeshConstants;
import com.google.common.util.concurrent.MoreExecutors;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.Context;
import io.grpc.Deadline;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import jakarta.annotation.Nullable;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class DeadlinePropagatingClientInterceptor
implements ClientInterceptor {
    private static final Logger log = LoggerFactory.getLogger(DeadlinePropagatingClientInterceptor.class);
    private final ScheduledExecutorService scheduler;

    public DeadlinePropagatingClientInterceptor() {
        this(ConcurrencyUtils.createScheduledExecutor((String)"mesh-grpc-deadline-timer", (ThreadGroup)MeshConstants.THREAD_GROUP_RPC));
    }

    DeadlinePropagatingClientInterceptor(ScheduledExecutorService scheduler) {
        this.scheduler = scheduler;
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        ClientCall delegate = next.newCall(method, callOptions);
        Deadline deadline = callOptions.getDeadline();
        if (deadline == null) {
            return delegate;
        }
        return new DeadlinePropagatingClientCall(delegate, deadline, method.getFullMethodName(), this.scheduler);
    }

    public void shutdown() {
        ExecutorUtils.shutdown((ExecutorService)this.scheduler, (Logger)log);
    }

    private static class DeadlinePropagatingClientCall<ReqT, RespT>
    extends ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT> {
        private final AtomicBoolean completed;
        private final Context.CancellableContext context;
        private final Map<String, String> mdc;
        private final String methodName;

        DeadlinePropagatingClientCall(ClientCall<ReqT, RespT> delegate, Deadline deadline, String methodName, ScheduledExecutorService scheduler) {
            super(delegate);
            this.methodName = methodName;
            this.completed = new AtomicBoolean();
            this.context = Context.current().withDeadline(deadline, scheduler);
            this.context.addListener(ctx -> {
                if (deadline.isExpired() && !this.completed.get()) {
                    scheduler.schedule(this::maybeCancel, 5L, TimeUnit.SECONDS);
                }
            }, MoreExecutors.directExecutor());
            this.mdc = MDC.getCopyOfContextMap();
        }

        public void cancel(@Nullable String message, @Nullable Throwable cause) {
            try {
                super.cancel(message, cause);
            }
            finally {
                this.completed.set(true);
                this.context.cancel(null);
            }
        }

        public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
            super.start(new DeadlinePropagatingListener<RespT>(responseListener, this.context, this.completed), headers);
        }

        private void maybeCancel() {
            if (this.completed.compareAndSet(false, true)) {
                boolean applyMdc;
                boolean bl = applyMdc = this.mdc != null && !this.mdc.isEmpty();
                if (applyMdc) {
                    MDC.setContextMap(this.mdc);
                }
                try {
                    log.info("Aborting {} because the deadline has expired", (Object)this.methodName);
                    this.delegate().cancel("Deadline has expired, aborting!", null);
                    this.context.cancel(null);
                }
                finally {
                    if (applyMdc) {
                        MDC.clear();
                    }
                }
            }
        }
    }

    private static class DeadlinePropagatingListener<RespT>
    extends ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT> {
        private final AtomicBoolean completed;
        private final Context.CancellableContext context;

        DeadlinePropagatingListener(ClientCall.Listener<RespT> delegate, Context.CancellableContext context, AtomicBoolean completed) {
            super(delegate);
            this.completed = completed;
            this.context = context;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onClose(Status status, Metadata trailers) {
            Context previous = this.context.attach();
            try {
                super.onClose(status, trailers);
            }
            finally {
                this.context.detach(previous);
                this.completed.set(true);
                this.context.cancel(null);
            }
        }

        public void onMessage(RespT message) {
            Context previous = this.context.attach();
            try {
                super.onMessage(message);
            }
            finally {
                this.context.detach(previous);
            }
        }

        public void onReady() {
            Context previous = this.context.attach();
            try {
                super.onReady();
            }
            finally {
                this.context.detach(previous);
            }
        }
    }
}

