/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.NoSuchObjectException;
import com.atlassian.bitbucket.Product;
import com.atlassian.bitbucket.ResourceBusyException;
import com.atlassian.bitbucket.ServiceException;
import com.atlassian.bitbucket.commit.NoSuchCommitException;
import com.atlassian.bitbucket.content.NoSuchPathException;
import com.atlassian.bitbucket.dmz.mesh.MeshResetHierarchyFailedException;
import com.atlassian.bitbucket.dmz.mesh.MeshRpcNotSupportedException;
import com.atlassian.bitbucket.dmz.repository.ForkHierarchyTooDeepException;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.mesh.InvalidMeshNodeKeyException;
import com.atlassian.bitbucket.mesh.MeshNodeConnectionException;
import com.atlassian.bitbucket.mesh.rpc.util.ByteStringUtils;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcCommandTimeout;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcCreateRepositoryFailed;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcDataStoreUnavailable;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcError;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcErrorUtils;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcFailedCommand;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcForkHierarchyTooDeep;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcGitError;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcGitErrorUtils;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcInvalidCommitish;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcInvalidPack;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcInvalidPublicKey;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcInvalidRefName;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcInvalidStartLine;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcInvalidTreeish;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcNoDefaultBranch;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcNoSuchCommit;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcNoSuchObject;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcNoSuchPath;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcNoSuchRepository;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcNodeUnconfigured;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcRemoteAuthenticationFailed;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcRepositoryAlreadyExists;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcRepositoryReadOnly;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcResetHierarchyFailed;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcResourceBusy;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcUnsupportedArgument;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcUnsupportedCommand;
import com.atlassian.bitbucket.repository.InvalidRefNameException;
import com.atlassian.bitbucket.repository.NoDefaultBranchException;
import com.atlassian.bitbucket.repository.NoSuchRepositoryException;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryAlreadyExistsException;
import com.atlassian.bitbucket.repository.RepositoryArchivedException;
import com.atlassian.bitbucket.repository.RepositoryOfflineException;
import com.atlassian.bitbucket.repository.RepositoryReadOnlyException;
import com.atlassian.bitbucket.scm.AuthenticationFailedScmException;
import com.atlassian.bitbucket.scm.CommandFailedException;
import com.atlassian.bitbucket.scm.CommandTimeoutException;
import com.atlassian.bitbucket.scm.CommandUsageException;
import com.atlassian.bitbucket.scm.git.command.GitUnsupportedCommandException;
import com.atlassian.bitbucket.util.PageStartOutOfBoundsException;
import com.atlassian.stash.internal.scm.git.mesh.ErrorTranslator;
import com.atlassian.stash.internal.scm.git.mesh.RpcUtils;
import com.google.protobuf.ByteString;
import io.grpc.Metadata;
import io.grpc.Status;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultErrorTranslator
implements ErrorTranslator {
    private static final Logger log = LoggerFactory.getLogger(DefaultErrorTranslator.class);
    protected final I18nService i18nService;
    protected final Repository repository;

    DefaultErrorTranslator(@Nonnull I18nService i18nService, @Nullable Repository repository) {
        this.i18nService = Objects.requireNonNull(i18nService, "i18nService");
        this.repository = repository;
    }

    @Override
    @Nonnull
    public Throwable maybeTranslate(@Nonnull Throwable cause) {
        if (cause instanceof ServiceException) {
            return cause;
        }
        ServiceException exception = this.translateIfKnownCause(cause);
        return exception == null ? cause : exception;
    }

    @Override
    @Nonnull
    public ServiceException translate(@Nonnull Throwable cause) {
        if (cause instanceof ServiceException) {
            return (ServiceException)cause;
        }
        ServiceException exception = this.translateIfKnownCause(cause);
        if (exception == null) {
            return this.translateDefault(cause);
        }
        return exception;
    }

    protected ServiceException translate(RpcError error, Throwable cause) {
        switch (Objects.requireNonNull(error, "error").getErrorOneofCase()) {
            case CREATE_REPOSITORY_FAILED: {
                return this.translateCreateRepositoryFailed(error.getCreateRepositoryFailed());
            }
            case DATA_STORE_UNAVAILABLE: {
                return this.translateDataStoreUnavailable(error.getDataStoreUnavailable());
            }
            case FORK_HIERARCHY_TOO_DEEP: {
                return this.translateForkHierarchyTooDeep(error.getForkHierarchyTooDeep());
            }
            case INVALID_PUBLIC_KEY: {
                return this.translateInvalidPublicKey(error.getInvalidPublicKey());
            }
            case NODE_UNCONFIGURED: {
                return this.translateNodeUnconfigured(error.getNodeUnconfigured());
            }
            case NO_SUCH_REPOSITORY: {
                return this.translateNoSuchRepository(error.getNoSuchRepository());
            }
            case REPOSITORY_ALREADY_EXISTS: {
                return this.translateRepositoryAlreadyExists(error.getRepositoryAlreadyExists());
            }
            case RESET_HIERARCHY_FAILED: {
                return this.translateResetHierarchyFailed(error.getResetHierarchyFailed());
            }
            case REPOSITORY_READ_ONLY: {
                return this.repository != null && this.repository.isArchived() ? this.translateRepositoryArchived(error.getRepositoryReadOnly()) : this.translateRepositoryReadOnly(error.getRepositoryReadOnly());
            }
            case RESOURCE_BUSY: {
                return this.translateResourceBusy(error.getResourceBusy());
            }
        }
        return this.translateDefault(cause);
    }

    protected ServiceException translate(RpcGitError error, Throwable cause) {
        switch (Objects.requireNonNull(error, "error").getErrorOneofCase()) {
            case COMMAND_TIMEOUT: {
                return this.translateTimeout(error.getCommandTimeout());
            }
            case INVALID_COMMITISH: {
                return this.translateInvalidCommitish(error.getInvalidCommitish());
            }
            case INVALID_FOLLOW_PATHSPEC: {
                return this.translateInvalidFollowPathspec(error);
            }
            case INVALID_PACK: {
                return this.translateInvalidPack(error.getInvalidPack());
            }
            case INVALID_REF_NAME: {
                return this.translateInvalidRefName(error.getInvalidRefName());
            }
            case INVALID_START_LINE: {
                return this.translateInvalidStartLine(error.getInvalidStartLine());
            }
            case INVALID_TREEISH: {
                return this.translateInvalidTreeish(error.getInvalidTreeish());
            }
            case MERGE_FAILED: {
                return this.translateMergeFailed(cause);
            }
            case NO_DEFAULT_BRANCH: {
                return this.translateNoDefaultBranch(error.getNoDefaultBranch());
            }
            case NO_SUCH_COMMIT: {
                return this.translateNoSuchCommit(error.getNoSuchCommit());
            }
            case NO_SUCH_OBJECT: {
                return this.translateNoSuchObject(error.getNoSuchObject());
            }
            case NO_SUCH_PATH: {
                return this.translateNoSuchPath(error.getNoSuchPath());
            }
            case REMOTE_AUTHENTICATION_FAILED: {
                return this.translateRemoteAuthenticationFailed(error.getRemoteAuthenticationFailed());
            }
            case USAGE: {
                return this.translateUsage(error);
            }
            case UNSUPPORTED_ARGUMENT: {
                return this.translateUnsupportedArgument(error, cause);
            }
            case UNSUPPORTED_COMMAND: {
                return this.translateUnsupportedCommand(error);
            }
            case WORK_TREE_WRITE_FAILED: {
                return this.translateWorkTreeWriteFailed(cause);
            }
            case NO_SUCH_REF: {
                return this.translateNoSuchRef(error);
            }
        }
        return this.translateDefault(error, cause);
    }

    protected ServiceException translateDefault(Throwable cause) {
        if (cause != null) {
            Status status = Status.fromThrowable((Throwable)cause);
            log.error(cause.getMessage());
            if (status.equals((Object)Status.ABORTED)) {
                return new CommandFailedException(this.i18nService.createKeyedMessage("bitbucket.scm.git.status.aborted", new Object[0]), cause);
            }
            if (status.equals((Object)Status.FAILED_PRECONDITION)) {
                return new CommandFailedException(this.i18nService.createKeyedMessage("bitbucket.scm.git.status.failedprecondition", new Object[0]), cause);
            }
            if (status.equals((Object)Status.INTERNAL)) {
                return new CommandFailedException(this.i18nService.createKeyedMessage("bitbucket.scm.git.status.internal", new Object[0]), cause);
            }
            if (status.equals((Object)Status.INVALID_ARGUMENT)) {
                return new CommandFailedException(this.i18nService.createKeyedMessage("bitbucket.scm.git.status.invalidargument", new Object[0]), cause);
            }
        }
        return new CommandFailedException(this.i18nService.createKeyedMessage("bitbucket.scm.command.failed", new Object[]{"Unknown", "-1"}), cause);
    }

    protected ServiceException translateDefault(RpcGitError error, Throwable cause) {
        if (error.hasFailedCommand()) {
            KeyedMessage message;
            RpcFailedCommand command = error.getFailedCommand();
            String commandLine = command.getCommandLine().toStringUtf8();
            String stderr = command.getStderr().trim();
            if (stderr.isEmpty()) {
                message = this.i18nService.createKeyedMessage("bitbucket.scm.command.failed", new Object[]{commandLine, command.getExitCode()});
            } else if (stderr.contains("bitbucket: migrated to Mesh")) {
                String repositoryName = this.repository == null ? "Repository" : this.repository.getProject().getKey() + "/" + this.repository.getSlug();
                message = this.i18nService.createKeyedMessage("bitbucket.git.readonly.migrating.to.mesh", new Object[]{repositoryName});
            } else {
                message = this.i18nService.createKeyedMessage("bitbucket.scm.command.failed.saying", new Object[]{commandLine, command.getExitCode(), stderr});
            }
            return new CommandFailedException(message, cause);
        }
        return this.translateDefault(cause);
    }

    protected ServiceException translateInvalidPack(RpcInvalidPack error) {
        Object reason = error.getReason().toString();
        if (error.hasDetails()) {
            reason = (String)reason + ": " + error.getDetails();
        }
        return new CommandFailedException(this.i18nService.createKeyedMessage("bitbucket.scm.git.pack.invalid", new Object[]{reason}));
    }

    protected ServiceException translateInvalidRefName(RpcInvalidRefName error) {
        String refName = error.getRefName().toStringUtf8();
        switch (error.getReason()) {
            default: {
                log.warn("Unrecognized InvalidRefName error: {}", (Object)error.getReason());
            }
            case INVALID: {
                return new InvalidRefNameException(this.i18nService.createKeyedMessage("bitbucket.service.repository.refname.invalid", new Object[]{refName}), refName);
            }
            case BLANK: {
                return new InvalidRefNameException(this.i18nService.createKeyedMessage("bitbucket.service.repository.refname.blank", new Object[0]), refName);
            }
            case TOO_LONG: {
                return new InvalidRefNameException(this.i18nService.createKeyedMessage("bitbucket.git.ref.qualified.name.too.long", new Object[]{error.getMaxLength()}), refName);
            }
            case WHITESPACE: 
        }
        return new InvalidRefNameException(this.i18nService.createKeyedMessage("bitbucket.service.repository.refname.whitespace", new Object[]{refName}), refName);
    }

    private ServiceException translateInvalidStartLine(RpcInvalidStartLine error) {
        return new PageStartOutOfBoundsException(this.i18nService.createKeyedMessage("bitbucket.scm.git.pagerequest.outofbounds", new Object[]{error.getStartLine()}));
    }

    protected CommandFailedException translateWorkTreeWriteFailed(Throwable cause) {
        return new CommandFailedException(this.i18nService.createKeyedMessage("bitbucket.git.worktree.write.failed", new Object[]{cause}));
    }

    private ServiceException translateCreateRepositoryFailed(RpcCreateRepositoryFailed error) {
        String repositoryName = this.repository == null ? error.getRepository() : this.repository.getProject().getKey() + "/" + this.repository.getSlug();
        return new CommandFailedException(this.i18nService.createKeyedMessage("bitbucket.git.repository.create.failed", new Object[]{repositoryName}), null);
    }

    private ServiceException translateDataStoreUnavailable(RpcDataStoreUnavailable ignored) {
        return new CommandFailedException(this.i18nService.createKeyedMessage("bitbucket.repository.store.unavailable", new Object[0]));
    }

    private ServiceException translateForkHierarchyTooDeep(RpcForkHierarchyTooDeep error) {
        String repositoryName = this.repository == null ? error.getRepository() : this.repository.getProject().getKey() + "/" + this.repository.getSlug();
        return new ForkHierarchyTooDeepException(error.getForkDepth(), this.i18nService.createKeyedMessage("bitbucket.git.repository.create.failed", new Object[]{repositoryName}));
    }

    private ServiceException translateIfKnownCause(@Nonnull Throwable cause) {
        Status.Code code;
        Metadata metadata = Status.trailersFromThrowable((Throwable)Objects.requireNonNull(cause, "cause"));
        if (metadata != null) {
            RpcGitError gitError = RpcGitErrorUtils.fromMetadata((Metadata)metadata);
            if (gitError != null) {
                return this.translate(gitError, cause);
            }
            RpcError error = RpcErrorUtils.fromMetadata((Metadata)metadata);
            if (error != null) {
                return this.translate(error, cause);
            }
        }
        if ((code = Status.fromThrowable((Throwable)Objects.requireNonNull(cause, "cause")).getCode()) == Status.Code.DEADLINE_EXCEEDED) {
            return new CommandTimeoutException(this.i18nService.createKeyedMessage("bitbucket.scm.command.timeout.no-details", new Object[0]), cause);
        }
        if (code == Status.Code.UNAVAILABLE) {
            if (this.repository != null) {
                return this.translateOffline(cause);
            }
            return this.translateUnavailable(cause);
        }
        if (code == Status.Code.UNIMPLEMENTED) {
            return this.translateUnimplemented(cause);
        }
        return null;
    }

    private InvalidRefNameException translateInvalidCommitish(RpcInvalidCommitish error) {
        String commitish = error.getCommitish().toStringUtf8();
        return new InvalidRefNameException(this.i18nService.createKeyedMessage("bitbucket.git.commandbuilder.invalidcommitish", new Object[]{commitish}), commitish);
    }

    private ServiceException translateInvalidFollowPathspec(RpcGitError error) {
        RpcFailedCommand command = error.getFailedCommand();
        return new CommandUsageException(this.i18nService.createKeyedMessage("bitbucket.git.log.followonepath", new Object[0]), command.getCommandLine().toStringUtf8(), command.getStderr());
    }

    private ServiceException translateInvalidPublicKey(RpcInvalidPublicKey error) {
        String i18nKey = error.getReason() == RpcInvalidPublicKey.Reason.EXPIRY_NOT_ALLOWED ? "bitbucket.service.mesh.node.publickey.expirynotallowed" : "bitbucket.service.mesh.node.publickey.invalid";
        throw new InvalidMeshNodeKeyException(this.i18nService.createKeyedMessage(i18nKey, new Object[0]));
    }

    private InvalidRefNameException translateInvalidTreeish(RpcInvalidTreeish error) {
        String treeish = error.getTreeish().toStringUtf8();
        return new InvalidRefNameException(this.i18nService.createKeyedMessage("bitbucket.git.commandbuilder.invalidtreeish", new Object[]{treeish}), treeish);
    }

    private CommandFailedException translateMergeFailed(Throwable cause) {
        return new CommandFailedException(this.i18nService.createKeyedMessage("bitbucket.git.merge.unknownerror", new Object[0]), cause);
    }

    private ServiceException translateNoDefaultBranch(RpcNoDefaultBranch error) {
        return new NoDefaultBranchException(this.i18nService.createKeyedMessage("bitbucket.git.no.default.branch.defined", new Object[0]), this.repository.getName(), ByteStringUtils.emptyToNull((ByteString)error.getBranchId()));
    }

    private NoSuchCommitException translateNoSuchCommit(RpcNoSuchCommit error) {
        String commitish = error.getCommitish().toStringUtf8();
        if (this.repository == null) {
            return new NoSuchCommitException(this.i18nService.createKeyedMessage("bitbucket.service.repository.commitnotfound.generic", new Object[]{commitish}), commitish);
        }
        return new NoSuchCommitException(this.i18nService.createKeyedMessage("bitbucket.service.repository.commitnotfound", new Object[]{this.repository.getName(), commitish}), commitish);
    }

    private NoSuchObjectException translateNoSuchObject(RpcNoSuchObject error) {
        String objectId = error.getObjectId().toStringUtf8();
        KeyedMessage message = this.repository == null ? this.i18nService.createKeyedMessage("bitbucket.service.repository.objectnotfound.generic", new Object[]{objectId}) : this.i18nService.createKeyedMessage("bitbucket.service.repository.objectnotfound", new Object[]{this.repository.getName(), objectId});
        return new NoSuchObjectException(message, objectId);
    }

    private NoSuchPathException translateNoSuchPath(RpcNoSuchPath error) {
        String commitish = error.getCommitish().toStringUtf8();
        String path = error.getPath().toStringUtf8();
        return new NoSuchPathException(this.i18nService.createKeyedMessage("bitbucket.service.repository.pathnotfound.atrevision", new Object[]{path, commitish}), path, commitish);
    }

    private ServiceException translateNoSuchRef(RpcGitError error) {
        String refId = error.getNoSuchRef().getRefName().toStringUtf8();
        if (this.repository == null) {
            return new NoSuchCommitException(this.i18nService.createKeyedMessage("bitbucket.service.repository.refnotfound.generic", new Object[]{refId}), refId);
        }
        return new NoSuchCommitException(this.i18nService.createKeyedMessage("bitbucket.service.repository.refnotfound", new Object[]{this.repository.getName(), refId}), refId);
    }

    private NoSuchRepositoryException translateNoSuchRepository(RpcNoSuchRepository error) {
        String id = error.getId();
        if (id.startsWith("path:")) {
            id = Paths.get(id.substring(5), new String[0]).getFileName().toString();
        }
        return new NoSuchRepositoryException(this.i18nService.createKeyedMessage("bitbucket.service.repository.nosuchrepo", new Object[]{id}), null);
    }

    private ServiceException translateNodeUnconfigured(RpcNodeUnconfigured error) {
        log.warn("{}: The target node has not been configured (Uptime: {}s)", (Object)this.repository, (Object)(error.getUptime() / 1000L));
        return this.translateOffline(null);
    }

    private ServiceException translateOffline(Throwable cause) {
        return new RepositoryOfflineException(this.i18nService.createKeyedMessage("bitbucket.scm.repository.offline", new Object[0]), this.i18nService.createKeyedMessage("bitbucket.scm.repository.offline.detail", new Object[0]), cause);
    }

    private ServiceException translateRemoteAuthenticationFailed(RpcRemoteAuthenticationFailed error) {
        String url = error.getUrl();
        throw new AuthenticationFailedScmException(this.i18nService.createKeyedMessage("bitbucket.git.mirror.remote.authenticationerror", new Object[]{url}), url);
    }

    private ServiceException translateRepositoryAlreadyExists(RpcRepositoryAlreadyExists error) {
        Path repositoryDir = Paths.get(error.getPath(), new String[0]);
        return new RepositoryAlreadyExistsException(this.i18nService.createKeyedMessage("bitbucket.service.repository.createfailed.directorypresent", new Object[]{error.getRepository(), repositoryDir}), repositoryDir);
    }

    private RepositoryArchivedException translateRepositoryArchived(RpcRepositoryReadOnly error) {
        return new RepositoryArchivedException(this.i18nService.createKeyedMessage("bitbucket.service.repository.updatearchived", new Object[]{error.getRepository()}));
    }

    private RepositoryReadOnlyException translateRepositoryReadOnly(RpcRepositoryReadOnly error) {
        return new RepositoryReadOnlyException(this.i18nService.createKeyedMessage("bitbucket.git.repository.readonly", new Object[]{error.getRepository()}));
    }

    private MeshResetHierarchyFailedException translateResetHierarchyFailed(RpcResetHierarchyFailed error) {
        return new MeshResetHierarchyFailedException(this.i18nService.createKeyedMessage("bitbucket.service.mesh.hierarchy.reset.failed", new Object[]{error.getHierarchy()}), error.getHierarchy());
    }

    private ServiceException translateResourceBusy(RpcResourceBusy error) {
        return new ResourceBusyException(this.i18nService.createKeyedMessage("bitbucket.resource.busy", new Object[0]), RpcUtils.toThrottledResourceName(error.getResource()));
    }

    private ServiceException translateTimeout(RpcCommandTimeout error) {
        return new CommandTimeoutException(this.i18nService.createKeyedMessage("bitbucket.scm.command.timeout", new Object[]{error.getCommandLine().toStringUtf8(), error.getExitCode()}));
    }

    private ServiceException translateUnavailable(Throwable cause) {
        return new MeshNodeConnectionException(this.i18nService.createKeyedMessage("bitbucket.service.mesh.node.unavailable", new Object[0]), cause);
    }

    private ServiceException translateUnimplemented(Throwable cause) {
        return new MeshRpcNotSupportedException(this.i18nService.createKeyedMessage("bitbucket.service.mesh.rpc.unimplemented", new Object[]{Product.DATA_CENTER_NAME}), cause);
    }

    private ServiceException translateUnsupportedArgument(RpcGitError gitError, Throwable cause) {
        RpcUnsupportedArgument error = gitError.getUnsupportedArgument();
        log.error("Remote side signals that argument is not supported: {}, value: {}", (Object)error.getReason(), (Object)error.getValue());
        if (error.getReason() == RpcUnsupportedArgument.Reason.UNSUPPORTED_COMBINATION) {
            String commandLine = gitError.hasFailedCommand() ? gitError.getFailedCommand().getCommandLine().toStringUtf8() : "";
            return new CommandUsageException(this.i18nService.createKeyedMessage("bitbucket.scm.git.invalid.syntax", new Object[0]), commandLine, error.getValue().toStringUtf8());
        }
        return this.translateDefault(gitError, cause);
    }

    private ServiceException translateUnsupportedCommand(RpcGitError gitError) {
        RpcUnsupportedCommand error = gitError.getUnsupportedCommand();
        String commandLine = error.getCommandLine().toStringUtf8();
        log.error("Remote side signals that command is not supported: {}", (Object)commandLine);
        return new GitUnsupportedCommandException(this.i18nService.createKeyedMessage("bitbucket.scm.git.unsupported.remote.command", new Object[]{commandLine}));
    }

    private CommandUsageException translateUsage(RpcGitError error) {
        RpcFailedCommand command = error.getFailedCommand();
        return new CommandUsageException(this.i18nService.createKeyedMessage("bitbucket.scm.git.invalid.syntax", new Object[0]), command.getCommandLine().toStringUtf8(), command.getStderr());
    }
}

