/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.dmz.repository.DmzRepository;
import com.atlassian.bitbucket.dmz.server.DmzStorageService;
import com.atlassian.bitbucket.internal.mesh.RepositoryIdUtils;
import com.atlassian.bitbucket.mesh.MeshNode;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcGitTimeouts;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.git.worktree.GitWorkTree;
import com.atlassian.stash.internal.concurrent.EmptyTransferableState;
import com.atlassian.stash.internal.concurrent.StatefulService;
import com.atlassian.stash.internal.concurrent.TransferableState;
import com.atlassian.stash.internal.scm.git.mesh.GitRequestHelper;
import com.atlassian.stash.internal.scm.git.mesh.MeshRouter;
import com.atlassian.stash.internal.scm.git.mesh.MessagePreparer;
import com.atlassian.stash.internal.scm.git.mesh.RouteHandle;
import com.atlassian.stash.internal.scm.git.mesh.worktree.MeshGitWorkTree;
import com.google.common.base.MoreObjects;
import com.google.protobuf.Descriptors;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.MessageOrBuilder;
import io.grpc.Context;
import io.grpc.Deadline;
import io.grpc.stub.AbstractStub;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public class DefaultGitRequestHelper
implements GitRequestHelper,
StatefulService {
    public static final Duration DEADLINE_PADDING = Duration.ofSeconds(10L);
    private final Duration defaultTimeout;
    private final RpcGitTimeouts defaultTimeouts;
    private final MeshRouter meshRouter;
    private final MessagePreparer[] messagePreparers;
    private final ThreadLocal<Map<Integer, String>> quarantineByRepositoryId;
    private final DmzStorageService storageService;

    public DefaultGitRequestHelper(MeshRouter meshRouter, MessagePreparer[] messagePreparers, DmzStorageService storageService, long executionTimeout, long idleTimeout) {
        this.meshRouter = meshRouter;
        this.messagePreparers = messagePreparers;
        this.storageService = storageService;
        this.defaultTimeout = Duration.ofSeconds(executionTimeout);
        this.defaultTimeouts = RpcGitTimeouts.newBuilder().setExecution(executionTimeout).setIdle(idleTimeout).build();
        this.quarantineByRepositoryId = new ThreadLocal();
    }

    @Override
    @Nonnull
    public <T extends AbstractStub<T>> T applyTimeout(@Nonnull T stub, @Nonnull MessageOrBuilder message, @Nullable Duration timeoutDuration) {
        Deadline deadline;
        Descriptors.Descriptor descriptor = message.getDescriptorForType();
        Duration timeout = timeoutDuration;
        if (timeout == null) {
            long execution = 0L;
            Descriptors.FieldDescriptor timeoutsField = descriptor.findFieldByName("timeouts");
            if (timeoutsField != null && message.hasField(timeoutsField)) {
                RpcGitTimeouts timeouts = (RpcGitTimeouts)message.getField(timeoutsField);
                execution = timeouts.getExecution();
            }
            if (execution <= 0L) {
                execution = this.defaultTimeouts.getExecution();
            }
            timeout = Duration.ofSeconds(execution).plus(DEADLINE_PADDING);
        }
        if ((deadline = Context.current().getDeadline()) != null && deadline.timeRemaining(TimeUnit.MILLISECONDS) <= timeout.toMillis()) {
            return (T)stub.withDeadline(deadline);
        }
        return (T)stub.withDeadlineAfter(timeout.toMillis(), TimeUnit.MILLISECONDS);
    }

    @Override
    @Nonnull
    public <T extends AbstractStub<T>> T applyTimeout(@Nonnull T stub, @Nullable Duration timeoutDuration) {
        Duration timeout = (Duration)MoreObjects.firstNonNull((Object)timeoutDuration, (Object)this.defaultTimeout);
        Deadline deadline = Context.current().getDeadline();
        if (deadline != null && deadline.timeRemaining(TimeUnit.MILLISECONDS) <= timeout.toMillis()) {
            return (T)stub.withDeadline(deadline);
        }
        if (timeout.isZero() || timeout.isNegative()) {
            return (T)stub.withDeadlineAfter(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        }
        return (T)stub.withDeadlineAfter(timeout.toMillis(), TimeUnit.MILLISECONDS);
    }

    @Nonnull
    public TransferableState getState() {
        final Map<Integer, String> quarantineMap = this.quarantineByRepositoryId.get();
        if (quarantineMap == null) {
            this.quarantineByRepositoryId.remove();
            return EmptyTransferableState.EMPTY;
        }
        return new TransferableState(){
            private final Map<Integer, String> state;
            {
                this.state = new HashMap<Integer, String>(quarantineMap);
            }

            public void apply() {
                DefaultGitRequestHelper.this.quarantineByRepositoryId.set(this.state);
            }

            public void remove() {
                DefaultGitRequestHelper.this.quarantineByRepositoryId.remove();
            }
        };
    }

    @Override
    @Nonnull
    public <B extends GeneratedMessageV3.Builder<B>> B prepareBuilder(@Nonnull B builder) {
        Descriptors.FieldDescriptor timeoutsField = builder.getDescriptorForType().findFieldByName("timeouts");
        if (timeoutsField != null && !builder.hasField(timeoutsField)) {
            builder = builder.setField(timeoutsField, (Object)this.defaultTimeouts);
        }
        for (MessagePreparer preparers : this.messagePreparers) {
            builder = preparers.prepare(builder);
        }
        return builder;
    }

    @Override
    @Nonnull
    public <B extends GeneratedMessageV3.Builder<B>> B prepareBuilder(@Nonnull Repository repository, @Nonnull B builder) {
        Descriptors.FieldDescriptor repositoryField = builder.getDescriptorForType().findFieldByName("repository");
        if (repositoryField != null) {
            this.setField(builder, repositoryField, this.toRepositoryId(repository));
        }
        return this.prepareBuilder(builder);
    }

    @Override
    @Nonnull
    public <B extends GeneratedMessageV3.Builder<B>> B prepareBuilder(@Nonnull GitWorkTree workTree, @Nonnull B builder) {
        Descriptors.FieldDescriptor workTreeField = builder.getDescriptorForType().findFieldByName("work_tree");
        if (workTreeField == null) {
            Descriptors.FieldDescriptor repositoryField = builder.getDescriptorForType().findFieldByName("repository");
            if (repositoryField != null) {
                this.setField(builder, repositoryField, this.toWorkTreeId(workTree));
            }
        } else {
            this.setField(builder, workTreeField, this.toWorkTreeId(workTree));
        }
        return this.prepareBuilder(builder);
    }

    @Override
    @Nonnull
    public String toRepositoryId(@Nonnull Repository repository) {
        Objects.requireNonNull(repository, "repository");
        Map<Integer, String> quarantineMap = this.quarantineByRepositoryId.get();
        String id = quarantineMap == null ? null : quarantineMap.get(repository.getId());
        return id == null ? this.internalToRepositoryId(repository) : id;
    }

    @Override
    @Nonnull
    public String toWorkTreeId(@Nonnull GitWorkTree workTree) {
        Objects.requireNonNull(workTree, "workTree");
        return this.internalWorkTreeId(workTree);
    }

    @Override
    public void withQuarantine(@Nonnull Repository repository, @Nonnull MeshNode targetNode, @Nonnull String quarantinedId, @Nonnull Runnable runnable) {
        this.withQuarantine(repository, targetNode, quarantinedId, () -> {
            runnable.run();
            return null;
        });
    }

    @Override
    @Nonnull
    public <T> T withQuarantine(@Nonnull Repository repository, @Nonnull MeshNode targetNode, @Nonnull String quarantinedId, @Nonnull Supplier<T> operation) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(targetNode, "targetNode");
        Objects.requireNonNull(quarantinedId, "quarantinedId");
        Objects.requireNonNull(operation, "operation");
        Map<Integer, String> quarantineMap = this.quarantineByRepositoryId.get();
        if (quarantineMap == null) {
            quarantineMap = new HashMap<Integer, String>();
            quarantineMap.put(repository.getId(), quarantinedId);
            this.quarantineByRepositoryId.set(quarantineMap);
            try {
                T t;
                block21: {
                    RouteHandle pinnedRoute = this.meshRouter.assignRepository(repository, targetNode);
                    try {
                        t = operation.get();
                        if (pinnedRoute == null) break block21;
                        pinnedRoute.close();
                    }
                    catch (Throwable throwable) {
                        if (pinnedRoute != null) {
                            try {
                                pinnedRoute.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                }
                return t;
            }
            finally {
                this.quarantineByRepositoryId.remove();
            }
        }
        String oldValue = quarantineMap.put(repository.getId(), quarantinedId);
        try {
            T t;
            block22: {
                RouteHandle pinnedRoute = this.meshRouter.assignRepository(repository, targetNode);
                try {
                    t = operation.get();
                    if (pinnedRoute == null) break block22;
                    pinnedRoute.close();
                }
                catch (Throwable throwable) {
                    if (pinnedRoute != null) {
                        try {
                            pinnedRoute.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    }
                    throw throwable;
                }
            }
            return t;
        }
        finally {
            if (oldValue == null) {
                quarantineMap.remove(repository.getId());
            } else {
                quarantineMap.put(repository.getId(), oldValue);
            }
        }
    }

    private String internalToRepositoryId(Repository repository) {
        if (repository instanceof DmzRepository) {
            return RepositoryIdUtils.getRepositoryId((DmzRepository)((DmzRepository)repository));
        }
        return "path:" + String.valueOf(this.storageService.getRepositoryDir(repository));
    }

    private String internalWorkTreeId(GitWorkTree workTree) {
        if (workTree instanceof MeshGitWorkTree) {
            return ((MeshGitWorkTree)workTree).getWorkTreeId();
        }
        return "workTree:" + this.internalToRepositoryId(workTree.getRepository());
    }

    private <B extends GeneratedMessageV3.Builder<B>> B setField(B builder, Descriptors.FieldDescriptor field, String value) {
        if (field.getJavaType() == Descriptors.FieldDescriptor.JavaType.STRING) {
            builder = builder.setField(field, (Object)value);
        }
        return builder;
    }
}

