/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.dmz.mesh.MeshNodeUnregisteredEvent;
import com.atlassian.bitbucket.dmz.mesh.MisconfiguredMeshClientDetectedEvent;
import com.atlassian.bitbucket.dmz.repository.DmzRepository;
import com.atlassian.bitbucket.event.mesh.MeshNodeUpdatedEvent;
import com.atlassian.bitbucket.mesh.MeshNode;
import com.atlassian.bitbucket.mesh.MeshService;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.topic.Topic;
import com.atlassian.bitbucket.topic.TopicService;
import com.atlassian.bitbucket.topic.TopicSettings;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.util.concurrent.ExecutorUtils;
import com.atlassian.event.api.EventListener;
import com.atlassian.stash.internal.concurrent.ConcurrencyUtils;
import com.atlassian.stash.internal.mesh.MutableMeshNodeRegistry;
import com.atlassian.stash.internal.scm.git.mesh.MeshChannel;
import com.atlassian.stash.internal.scm.git.mesh.MeshClient;
import com.atlassian.stash.internal.scm.git.mesh.MeshConstants;
import com.atlassian.stash.internal.scm.git.mesh.MeshRouter;
import com.atlassian.stash.internal.scm.git.mesh.MeshSidebandRegistry;
import com.atlassian.stash.internal.scm.git.mesh.MeshStub;
import com.atlassian.stash.internal.scm.git.mesh.worktree.MeshGitWorkTree;
import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.NegotiationType;
import io.grpc.netty.NettyChannelBuilder;
import io.grpc.stub.AbstractStub;
import io.netty.handler.ssl.SslContext;
import jakarta.annotation.Nonnull;
import jakarta.annotation.PostConstruct;
import java.io.Serializable;
import java.net.URI;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.net.ssl.SSLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMeshClient
implements MeshClient {
    static final String CLOSE_CHANNEL_TOPIC = "atl.bbs.mesh.client-close-channel";
    private static final Logger log = LoggerFactory.getLogger(DefaultMeshClient.class);
    private final ConcurrentMap<Long, MeshChannel> channelsByNodeId;
    private final Topic<CloseChannelMessage> closeChannelTopic;
    private final ExecutorService executorService;
    private final ClientInterceptor[] interceptors;
    private final Duration keepAliveTime;
    private final boolean keepAliveWithoutCalls;
    private final int maxMessageSize;
    private final int maxMetadataSize;
    private final MeshService meshService;
    private final MutableMeshNodeRegistry nodeRegistry;
    private final MeshRouter router;
    private final SecurityService securityService;
    private final MeshSidebandRegistry sidebandRegistry;
    private final SslContext sslContext;

    public DefaultMeshClient(ClassLoader appClassLoader, ClientInterceptor[] interceptors, MeshService meshService, MutableMeshNodeRegistry nodeRegistry, MeshRouter router, SecurityService securityService, MeshSidebandRegistry sidebandRegistry, TopicService topicService, Duration keepAliveTime, boolean keepAliveWithoutCalls, int maxMessageSize, int maxMetadataSize) {
        this.interceptors = interceptors;
        this.securityService = securityService;
        this.keepAliveTime = keepAliveTime;
        this.keepAliveWithoutCalls = keepAliveWithoutCalls;
        this.maxMessageSize = maxMessageSize;
        this.maxMetadataSize = maxMetadataSize;
        this.meshService = meshService;
        this.nodeRegistry = nodeRegistry;
        this.router = router;
        this.sidebandRegistry = sidebandRegistry;
        this.channelsByNodeId = new ConcurrentHashMap<Long, MeshChannel>();
        this.executorService = Executors.newCachedThreadPool(ConcurrencyUtils.createDaemonThreadFactory((String)"mesh-grpc-request", (ThreadGroup)MeshConstants.THREAD_GROUP_RPC, (ClassLoader)appClassLoader));
        this.sslContext = DefaultMeshClient.buildSslContext();
        this.closeChannelTopic = topicService.getTopic(CLOSE_CHANNEL_TOPIC, TopicSettings.builder(CloseChannelMessage.class).queueSize(100).dedupePendingMessages(true).build());
    }

    @PostConstruct
    public void init() {
        this.closeChannelTopic.subscribe(messageEvent -> {
            if (!messageEvent.getSource().isLocal()) {
                CloseChannelMessage message = (CloseChannelMessage)messageEvent.getMessage();
                this.closeChannel(message.getNodeId(), message.isGraceful());
            }
        });
    }

    @Override
    @Nonnull
    public <S extends AbstractStub<S>> MeshStub<S> newStub(@Nonnull Function<Channel, S> stubFactory) {
        return new SimpleMeshStub<S>(Objects.requireNonNull(stubFactory, "stubFactory"));
    }

    @EventListener
    public void onMeshNodeUnregistered(MeshNodeUnregisteredEvent event) {
        this.triggerCloseChannel(event.getNodeId(), false);
    }

    @EventListener
    public void onMeshNodeUpdated(MeshNodeUpdatedEvent event) {
        this.triggerCloseChannel(event.getNodeId(), true);
    }

    @EventListener
    public void onStateMeshClientDetected(MisconfiguredMeshClientDetectedEvent event) {
        log.info("Closing stale gRPC channel for {}", (Object)event.getNode());
        this.closeChannel(event.getNode().getId(), false);
    }

    @Override
    @Nonnull
    public ManagedChannel openChannel(@Nonnull MeshNode node) {
        return this.channelBuilder(Objects.requireNonNull(node, "node")).build();
    }

    @Override
    public void sendHeartbeat(@Nonnull MeshNode node) {
        this.sidebandRegistry.sendHeartbeat(this.getChannel(Objects.requireNonNull(node, "node")));
    }

    public void shutdown() {
        try {
            this.channelsByNodeId.values().forEach(channel -> {
                this.sidebandRegistry.unregister((MeshChannel)channel);
                channel.close();
            });
        }
        finally {
            ExecutorUtils.shutdown((ExecutorService)this.executorService, (Logger)log);
        }
    }

    private static SslContext buildSslContext() {
        try {
            return GrpcSslContexts.forClient().build();
        }
        catch (IllegalStateException | SSLException e) {
            log.error("Unable to build SSL context", (Throwable)e);
            return null;
        }
    }

    private NettyChannelBuilder channelBuilder(MeshNode node) {
        URI uri = URI.create(node.getRpcUrl());
        String host = uri.getHost();
        int port = uri.getPort();
        boolean tls = !"http".equals(uri.getScheme());
        log.debug("Creating gRPC channel for {}:{}", (Object)host, (Object)port);
        return ((NettyChannelBuilder)((NettyChannelBuilder)((NettyChannelBuilder)NettyChannelBuilder.forAddress((String)host, (int)port).executor((Executor)this.executorService)).intercept(this.interceptors)).keepAliveTime(this.keepAliveTime.toMillis(), TimeUnit.MILLISECONDS).keepAliveWithoutCalls(this.keepAliveWithoutCalls).maxInboundMessageSize(this.maxMessageSize).maxInboundMetadataSize(this.maxMetadataSize).negotiationType(tls ? NegotiationType.TLS : NegotiationType.PLAINTEXT).offloadExecutor((Executor)this.executorService)).sslContext(tls ? this.sslContext : null);
    }

    private void closeChannel(long nodeId, boolean graceful) {
        this.channelsByNodeId.compute(nodeId, (ignored, channel) -> {
            if (channel != null) {
                log.debug("Closing gRPC channel for {} {}", (Object)nodeId, (Object)(graceful ? "gracefully" : "immediately"));
                this.sidebandRegistry.unregister((MeshChannel)channel);
                if (graceful) {
                    channel.close();
                } else {
                    channel.closeNow();
                }
            } else {
                log.warn("Attempted to close nonexistent channel for {}", (Object)nodeId);
            }
            return null;
        });
    }

    private MeshChannel getChannel(MeshNode node) {
        return this.channelsByNodeId.computeIfAbsent(node.getId(), id -> {
            if (!node.isSidecar()) {
                this.securityService.withPermission(Permission.SYS_ADMIN, "Checking Mesh node validity").call(() -> {
                    this.meshService.getMember(node.getId());
                    return null;
                });
            }
            MeshChannel channel = new MeshChannel(node, (ManagedChannelBuilder<?>)this.channelBuilder(node), this.nodeRegistry);
            this.sidebandRegistry.register(channel);
            return channel;
        });
    }

    private void triggerCloseChannel(long nodeId, boolean graceful) {
        this.closeChannel(nodeId, graceful);
        this.closeChannelTopic.publish((Serializable)new CloseChannelMessage(nodeId, graceful));
    }

    private static class CloseChannelMessage
    implements Serializable {
        private final boolean graceful;
        private final long nodeId;

        private CloseChannelMessage(long nodeId, boolean graceful) {
            this.nodeId = nodeId;
            this.graceful = graceful;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CloseChannelMessage that = (CloseChannelMessage)o;
            return this.nodeId == that.nodeId;
        }

        public long getNodeId() {
            return this.nodeId;
        }

        public boolean isGraceful() {
            return this.graceful;
        }

        public int hashCode() {
            return Objects.hash(this.nodeId);
        }
    }

    private class SimpleMeshStub<S extends AbstractStub<S>>
    implements MeshStub<S> {
        private final Function<Channel, S> stubFactory;

        SimpleMeshStub(Function<Channel, S> stubFactory) {
            this.stubFactory = stubFactory;
        }

        @Override
        @Nonnull
        public Stream<S> forAllNodes() {
            return DefaultMeshClient.this.router.stream().map(this::forNode);
        }

        @Override
        @Nonnull
        public S forAnyReplica(@Nonnull Repository repository) {
            return this.stubForRepository(repository, () -> DefaultMeshClient.this.router.forAnyReplica(repository));
        }

        @Override
        @Nonnull
        public S forNode(@Nonnull MeshNode node) {
            return DefaultMeshClient.this.getChannel(Objects.requireNonNull(node, "node")).newStub(this.stubFactory);
        }

        @Override
        @Nonnull
        public S forRepositories(@Nonnull Repository repository, @Nonnull Set<Repository> related) {
            if (Objects.requireNonNull(related, "related").isEmpty()) {
                return this.forRepository(repository);
            }
            return this.stubForRepository(repository, () -> DefaultMeshClient.this.router.forRepositories(repository, related));
        }

        @Override
        @Nonnull
        public S forRepository(@Nonnull Repository repository) {
            return this.stubForRepository(repository, () -> DefaultMeshClient.this.router.forRepository(repository));
        }

        @Override
        @Nonnull
        public Optional<S> forSidecar() {
            return DefaultMeshClient.this.router.forSidecar().map(this::forNode);
        }

        @Override
        @Nonnull
        public S forWorkTree(@Nonnull MeshGitWorkTree workTree) {
            Objects.requireNonNull(workTree, "workTree");
            return this.forNode(workTree.getTargetNode());
        }

        private S enrich(int partition, S stub) {
            return (S)(partition >= 0 ? stub.withOption(MeshConstants.OPT_PARTITION, (Object)partition) : stub);
        }

        private S forSidecarOrThrow() {
            return (S)((AbstractStub)this.forSidecar().orElseThrow(() -> new IllegalStateException("Cannot route to sidecar")));
        }

        private S stubForRepository(@Nonnull Repository repository, Supplier<MeshNode> node) {
            if (Objects.requireNonNull(repository, "repository") instanceof DmzRepository) {
                return this.enrich(repository.getPartition(), this.forNode(node.get()));
            }
            return this.forSidecarOrThrow();
        }
    }
}

