/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.Product;
import com.atlassian.bitbucket.dmz.mesh.DmzMeshConsistencyCheckService;
import com.atlassian.bitbucket.dmz.mesh.MeshRepositoryConsistencySummary;
import com.atlassian.bitbucket.repository.NoSuchRepositoryException;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.CommandTimeoutException;
import com.atlassian.bitbucket.scm.CreateCommandParameters;
import com.atlassian.bitbucket.scm.ForkCommandParameters;
import com.atlassian.stash.internal.mesh.InternalMeshPartitionRegistry;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.internal.scm.InternalScmService;
import com.atlassian.stash.internal.scm.git.mesh.RpcRepositoryClient;
import com.atlassian.util.profiling.Ticker;
import com.atlassian.util.profiling.Timer;
import com.atlassian.util.profiling.Timers;
import com.google.common.collect.Maps;
import jakarta.annotation.Nonnull;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;

@PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
public class DefaultMeshConsistencyCheckService
implements DmzMeshConsistencyCheckService {
    private static final CompletableFuture<Void> READY = CompletableFuture.completedFuture(null);
    private static final Timer TIMER_ACQUIRE_SLOT = Timers.timer((String)(DefaultMeshConsistencyCheckService.class.getSimpleName() + " - acquire consistency-check slot"));
    private static final Logger log = LoggerFactory.getLogger(DefaultMeshConsistencyCheckService.class);
    private final ExecutorService executorService;
    private final InternalMeshPartitionRegistry partitionRegistry;
    private final RpcRepositoryClient repositoryClient;
    private final InternalScmService scmService;
    private final Semaphore semaphore;

    public DefaultMeshConsistencyCheckService(ExecutorService executorService, InternalMeshPartitionRegistry partitionRegistry, RpcRepositoryClient repositoryClient, InternalScmService scmService, int maxConcurrency) {
        this.executorService = executorService;
        this.partitionRegistry = partitionRegistry;
        this.repositoryClient = repositoryClient;
        this.scmService = scmService;
        this.semaphore = new Semaphore(Math.max(1, maxConcurrency));
    }

    @Nonnull
    public DmzMeshConsistencyCheckService.Checker newChecker(@Nonnull BiConsumer<Repository, String> callback) {
        return new MeshRepositoryConsistencyChecker(Objects.requireNonNull(callback, "callback"));
    }

    private class MeshRepositoryConsistencyChecker
    implements DmzMeshConsistencyCheckService.Checker {
        private final BiConsumer<Repository, String> callback;
        private final Map<Integer, CompletableFuture<Void>> checks;

        MeshRepositoryConsistencyChecker(BiConsumer<Repository, String> callback) {
            this.callback = callback;
            this.checks = Maps.newHashMap();
        }

        public void await() throws InterruptedException {
            for (CompletableFuture<Void> future : this.checks.values()) {
                try {
                    future.get();
                }
                catch (ExecutionException executionException) {}
            }
        }

        public void await(long timeout, @Nonnull TimeUnit timeUnit) throws InterruptedException, TimeoutException {
            long start = System.nanoTime();
            long timeoutNs = Objects.requireNonNull(timeUnit, "timeUnit").toNanos(timeout);
            for (CompletableFuture<Void> future : this.checks.values()) {
                try {
                    future.get(timeoutNs - (System.nanoTime() - start), TimeUnit.NANOSECONDS);
                }
                catch (ExecutionException executionException) {}
            }
        }

        public void startCheck(@Nonnull Repository repository) {
            this.maybeStartConsistencyCheck(Objects.requireNonNull(repository, "repository"));
        }

        private void createMissing(Repository repository) {
            DefaultMeshConsistencyCheckService.this.partitionRegistry.resetRepository(repository);
            InternalRepository origin = (InternalRepository)repository.getOrigin();
            try {
                if (origin != null) {
                    DefaultMeshConsistencyCheckService.this.scmService.fork((Repository)origin, new ForkCommandParameters.Builder(repository).build());
                } else {
                    DefaultMeshConsistencyCheckService.this.scmService.create(repository, new CreateCommandParameters.Builder().build());
                }
                this.notifyCallback(repository, "The repository %s/%s exists in the database but not in %s. To restore integrity, an empty repository was created.", repository.getProject().getKey(), repository.getSlug(), Product.MESH_NAME);
            }
            catch (RuntimeException e) {
                this.notifyCallback(repository, "The repository %s/%s exists in the database but not in %s. To restore integrity, an empty repository was created, but this failed.", repository.getProject().getKey(), repository.getSlug(), Product.MESH_NAME);
                log.warn("[{}] Failed to create missing repository", (Object)repository, (Object)e);
            }
        }

        private CompletableFuture<Void> maybeStartConsistencyCheck(Repository repository) {
            MutableBoolean created = new MutableBoolean();
            CompletableFuture future = this.checks.computeIfAbsent(repository.getId(), ignored -> {
                created.setTrue();
                return new CompletableFuture();
            });
            if (created.isFalse()) {
                return future;
            }
            Repository origin = repository.getOrigin();
            CompletableFuture<Void> originCheck = origin == null ? READY : this.maybeStartConsistencyCheck(origin);
            originCheck.whenCompleteAsync((ignored, ex) -> this.startConsistencyCheck(repository, future), (Executor)DefaultMeshConsistencyCheckService.this.executorService);
            return future;
        }

        private void notifyCallback(Repository repository, String fmtString, Object ... parameters) {
            String message = String.format(fmtString, parameters);
            try {
                this.callback.accept(repository, message);
            }
            catch (RuntimeException e) {
                log.warn("[{}] Consistency check callback failed for message '{}'", new Object[]{repository, message, e});
            }
        }

        private void processConsistencySummary(Repository repository, MeshRepositoryConsistencySummary summary) {
            DefaultMeshConsistencyCheckService.this.partitionRegistry.reportRepositoryConsistencySummary(summary);
            int consistentReplicaCount = summary.getConsistentReplicas().size();
            int inconsistentReplicaCount = summary.getInconsistentReplicas().size();
            int unavailableReplicaCount = summary.getUnavailableReplicas().size();
            int replicaCount = consistentReplicaCount + inconsistentReplicaCount + unavailableReplicaCount;
            int quorumSize = replicaCount / 2 + 1;
            if (inconsistentReplicaCount > 0) {
                if (inconsistentReplicaCount == 1) {
                    this.notifyCallback(repository, "The replica of %s/%s on %s node %d is inconsistent and has been scheduled for repair", repository.getProject().getKey(), repository.getSlug(), Product.MESH_NAME, summary.getInconsistentReplicas().iterator().next());
                } else {
                    this.notifyCallback(repository, "The replicas of %s/%s on %s nodes %s are inconsistent and have been scheduled for repair", repository.getProject().getKey(), repository.getSlug(), Product.MESH_NAME, summary.getInconsistentReplicas().toString());
                }
            }
            if (unavailableReplicaCount >= quorumSize) {
                this.notifyCallback(repository, "Too many %s nodes holding a replica of %s/%s are currently unavailable to reliably determine the latest version. Start the nodes in question and re-run the consistency checks (%d out of %d are unavailable)", Product.MESH_NAME, repository.getProject().getKey(), repository.getSlug(), unavailableReplicaCount, replicaCount);
            }
        }

        private void startConsistencyCheck(Repository repository, CompletableFuture<Void> future) {
            try {
                try (Ticker ignored = TIMER_ACQUIRE_SLOT.start(new String[0]);){
                    DefaultMeshConsistencyCheckService.this.semaphore.acquire();
                }
                long startNanos = System.nanoTime();
                DefaultMeshConsistencyCheckService.this.repositoryClient.verifyConsistency(repository).handle((summary, ex) -> {
                    try {
                        DefaultMeshConsistencyCheckService.this.semaphore.release();
                        Throwable cause = ex;
                        while (cause instanceof CompletionException || cause instanceof ExecutionException) {
                            cause = cause.getCause();
                        }
                        if (cause instanceof NoSuchRepositoryException) {
                            this.createMissing(repository);
                        } else if (cause instanceof CommandTimeoutException) {
                            this.notifyCallback(repository, "The consistency check for %s/%s timed out", repository.getProject().getKey(), repository.getSlug());
                        } else if (ex != null) {
                            this.notifyCallback(repository, "The consistency check for %s/%s failed. Check the logs for more details.", repository.getProject().getKey(), repository.getSlug());
                            log.warn("[{}] Consistency check failed", (Object)repository, ex);
                        }
                        if (summary != null) {
                            this.processConsistencySummary(repository, (MeshRepositoryConsistencySummary)summary);
                        }
                    }
                    catch (RuntimeException e) {
                        log.warn("[{}] Failed to process consistency summary", (Object)repository, (Object)e);
                    }
                    finally {
                        log.debug("[{}] Consistency check completed in {}ms", (Object)repository, (Object)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNanos));
                        future.complete(null);
                    }
                    return null;
                });
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.warn("[{}] Interrupted while waiting for a consistency-check slot to become available", (Object)repository);
            }
        }
    }
}

