/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.cluster.ClusterService;
import com.atlassian.bitbucket.dmz.mesh.DmzMeshNodeRegistry;
import com.atlassian.bitbucket.dmz.mesh.DmzMeshPartitionRegistry;
import com.atlassian.bitbucket.dmz.mesh.MeshPartition;
import com.atlassian.bitbucket.dmz.mesh.MeshPartitionNotAssignedException;
import com.atlassian.bitbucket.dmz.mesh.MeshPartitionReplica;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.mesh.MeshNode;
import com.atlassian.bitbucket.mesh.RepositoryInconsistentException;
import com.atlassian.bitbucket.repository.IllegalRepositoryStateException;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.request.RequestLocal;
import com.atlassian.bitbucket.request.RequestManager;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.stash.internal.concurrent.CompositeTransferableState;
import com.atlassian.stash.internal.concurrent.EmptyTransferableState;
import com.atlassian.stash.internal.concurrent.StatefulService;
import com.atlassian.stash.internal.concurrent.TransferableState;
import com.atlassian.stash.internal.mesh.MeshClientConfig;
import com.atlassian.stash.internal.mesh.MeshRoutingMode;
import com.atlassian.stash.internal.scm.git.mesh.MeshRouter;
import com.atlassian.stash.internal.scm.git.mesh.MeshRouterHierarchyMismatchException;
import com.atlassian.stash.internal.scm.git.mesh.RouteHandle;
import com.atlassian.stash.internal.scm.git.mesh.SidecarManager;
import com.atlassian.stash.internal.scm.git.mesh.SidecarNode;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.Nonnull;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMeshRouter
implements MeshRouter,
StatefulService {
    private static final Logger log = LoggerFactory.getLogger(DefaultMeshRouter.class);
    private static final RouteHandle NO_OP = () -> {};
    private final String availabilityZone;
    private final MeshClientConfig clientConfig;
    private final I18nService i18nService;
    private final DmzMeshNodeRegistry nodeRegistry;
    private final DmzMeshPartitionRegistry partitionRegistry;
    private final IdRoutes partitionRoutes;
    private final IdRoutes repositoryRoutes;
    private final SidecarNode sidecar;

    public DefaultMeshRouter(MeshClientConfig clientConfig, ClusterService clusterService, I18nService i18nService, DmzMeshNodeRegistry nodeRegistry, DmzMeshPartitionRegistry partitionRegistry, RequestManager requestManager, SidecarManager sidecarManager) {
        this.clientConfig = clientConfig;
        this.i18nService = i18nService;
        this.nodeRegistry = nodeRegistry;
        this.partitionRegistry = partitionRegistry;
        this.availabilityZone = clusterService.getInformation().getLocalNode().getAvailabilityZone().orElse(null);
        this.partitionRoutes = new IdRoutes(requestManager);
        this.repositoryRoutes = new IdRoutes(requestManager);
        this.sidecar = sidecarManager.getSidecar();
    }

    @Override
    @Nonnull
    public RouteHandle assignPartition(int partitionNumber, @Nonnull MeshNode node) {
        Objects.requireNonNull(node, "node");
        if (partitionNumber < 0) {
            return NO_OP;
        }
        return this.partitionRoutes.assign(partitionNumber, node);
    }

    @Override
    @Nonnull
    public RouteHandle assignRepository(@Nonnull Repository repository, @Nonnull MeshNode node) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(node, "node");
        if (repository.isLocal()) {
            return NO_OP;
        }
        return this.repositoryRoutes.assign(repository.getId(), node);
    }

    @Override
    @Nonnull
    public MeshNode forAnyReplica(@Nonnull Repository repository) {
        int partitionNumber = Objects.requireNonNull(repository, "repository").getPartition();
        int repositoryId = repository.getId();
        return this.selectNode(partitionNumber, repositoryId, Collections.emptySet(), true);
    }

    @Override
    @Nonnull
    public MeshNode forRepositories(@Nonnull Repository repository, @Nonnull Set<Repository> related) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(related, "related");
        Set relatedRepositoryIds = (Set)related.stream().filter(relatedRepository -> !Objects.equals(relatedRepository, repository)).map(Repository::getId).collect(MoreCollectors.toImmutableSet());
        if (relatedRepositoryIds.isEmpty()) {
            return this.forRepository(repository);
        }
        this.validateSameHierarchy(repository, related);
        int partitionNumber = repository.getPartition();
        int primaryRepositoryId = repository.getId();
        return this.selectNode(partitionNumber, primaryRepositoryId, relatedRepositoryIds, false);
    }

    @Override
    @Nonnull
    public MeshNode forRepository(@Nonnull Repository repository) {
        int partitionNumber = Objects.requireNonNull(repository, "repository").getPartition();
        int repositoryId = repository.getId();
        return this.selectNode(partitionNumber, repositoryId, Collections.emptySet(), false);
    }

    @Override
    @Nonnull
    public Optional<MeshNode> forSidecar() {
        return this.sidecar.isEnabled() ? Optional.of(this.sidecar) : Optional.empty();
    }

    @Nonnull
    public TransferableState getState() {
        return new CompositeTransferableState((Iterable)ImmutableList.of((Object)this.repositoryRoutes.getState(), (Object)this.partitionRoutes.getState()));
    }

    @Override
    @Nonnull
    public Stream<MeshNode> stream() {
        Stream<MeshNode> nodes = this.partitionRegistry.getAllPartitions().stream().flatMap(partition -> partition.getReplicas().stream().map(MeshPartitionReplica::getNode)).distinct();
        if (this.sidecar.isEnabled()) {
            nodes = Stream.concat(nodes, Stream.of(this.sidecar));
        }
        return nodes;
    }

    private static String formatIds(Set<Integer> repositoryIds) {
        return repositoryIds.stream().map(id -> Integer.toString(id)).collect(Collectors.joining(","));
    }

    private boolean isCandidate(MeshNode node, int primaryRepositoryId, Set<Integer> relatedRepositoryIds) {
        boolean consistent = relatedRepositoryIds.isEmpty() ? this.partitionRegistry.isConsistent(node, primaryRepositoryId) : Stream.concat(Stream.of(Integer.valueOf(primaryRepositoryId)), relatedRepositoryIds.stream()).allMatch(repositoryId -> this.partitionRegistry.isConsistent(node, repositoryId.intValue()));
        return consistent && !this.nodeRegistry.isFailed(node);
    }

    private MeshNode selectNode(int partitionNumber, int primaryRepositoryId, Set<Integer> relatedRepositoryIds, boolean inconsistentAllowed) {
        if (partitionNumber < 0) {
            return this.sidecar;
        }
        MeshNode node = this.repositoryRoutes.get(primaryRepositoryId);
        if (node == null) {
            node = this.partitionRoutes.computeIfAbsent(partitionNumber, partNum -> this.selectTargetNode((int)partNum, primaryRepositoryId, relatedRepositoryIds, inconsistentAllowed));
        }
        if (this.clientConfig.getRoutingMode() == MeshRoutingMode.FIXED || node.isAvailable() && this.isCandidate(node, primaryRepositoryId, relatedRepositoryIds)) {
            return node;
        }
        MeshNode override = this.selectTargetNode(partitionNumber, primaryRepositoryId, relatedRepositoryIds, inconsistentAllowed);
        if (relatedRepositoryIds.isEmpty()) {
            log.warn("Overriding pinned route to {} with {} for repository {} because the old target is {}", new Object[]{node, override, primaryRepositoryId, node.isOffline() ? "offline" : "inconsistent"});
        } else {
            log.debug("Overriding pinned route to {} with {} for primary repository {} and related repositories [{}] because the old target is {}", new Object[]{node, override, primaryRepositoryId, DefaultMeshRouter.formatIds(relatedRepositoryIds), node.isOffline() ? "offline" : "inconsistent"});
        }
        return override;
    }

    private Optional<MeshPartitionReplica> selectRandomReplica(List<MeshPartitionReplica> replicas, int primaryRepositoryId, Set<Integer> relatedRepositoryIds, boolean inconsistentAllowed, boolean availabilityZoneAffinity) {
        List localOnlineConsistentReplicas;
        if (replicas.isEmpty()) {
            return Optional.empty();
        }
        List onlineConsistentReplicas = (List)replicas.stream().filter(replica -> replica.isAvailable() && this.isCandidate(replica.getNode(), primaryRepositoryId, relatedRepositoryIds)).collect(MoreCollectors.toImmutableList());
        if (onlineConsistentReplicas.isEmpty()) {
            MeshPartitionReplica result = replicas.stream().filter(replica -> this.isCandidate(replica.getNode(), primaryRepositoryId, relatedRepositoryIds)).findFirst().orElseGet(() -> {
                if (inconsistentAllowed) {
                    return replicas.stream().filter(r -> !this.nodeRegistry.isFailed(r.getNode())).findFirst().orElseThrow(() -> {
                        KeyedMessage message = relatedRepositoryIds.isEmpty() ? this.i18nService.createKeyedMessage("bitbucket.git.repository.failed", new Object[]{primaryRepositoryId}) : this.i18nService.createKeyedMessage("bitbucket.git.repositories.failed", new Object[]{primaryRepositoryId, relatedRepositoryIds});
                        return new IllegalRepositoryStateException(message);
                    });
                }
                KeyedMessage message = relatedRepositoryIds.isEmpty() ? this.i18nService.createKeyedMessage("bitbucket.git.repository.inconsistent", new Object[]{primaryRepositoryId}) : this.i18nService.createKeyedMessage("bitbucket.git.repositories.inconsistent", new Object[]{primaryRepositoryId, relatedRepositoryIds});
                throw new RepositoryInconsistentException(message);
            });
            return Optional.of(result);
        }
        if (availabilityZoneAffinity && StringUtils.isNotBlank((CharSequence)this.availabilityZone) && !(localOnlineConsistentReplicas = onlineConsistentReplicas.stream().filter(replica -> this.availabilityZone.equalsIgnoreCase(replica.getNode().getAvailabilityZone())).collect(Collectors.toList())).isEmpty()) {
            return Optional.of((MeshPartitionReplica)localOnlineConsistentReplicas.get(ThreadLocalRandom.current().nextInt(localOnlineConsistentReplicas.size())));
        }
        return Optional.of((MeshPartitionReplica)onlineConsistentReplicas.get(ThreadLocalRandom.current().nextInt(onlineConsistentReplicas.size())));
    }

    private Optional<MeshPartitionReplica> selectReplica(MeshPartition partition, int primaryRepositoryId, Set<Integer> relatedRepositoryIds, boolean inconsistentAllowed) {
        List replicas = partition.getReplicas();
        if (replicas.isEmpty()) {
            return Optional.empty();
        }
        switch (this.clientConfig.getRoutingMode()) {
            case AVAILABILITY_ZONE_AFFINITY: {
                return this.selectRandomReplica(replicas, primaryRepositoryId, relatedRepositoryIds, inconsistentAllowed, true);
            }
            case FIXED: {
                return Optional.of((MeshPartitionReplica)replicas.get(0));
            }
            case RANDOM: {
                return this.selectRandomReplica(replicas, primaryRepositoryId, relatedRepositoryIds, inconsistentAllowed, false);
            }
        }
        throw new IllegalStateException("Routing mode " + String.valueOf(this.clientConfig.getRoutingMode()) + " not supported");
    }

    private MeshNode selectTargetNode(int partitionNumber, int primaryRepositoryId, Set<Integer> relatedRepositoryIds, boolean inconsistentAllowed) {
        return ((MeshPartitionReplica)this.partitionRegistry.getPartition(partitionNumber).flatMap(partition -> this.selectReplica((MeshPartition)partition, primaryRepositoryId, relatedRepositoryIds, inconsistentAllowed)).orElseThrow(() -> new MeshPartitionNotAssignedException(this.i18nService.createKeyedMessage("bitbucket.git.partition.notassigned", new Object[]{partitionNumber}), partitionNumber))).getNode();
    }

    private void validateSameHierarchy(Repository repository, Set<Repository> related) {
        if (!related.stream().map(Repository::getHierarchyId).allMatch(hierarchyId -> Objects.equals(hierarchyId, repository.getHierarchyId()))) {
            throw new MeshRouterHierarchyMismatchException(this.i18nService.createKeyedMessage("bitbucket.git.repositories.hierarchy.mismatch", new Object[0]));
        }
    }

    private static class IdRoutes {
        private final ThreadLocal<Map<Integer, MeshNode>> assignedRoutes = new ThreadLocal();
        private final RequestLocal<Map<Integer, MeshNode>> requestRoutes;

        IdRoutes(RequestManager requestManager) {
            this.requestRoutes = requestManager.newRequestLocal();
        }

        @Nonnull
        public RouteHandle assign(int id, @Nonnull MeshNode node) {
            Map routes;
            Objects.requireNonNull(node, "node");
            if (this.requestRoutes.isActive()) {
                routes = (Map)this.requestRoutes.computeIfAbsent(ConcurrentHashMap::new);
            } else {
                routes = this.assignedRoutes.get();
                if (routes == null) {
                    HashMap<Integer, MeshNode> newRoutes = new HashMap<Integer, MeshNode>();
                    newRoutes.put(id, node);
                    this.assignedRoutes.set(newRoutes);
                    return this.assignedRoutes::remove;
                }
            }
            MeshNode existing = routes.put(id, node);
            if (existing == null) {
                return () -> routes.remove(id);
            }
            if (node.equals((Object)existing)) {
                return NO_OP;
            }
            return () -> routes.put(id, existing);
        }

        @Nonnull
        MeshNode computeIfAbsent(int id, Function<Integer, MeshNode> nodeSelector) {
            Map routes;
            if (this.requestRoutes.isActive()) {
                routes = (Map)this.requestRoutes.computeIfAbsent(ConcurrentHashMap::new);
            } else {
                routes = this.assignedRoutes.get();
                if (routes == null) {
                    this.assignedRoutes.remove();
                    return nodeSelector.apply(id);
                }
            }
            MeshNode node = (MeshNode)routes.get(id);
            if (node == null) {
                node = nodeSelector.apply(id);
                routes.put(id, node);
            }
            return node;
        }

        MeshNode get(int id) {
            if (this.requestRoutes.isActive()) {
                return this.requestRoutes.isPresent() ? (MeshNode)((Map)this.requestRoutes.get()).get(id) : null;
            }
            Map<Integer, MeshNode> routes = this.assignedRoutes.get();
            if (routes == null) {
                this.assignedRoutes.remove();
                return null;
            }
            return routes.get(id);
        }

        @Nonnull
        public TransferableState getState() {
            if (this.requestRoutes.isActive()) {
                return EmptyTransferableState.EMPTY;
            }
            final Map<Integer, MeshNode> routes = this.assignedRoutes.get();
            if (routes == null) {
                this.assignedRoutes.remove();
                return EmptyTransferableState.EMPTY;
            }
            return new TransferableState(){
                private final Map<Integer, MeshNode> state;
                {
                    this.state = new HashMap<Integer, MeshNode>(routes);
                }

                public void apply() {
                    assignedRoutes.set(this.state);
                }

                public void remove() {
                    assignedRoutes.remove();
                }
            };
        }
    }
}

