/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.dmz.mesh.MeshNodeIdleEvent;
import com.atlassian.bitbucket.event.mesh.MeshNodeAvailabilityChangedEvent;
import com.atlassian.bitbucket.hook.repository.RepositoryHookRequest;
import com.atlassian.bitbucket.hook.repository.RepositoryPushHookRequest;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.mesh.RepositoryIdUtils;
import com.atlassian.bitbucket.mesh.rpc.v1.ManagementServiceGrpc;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcHeartbeat;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcNodeKeyRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcOutOfBandRefUpdates;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcPublicKeyConfiguration;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcPublicKeyList;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcRepositoryReplicaObservation;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcRepositorySizeUpdates;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcSetConfigurationRequest;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcSidebandFollowerFragment;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcSidebandLeaderFragment;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositorySupplier;
import com.atlassian.bitbucket.scm.RepositorySize;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.concurrent.ExecutorUtils;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.stash.internal.concurrent.ConcurrencyUtils;
import com.atlassian.stash.internal.hook.repository.InternalRepositoryHookService;
import com.atlassian.stash.internal.mesh.InternalMeshPartitionRegistry;
import com.atlassian.stash.internal.mesh.MeshKeyManager;
import com.atlassian.stash.internal.mesh.MeshRepositoryReplicaObservation;
import com.atlassian.stash.internal.mesh.MeshRepositoryReplicaObservedEvent;
import com.atlassian.stash.internal.repository.InternalRefChange;
import com.atlassian.stash.internal.repository.RepositorySizeCache;
import com.atlassian.stash.internal.scm.git.command.countobjects.SimpleRepositorySize;
import com.atlassian.stash.internal.scm.git.mesh.DefaultErrorTranslator;
import com.atlassian.stash.internal.scm.git.mesh.MeshChannel;
import com.atlassian.stash.internal.scm.git.mesh.MeshConstants;
import com.atlassian.stash.internal.scm.git.mesh.MeshSidebandRegistry;
import com.atlassian.stash.internal.scm.git.mesh.RpcUtils;
import com.atlassian.stash.internal.scm.git.mesh.UnaryResponseObserver;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import io.grpc.Context;
import io.grpc.Status;
import io.grpc.stub.StreamObserver;
import jakarta.annotation.Nonnull;
import java.security.PublicKey;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMeshSidebandRegistry
implements MeshSidebandRegistry {
    private static final Logger log = LoggerFactory.getLogger(DefaultMeshSidebandRegistry.class);
    private final ConcurrentMap<Long, SidebandChannel> channelsById;
    private final EventPublisher eventPublisher;
    private final ExecutorService heartbeatExecutor;
    private final InternalRepositoryHookService hookService;
    private final I18nService i18nService;
    private final MeshKeyManager meshKeyManager;
    private final InternalMeshPartitionRegistry partitionRegistry;
    private final RepositorySizeCache repositorySizeCache;
    private final RepositorySupplier repositorySupplier;
    private final SecurityService securityService;
    private final UserService userService;
    private volatile boolean shutdown;

    public DefaultMeshSidebandRegistry(EventPublisher eventPublisher, InternalRepositoryHookService hookService, I18nService i18nService, MeshKeyManager meshKeyManager, InternalMeshPartitionRegistry partitionRegistry, RepositorySizeCache repositorySizeCache, RepositorySupplier repositorySupplier, SecurityService securityService, UserService userService) {
        this.eventPublisher = eventPublisher;
        this.hookService = hookService;
        this.i18nService = i18nService;
        this.meshKeyManager = meshKeyManager;
        this.partitionRegistry = partitionRegistry;
        this.repositorySizeCache = repositorySizeCache;
        this.repositorySupplier = repositorySupplier;
        this.securityService = securityService;
        this.userService = userService;
        this.channelsById = new ConcurrentHashMap<Long, SidebandChannel>();
        this.heartbeatExecutor = this.createHeartbeatExecutor();
    }

    @EventListener
    public void onMeshNodeAvailabilityChanged(MeshNodeAvailabilityChangedEvent event) {
        SidebandChannel channel = (SidebandChannel)this.channelsById.get(event.getNodeId());
        if (channel != null && event.isAvailable()) {
            channel.activate();
        }
    }

    @EventListener
    public void onMeshNodeIdle(MeshNodeIdleEvent event) {
        SidebandChannel channel = (SidebandChannel)this.channelsById.get(event.getNodeId());
        if (channel == null) {
            log.debug("{}: Ignoring idle node; no sideband channel is registered", (Object)event.getNode());
        } else {
            this.heartbeatExecutor.execute(channel::sendHeartbeat);
        }
    }

    @Override
    public void register(@Nonnull MeshChannel channel) {
        Objects.requireNonNull(channel, "channel");
        if (this.shutdown) {
            return;
        }
        SidebandChannel replaced = this.channelsById.put(channel.getNodeId(), new SidebandChannel(channel));
        if (replaced != null) {
            log.info("{}: Replaced existing sideband channel", (Object)channel);
            replaced.close();
        }
    }

    @Override
    public void sendHeartbeat(@Nonnull MeshChannel channel) {
        Objects.requireNonNull(channel, "channel");
        if (this.shutdown) {
            return;
        }
        SidebandChannel sidebandChannel = (SidebandChannel)this.channelsById.get(channel.getNodeId());
        if (sidebandChannel == null) {
            log.warn("{}: Not sending heartbeat; no sideband channel is registered", (Object)channel);
        } else {
            sidebandChannel.sendHeartbeat();
        }
    }

    public void shutdown() {
        this.shutdown = true;
        this.channelsById.values().forEach(SidebandChannel::close);
        this.channelsById.clear();
        ExecutorUtils.shutdown((ExecutorService)this.heartbeatExecutor, (Logger)log);
    }

    @Override
    public void unregister(@Nonnull MeshChannel channel) {
        SidebandChannel sidebandChannel = (SidebandChannel)this.channelsById.remove(Objects.requireNonNull(channel, "channel").getNodeId());
        if (sidebandChannel != null) {
            sidebandChannel.close();
        }
    }

    @VisibleForTesting
    ExecutorService createHeartbeatExecutor() {
        return Executors.newSingleThreadExecutor(ConcurrencyUtils.createDaemonThreadFactory((String)"mesh-heartbeat-timer", (ThreadGroup)MeshConstants.THREAD_GROUP_RPC));
    }

    private class SidebandChannel
    implements StreamObserver<RpcSidebandFollowerFragment> {
        private final MeshChannel channel;
        private final AtomicBoolean closed;
        private final Object lock;
        private final ManagementServiceGrpc.ManagementServiceStub stub;
        private volatile StreamObserver<RpcSidebandLeaderFragment> requestObserver;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        SidebandChannel(MeshChannel channel) {
            this.channel = channel;
            log.info("{}: Opening sideband channel", (Object)channel);
            this.closed = new AtomicBoolean(false);
            this.lock = new Object();
            Context previous = Context.current().fork();
            try {
                this.stub = channel.newStub(ManagementServiceGrpc::newStub);
                this.requestObserver = this.stub.sideband((StreamObserver)this);
            }
            finally {
                previous.attach();
            }
        }

        public void onCompleted() {
            log.info("{}: Sideband channel closed", (Object)this.channel);
            this.requestObserver = null;
            if (!DefaultMeshSidebandRegistry.this.shutdown && !this.closed.get()) {
                this.reopen();
            }
        }

        public void onError(Throwable t) {
            this.requestObserver = null;
            Status status = Status.fromThrowable((Throwable)t);
            if (status.getCode() == Status.Code.UNAVAILABLE) {
                log.info("{}: Sideband channel closed because node is unavailable", (Object)this.channel, (Object)t);
            } else if (status.getCode() == Status.Code.CANCELLED) {
                log.info("{}: Sideband channel closed", (Object)this.channel, (Object)(log.isDebugEnabled() ? t : null));
            } else {
                log.warn("{}: Sideband channel died", (Object)this.channel, (Object)t);
            }
            this.channel.refreshState();
        }

        public void onNext(RpcSidebandFollowerFragment fragment) {
            try {
                switch (fragment.getSidebandOneofCase()) {
                    case HEARTBEAT: {
                        this.onHeartbeat();
                        break;
                    }
                    case REPOSITORY_REPLICA_OBSERVATION: {
                        this.onRepositoryReplicaObserved(fragment.getRepositoryReplicaObservation());
                        break;
                    }
                    case NODE_KEY_REQUEST: {
                        this.onNodeKeyRequest(fragment.getNodeKeyRequest());
                        break;
                    }
                    case OUT_OF_BAND_REF_UPDATES: {
                        this.onOutOfBandRefUpdates(fragment.getOutOfBandRefUpdates());
                        break;
                    }
                    case REPOSITORY_SIZE_UPDATES: {
                        this.onRepositorySizeUpdates(fragment.getRepositorySizeUpdates());
                    }
                }
            }
            catch (RuntimeException e) {
                log.warn("Error while processing sideband message {}: {}", (Object)fragment.getSidebandOneofCase(), (Object)e.getMessage());
                throw e;
            }
        }

        public String toString() {
            return this.channel.toString();
        }

        void activate() {
            if (DefaultMeshSidebandRegistry.this.shutdown) {
                log.debug("{}: Not reopening sideband; the system has been shutdown", (Object)this.channel);
                return;
            }
            if (this.requestObserver == null) {
                this.reopen();
            }
        }

        void close() {
            StreamObserver<RpcSidebandLeaderFragment> requestObserver;
            if (this.closed.compareAndSet(false, true) && (requestObserver = this.requestObserver) != null) {
                this.sendCompleted(requestObserver);
            }
        }

        private boolean isClosed(RuntimeException e) {
            if (e instanceof IllegalStateException) {
                String message = e.getMessage();
                return "call already closed".equals(message) || "call is closed".equals(message);
            }
            return false;
        }

        private void onHeartbeat() {
            log.debug("{}: Received follower heartbeat", (Object)this.channel);
            this.channel.touch();
        }

        private void onNodeKeyRequest(RpcNodeKeyRequest request) {
            String nodeId = request.getNodeId();
            String fingerprint = request.getFingerprint();
            log.debug("{}: Received node key request [node ID: {}, fingerprint: {}]", new Object[]{this.channel, nodeId, fingerprint});
            PublicKey publicKey = DefaultMeshSidebandRegistry.this.meshKeyManager.getKeyByNodeIdAndFingerprint(Long.parseLong(nodeId), fingerprint);
            if (publicKey == null) {
                return;
            }
            UnaryResponseObserver observer = new UnaryResponseObserver(new DefaultErrorTranslator(DefaultMeshSidebandRegistry.this.i18nService, null));
            this.stub.setConfiguration(RpcSetConfigurationRequest.newBuilder().setPublicKeyConfiguration(RpcPublicKeyConfiguration.newBuilder().putNodePublicKeys(nodeId, RpcPublicKeyList.newBuilder().addPublicKeys(RpcUtils.toPublicKey(publicKey)).build()).build()).build(), observer);
            observer.asResult();
        }

        private void onOutOfBandRefUpdates(RpcOutOfBandRefUpdates outOfBandRefUpdates) {
            ApplicationUser user = DefaultMeshSidebandRegistry.this.userService.getUserByName(outOfBandRefUpdates.getUser());
            List refChanges = (List)outOfBandRefUpdates.getRefUpdatesList().stream().map(RpcUtils::toRefChange).collect(MoreCollectors.toImmutableList());
            if (user == null) {
                log.warn("{} [{}]: Couldn't find user by id '{}' when trying to replay out-of-band ref updates. These ref updates will be missed:{}", new Object[]{this.channel, outOfBandRefUpdates.getCorrelationId(), outOfBandRefUpdates.getUser(), InternalRefChange.formatRefChanges((Iterable)refChanges)});
                return;
            }
            DefaultMeshSidebandRegistry.this.securityService.impersonating(user, "Replaying out-of-band ref updates").call(() -> {
                Repository repository = DefaultMeshSidebandRegistry.this.repositorySupplier.getById(RepositoryIdUtils.getLocalRepositoryId((String)outOfBandRefUpdates.getRepository()));
                if (repository == null) {
                    if (log.isDebugEnabled()) {
                        log.debug("{} [{}]: Received out-of-band ref updates for unknown repository: {}. These ref updates will be missed:{}", new Object[]{this.channel, outOfBandRefUpdates.getCorrelationId(), outOfBandRefUpdates.getRepository(), InternalRefChange.formatRefChanges((Iterable)refChanges)});
                    }
                    return null;
                }
                RepositoryPushHookRequest.Builder pushHookRequestBuilder = new RepositoryPushHookRequest.Builder(repository);
                refChanges.forEach(x$0 -> {
                    RepositoryPushHookRequest.Builder cfr_ignored_0 = (RepositoryPushHookRequest.Builder)pushHookRequestBuilder.refChanges(x$0, new RefChange[0]);
                });
                if (log.isDebugEnabled()) {
                    log.debug("{} [{}]: Processing out-of-band ref updates:{}", new Object[]{outOfBandRefUpdates.getCorrelationId(), this.channel, InternalRefChange.formatRefChanges((Iterable)refChanges)});
                }
                DefaultMeshSidebandRegistry.this.hookService.postUpdate((RepositoryHookRequest)pushHookRequestBuilder.build());
                return null;
            });
        }

        private void onRepositoryReplicaObserved(RpcRepositoryReplicaObservation o) {
            MeshRepositoryReplicaObservation.Builder builder = new MeshRepositoryReplicaObservation.Builder(o.getRepository()).state(RpcUtils.toReplicaState(o.getState())).version(o.getVersion());
            if (o.getNodesCount() == 0) {
                builder.nodeId(this.channel.getNodeId());
            } else {
                builder.nodeIds((Iterable)Lists.transform((List)o.getNodesList(), Long::parseLong));
            }
            MeshRepositoryReplicaObservation observation = builder.build();
            log.debug("{}: Received replica observation {}@{} for {}", new Object[]{this.channel, observation.getState(), observation.getVersion(), observation.getNodeIds()});
            DefaultMeshSidebandRegistry.this.partitionRegistry.reportObservation(observation);
            DefaultMeshSidebandRegistry.this.eventPublisher.publish((Object)new MeshRepositoryReplicaObservedEvent((Object)this, observation));
        }

        private void onRepositorySizeUpdates(RpcRepositorySizeUpdates repositorySizeUpdates) {
            repositorySizeUpdates.getRepositorySizesMap().forEach((repositoryId, size) -> {
                Repository repository = (Repository)DefaultMeshSidebandRegistry.this.securityService.withPermission(Permission.REPO_READ, "Fetching repository to update size on sideband message").call(() -> DefaultMeshSidebandRegistry.this.repositorySupplier.getById(RepositoryIdUtils.getLocalRepositoryId((String)repositoryId)));
                if (repository != null) {
                    DefaultMeshSidebandRegistry.this.repositorySizeCache.updateSize(repository, (RepositorySize)new SimpleRepositorySize.Builder().garbageSize(size.getGarbageSize()).inPackSize(size.getInPackSize()).looseSize(size.getLooseSize()).build());
                }
            });
        }

        private StreamObserver<RpcSidebandLeaderFragment> reopen() {
            if (this.closed.get()) {
                log.info("{}: Not reopening closed channel.", (Object)this.channel);
                return null;
            }
            try {
                log.info("{}: Reopening sideband channel", (Object)this.channel);
                this.requestObserver = this.stub.sideband((StreamObserver)this);
                return this.requestObserver;
            }
            catch (RuntimeException e) {
                log.warn("{}: Reopening sideband channel failed", (Object)this.channel, (Object)e);
                this.channel.refreshState();
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendCompleted(StreamObserver<RpcSidebandLeaderFragment> requestObserver) {
            Object object = this.lock;
            synchronized (object) {
                block5: {
                    this.requestObserver = null;
                    try {
                        requestObserver.onCompleted();
                    }
                    catch (RuntimeException e) {
                        if (this.isClosed(e)) break block5;
                        log.debug("{}: Ignoring exception while closing sideband channel", (Object)this.channel, (Object)e);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendFragment(StreamObserver<RpcSidebandLeaderFragment> requestObserver, RpcSidebandLeaderFragment fragment) {
            Object object = this.lock;
            synchronized (object) {
                try {
                    requestObserver.onNext((Object)fragment);
                }
                catch (RuntimeException e) {
                    log.warn("{}: Closing sideband channel after failure to send {} fragment", new Object[]{this.channel, fragment.getSidebandOneofCase(), e});
                    this.sendCompleted(requestObserver);
                    this.reopen();
                }
            }
        }

        private void sendHeartbeat() {
            if (DefaultMeshSidebandRegistry.this.shutdown) {
                log.debug("{}: Skipping heartbeat; the system has been shutdown", (Object)this.channel);
                return;
            }
            StreamObserver<RpcSidebandLeaderFragment> requestObserver = this.requestObserver;
            if (requestObserver == null && (requestObserver = this.reopen()) == null) {
                return;
            }
            this.sendFragment(requestObserver, RpcSidebandLeaderFragment.newBuilder().setHeartbeat(RpcHeartbeat.getDefaultInstance()).build());
        }
    }
}

