/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.dmz.mesh.DmzMeshService;
import com.atlassian.bitbucket.dmz.mesh.DmzMeshTroubleshootingService;
import com.atlassian.bitbucket.dmz.mesh.MeshRpcNotSupportedException;
import com.atlassian.bitbucket.dmz.mesh.MeshVerifyConsistencyCallback;
import com.atlassian.bitbucket.dmz.mesh.ReplicaState;
import com.atlassian.bitbucket.dmz.mesh.RepositoryReplicaDetails;
import com.atlassian.bitbucket.dmz.repository.DmzRepository;
import com.atlassian.bitbucket.dmz.repository.RemoteRepositoryId;
import com.atlassian.bitbucket.dmz.repository.RepositoryCallback;
import com.atlassian.bitbucket.internal.mesh.RpcManagementClient;
import com.atlassian.bitbucket.mesh.MeshNode;
import com.atlassian.bitbucket.mesh.rpc.v1.RepositoryServiceGrpc;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcSetReplicaStateRequest;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryOfflineException;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.internal.integrity.RepositoryIntegrityHelper;
import com.atlassian.stash.internal.mesh.InternalMeshPartitionRegistry;
import com.atlassian.stash.internal.mesh.MeshController;
import com.atlassian.stash.internal.mesh.MeshRepositoryReplicaObservation;
import com.atlassian.stash.internal.repository.RepositoryDao;
import com.atlassian.stash.internal.scm.git.mesh.RpcRepositoryClient;
import com.atlassian.stash.internal.scm.git.mesh.RpcUtils;
import com.google.common.base.Throwables;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.commons.lang3.mutable.MutableInt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;

@AvailableToPlugins(value=DmzMeshTroubleshootingService.class)
@PreAuthorize(value="hasGlobalPermission('SYS_ADMIN')")
@Transactional(readOnly=true)
public class DefaultMeshTroubleshootingService
implements DmzMeshTroubleshootingService {
    private static final Logger log = LoggerFactory.getLogger(DefaultMeshTroubleshootingService.class);
    private final RpcManagementClient managementClient;
    private final MeshController meshController;
    private final DmzMeshService meshService;
    private final InternalMeshPartitionRegistry partitionRegistry;
    private final RpcRepositoryClient repositoryClient;
    private final RepositoryDao repositoryDao;
    private final RepositoryIntegrityHelper repositoryIntegrityHelper;

    public DefaultMeshTroubleshootingService(RpcManagementClient managementClient, MeshController meshController, DmzMeshService meshService, InternalMeshPartitionRegistry partitionRegistry, RpcRepositoryClient repositoryClient, RepositoryDao repositoryDao, RepositoryIntegrityHelper repositoryIntegrityHelper) {
        this.managementClient = managementClient;
        this.meshController = meshController;
        this.meshService = meshService;
        this.partitionRegistry = partitionRegistry;
        this.repositoryClient = repositoryClient;
        this.repositoryDao = repositoryDao;
        this.repositoryIntegrityHelper = repositoryIntegrityHelper;
    }

    public void forceTopologyUpdate() {
        try {
            this.meshController.forceTopologyUpdate().get();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted while propagating topology to Mesh nodes");
        }
        catch (ExecutionException executionException) {
            Throwable cause = executionException.getCause();
            Throwables.throwIfUnchecked((Throwable)cause);
            throw new RuntimeException("Propagating topology to Mesh nodes failed", cause);
        }
    }

    @Nonnull
    public Map<MeshNode, RepositoryReplicaDetails> getReplicasDetailsFromControlPlane(@Nonnull Repository repository) {
        HashMap<MeshNode, RepositoryReplicaDetails> result = new HashMap<MeshNode, RepositoryReplicaDetails>();
        for (MeshNode node : this.meshService.getMembersByPartition(repository.getPartition())) {
            result.put(node, this.partitionRegistry.getReplicaDetails(node, repository));
        }
        return result;
    }

    @Nonnull
    public Map<MeshNode, RepositoryReplicaDetails> getReplicasDetailsFromNodes(@Nonnull Repository repository) {
        HashMap<MeshNode, RepositoryReplicaDetails> result = new HashMap<MeshNode, RepositoryReplicaDetails>();
        for (MeshNode node : this.meshService.getMembersByPartition(repository.getPartition())) {
            try {
                result.put(node, this.repositoryClient.getReplicaDetails(node, repository));
            }
            catch (RepositoryOfflineException e) {
                result.put(node, null);
            }
        }
        return result;
    }

    public void repair(@Nonnull Repository repository) {
        try {
            if (repository.isLocal()) {
                log.debug("[{}] Non-Mesh repositories do not need to be repaired", (Object)repository);
                return;
            }
            ((CompletableFuture)this.repositoryClient.verifyConsistency(repository).thenApply(summary -> {
                this.partitionRegistry.reportRepositoryConsistencySummary(summary);
                return summary;
            })).get();
        }
        catch (MeshRpcNotSupportedException e) {
            log.info("Mesh does not support {}; falling back to legacy repair method.", (Object)RepositoryServiceGrpc.getVerifyConsistencyMethod().getFullMethodName());
            this.legacyRepair(repository);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted while waiting for consistency check to finish");
        }
        catch (ExecutionException executionException) {
            Throwable cause = executionException.getCause();
            Throwables.throwIfUnchecked((Throwable)cause);
            throw new RuntimeException("Repair of " + String.valueOf(repository) + " failed", cause);
        }
    }

    public void verifyConsistency(MeshVerifyConsistencyCallback callback) {
        HashMap<Repository, List> result = new HashMap<Repository, List>();
        this.repositoryIntegrityHelper.checkRepositoriesExistAndAreConsistent((repository, message) -> result.computeIfAbsent((Repository)repository, ignored -> new ArrayList()).add(message));
        result.forEach((arg_0, arg_1) -> ((MeshVerifyConsistencyCallback)callback).onInconsistencyFound(arg_0, arg_1));
    }

    private void legacyRepair(@Nonnull Repository repository) {
        Map<MeshNode, RepositoryReplicaDetails> controlPlaneDetails = this.getReplicasDetailsFromControlPlane(repository);
        Map<MeshNode, RepositoryReplicaDetails> nodeDetails = this.getReplicasDetailsFromNodes(repository);
        this.syncControlPlaneAndNodeState(repository, controlPlaneDetails, nodeDetails);
        List consistentNodes = controlPlaneDetails.entrySet().stream().filter(entry -> ((RepositoryReplicaDetails)entry.getValue()).getReplicaState().isConsistent()).map(Map.Entry::getKey).collect(Collectors.toList());
        if (consistentNodes.isEmpty()) {
            this.recoverFromAllReplicasAreInconsistent(repository, nodeDetails);
        } else if (consistentNodes.size() == controlPlaneDetails.size()) {
            log.info("[{}] All replicas are consistent. Nothing to repair", (Object)repository);
        } else {
            MeshNode repairSource = consistentNodes.stream().filter(MeshNode::isAvailable).findFirst().orElseThrow(() -> DefaultMeshTroubleshootingService.newRepairFailedException("[%s] Cannot repair inconsistent replicas because no consistent replica is online (candidates = %s)", repository, consistentNodes));
            controlPlaneDetails.forEach((node, details) -> {
                if (!details.getReplicaState().isConsistent()) {
                    RepositoryReplicaDetails meshDetails = (RepositoryReplicaDetails)nodeDetails.get(node);
                    if (meshDetails == null) {
                        log.info("[{}] Not repairing {} replica on {} because the node is offline", new Object[]{repository, details.getReplicaState(), node});
                    } else {
                        this.internalRepairReplica(repository, repairSource, (MeshNode)node);
                    }
                }
            });
        }
    }

    public boolean repairReplica(@Nonnull Repository repository, long sourceNodeId, long targetNodeId) {
        MeshNode sourceNode = this.meshService.getMember(sourceNodeId);
        MeshNode targetNode = this.meshService.getMember(targetNodeId);
        return this.internalRepairReplica(repository, sourceNode, targetNode);
    }

    public void setReplicaState(long nodeId, @Nonnull Repository repository, @Nonnull ReplicaState replicaState, long version, boolean force) {
        if (repository.isLocal()) {
            log.warn("[{}] Cannot set replica state for local repository", (Object)repository);
            return;
        }
        MeshNode node = this.meshService.getMember(nodeId);
        String repositoryId = RemoteRepositoryId.format((DmzRepository)((DmzRepository)repository));
        this.partitionRegistry.reportObservation(new MeshRepositoryReplicaObservation.Builder(repositoryId).force(force).nodeId(nodeId).state(replicaState).version(version).build());
        this.managementClient.setReplicaState(node, repository, RpcSetReplicaStateRequest.newBuilder().setForce(force).setReplicaState(RpcUtils.toReplicaState(replicaState)).setVersion(version));
    }

    public void streamRemoteRepositories(RepositoryCallback callback) {
        this.repositoryDao.streamByRemote(true, callback);
    }

    @SafeVarargs
    private static long getMaxVersion(Collection<RepositoryReplicaDetails> ... collections) {
        long result = 0L;
        for (Collection<RepositoryReplicaDetails> collection : collections) {
            for (RepositoryReplicaDetails detail : collection) {
                result = Math.max(result, Math.max(detail.getVersion(), detail.getObservedVersion()));
            }
        }
        return result;
    }

    @Nonnull
    private static MeshNode getNodeToRepairAllReplicasFrom(Repository repository, Map<MeshNode, RepositoryReplicaDetails> nodeDetails) {
        long highestVersion = nodeDetails.entrySet().stream().peek(entry -> {
            if (entry.getValue() == null) {
                throw DefaultMeshTroubleshootingService.newRepairFailedException("[%s] All replicas are inconsistent. Cannot determine which node to repair from because %s is offline; optionally manually mark one of the online nodes as consistent and retry.", repository, entry.getKey());
            }
        }).mapToLong(entry -> ((RepositoryReplicaDetails)entry.getValue()).getVersion()).max().orElse(0L);
        if (highestVersion < 2L) {
            throw DefaultMeshTroubleshootingService.newRepairFailedException("[%s] All replicas are inconsistent, but none of the nodes have a copy of the repository", repository);
        }
        MutableInt candidateNodeCount = new MutableInt();
        HashMap candidatesByContentHash = new HashMap();
        nodeDetails.forEach((node, details) -> {
            if (details.getVersion() == highestVersion && details.getContentHash() != null) {
                candidateNodeCount.increment();
                candidatesByContentHash.computeIfAbsent(details.getContentHash(), ignored -> new ArrayList()).add(node);
            }
        });
        if (candidatesByContentHash.size() == 1) {
            return (MeshNode)((List)candidatesByContentHash.values().iterator().next()).get(0);
        }
        Map.Entry bestEntry = candidatesByContentHash.entrySet().stream().max(Comparator.comparingInt(entry -> ((List)entry.getValue()).size())).orElseThrow(() -> new IllegalStateException("No candidates found to repair from"));
        if (((List)bestEntry.getValue()).size() > candidateNodeCount.intValue() / 2) {
            return (MeshNode)((List)bestEntry.getValue()).get(0);
        }
        throw DefaultMeshTroubleshootingService.newRepairFailedException("[%s] All replicas are inconsistent. Cannot determine which node to select as the consistent replica; manually mark one of the nodes as consistent and retry", repository);
    }

    private static RuntimeException newRepairFailedException(String messageTemplate, Object ... values) {
        String message = String.format(messageTemplate, values);
        log.warn(message);
        throw new IllegalStateException(message);
    }

    private boolean internalRepairReplica(Repository repository, MeshNode sourceNode, MeshNode targetNode) {
        try {
            log.info("[{}] Repairing replica on {} from {}", new Object[]{repository, targetNode, sourceNode});
            return (Boolean)this.managementClient.repairRepository(sourceNode, targetNode, repository).get();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted while waiting for repair of " + String.valueOf(repository) + " to complete");
        }
        catch (ExecutionException executionException) {
            Throwable cause = executionException.getCause();
            Throwables.throwIfUnchecked((Throwable)cause);
            throw new RuntimeException("Repair of " + String.valueOf(repository) + " failed", cause);
        }
    }

    private void recoverFromAllReplicasAreInconsistent(Repository repository, Map<MeshNode, RepositoryReplicaDetails> nodeDetails) {
        MeshNode blessedNode = DefaultMeshTroubleshootingService.getNodeToRepairAllReplicasFrom(repository, nodeDetails);
        RepositoryReplicaDetails blessedDetails = nodeDetails.get(blessedNode);
        log.info("[{}] All replicas are inconsistent. Repairing from {} (content-hash = {}, version = {})", new Object[]{repository, blessedNode, blessedDetails.getContentHash(), blessedDetails.getVersion()});
        ArrayList replicasToRepair = new ArrayList();
        nodeDetails.forEach((node, details) -> {
            if (blessedDetails.getVersion() == details.getVersion() && Objects.equals(blessedDetails.getContentHash(), details.getContentHash())) {
                log.info("[{}] Marking replica on {} as CONSISTENT", (Object)repository, node);
                this.setReplicaState(node.getId(), repository, ReplicaState.CONSISTENT, details.getVersion(), true);
            } else {
                replicasToRepair.add(node);
            }
        });
        replicasToRepair.forEach(node -> this.internalRepairReplica(repository, blessedNode, (MeshNode)node));
    }

    private void syncControlPlaneAndNodeState(Repository repository, Map<MeshNode, RepositoryReplicaDetails> controlPlaneDetails, Map<MeshNode, RepositoryReplicaDetails> nodeDetails) {
        String repositoryId = RemoteRepositoryId.format((DmzRepository)((DmzRepository)repository));
        for (Map.Entry<MeshNode, RepositoryReplicaDetails> entry : controlPlaneDetails.entrySet()) {
            ReplicaState meshState;
            MeshNode node = entry.getKey();
            RepositoryReplicaDetails cpDetails = entry.getValue();
            RepositoryReplicaDetails meshDetails = nodeDetails.get(node);
            ReplicaState state = cpDetails.getReplicaState();
            if (meshDetails == null || (meshState = meshDetails.getReplicaState()).isConsistent() == state.isConsistent()) continue;
            long meshObservedVersion = meshDetails.getObservedVersion();
            if (meshObservedVersion == 0L) {
                if (meshState == ReplicaState.MISSING) {
                    meshObservedVersion = DefaultMeshTroubleshootingService.getMaxVersion(controlPlaneDetails.values(), nodeDetails.values());
                } else if (meshState == ReplicaState.CONSISTENT) {
                    meshObservedVersion = meshDetails.getVersion();
                }
            }
            if (cpDetails.getObservedVersion() <= meshObservedVersion) {
                log.info("[{}] Publishing {} replica state {}@{} to control plane", new Object[]{repository, node, meshState, meshObservedVersion});
                this.partitionRegistry.reportObservation(new MeshRepositoryReplicaObservation.Builder(repositoryId).nodeId(node.getId()).state(meshState).version(meshObservedVersion).build());
                cpDetails = this.partitionRegistry.getReplicaDetails(node, repository);
                state = cpDetails.getReplicaState();
                controlPlaneDetails.put(node, cpDetails);
            }
            if (meshObservedVersion <= cpDetails.getObservedVersion()) {
                log.info("[{}] Publishing control plane state {}@{} to replica {}", new Object[]{repository, state, cpDetails.getObservedVersion(), node});
                this.managementClient.setReplicaState(node, repository, RpcSetReplicaStateRequest.newBuilder().setReplicaState(RpcUtils.toReplicaState(state)).setVersion(cpDetails.getObservedVersion()));
            }
            nodeDetails.put(node, this.repositoryClient.getReplicaDetails(node, repository));
        }
    }
}

