/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.Product;
import com.atlassian.bitbucket.ServiceException;
import com.atlassian.bitbucket.dmz.mesh.DmzMeshNodeRegistry;
import com.atlassian.bitbucket.dmz.mesh.DmzMeshService;
import com.atlassian.bitbucket.dmz.server.DataStore;
import com.atlassian.bitbucket.internal.mesh.RpcManagementClient;
import com.atlassian.bitbucket.mesh.MeshNode;
import com.atlassian.stash.internal.HomeLayout;
import com.atlassian.stash.internal.mesh.SidecarUnavailableException;
import com.atlassian.stash.internal.scm.git.mesh.MeshLauncher;
import com.atlassian.stash.internal.scm.git.mesh.SidecarHealthcheckStatistics;
import com.atlassian.stash.internal.scm.git.mesh.SidecarManager;
import com.atlassian.stash.internal.scm.git.mesh.SidecarNode;
import com.atlassian.stash.internal.server.DataStoreListener;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.MoreExecutors;
import io.atlassian.util.concurrent.ThreadFactories;
import io.grpc.StatusRuntimeException;
import jakarta.annotation.Nonnull;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Date;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.io.input.ReversedLinesFileReader;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.logging.LogLevel;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component(value="sidecarManager")
public class DefaultSidecarManager
implements SidecarManager,
ApplicationListener<ContextRefreshedEvent>,
DataStoreListener {
    private static final SimpleDateFormat DATE_FORMAT_A = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss.SSS");
    private static final SimpleDateFormat DATE_FORMAT_B = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss,SSS");
    private static final int EXECUTOR_POOL_SIZE = 2;
    private static final int LOG_TAIL_SIZE = 20;
    private static final byte[] PING = "ping\n".getBytes(StandardCharsets.UTF_8);
    private static final Logger log = LoggerFactory.getLogger(DefaultSidecarManager.class);
    private final boolean childProcess;
    private final Clock clock;
    private final int configFailureThreshold;
    private final int configPingInterval;
    private final int configRestartDelay;
    private final int configShutdownTimeout;
    private final int configStartupTimeout;
    private final boolean enabled;
    private final Environment environment;
    private final Supplier<ScheduledExecutorService> executorServiceFactory;
    private final SidecarHealthcheckStatistics healthcheckStatistics;
    private final HomeLayout homeLayout;
    private final MeshLauncher launcher;
    private final SidecarNode node;
    private final AtomicBoolean started;
    private boolean initialized;
    private RpcManagementClient managementClient;
    private Process mesh;
    private ScheduledExecutorService monitoringExecutorService;
    private int restartCount;
    private SidecarMonitor sidecarMonitor;

    @Autowired
    public DefaultSidecarManager(Clock clock, Environment environment, HomeLayout homeLayout, MeshLauncher launcher, DmzMeshService meshService, DmzMeshNodeRegistry nodeRegistry) {
        this(clock, environment, homeLayout, launcher, meshService, nodeRegistry, () -> Executors.newScheduledThreadPool(2, ThreadFactories.namedThreadFactory((String)"mesh-sidecar-monitor")));
    }

    @VisibleForTesting
    DefaultSidecarManager(Clock clock, Environment environment, HomeLayout homeLayout, MeshLauncher launcher, DmzMeshService meshService, DmzMeshNodeRegistry nodeRegistry, Supplier<ScheduledExecutorService> executorServiceFactory) {
        this.clock = clock;
        this.environment = environment;
        this.executorServiceFactory = executorServiceFactory;
        this.homeLayout = homeLayout;
        this.launcher = launcher;
        this.childProcess = (Boolean)environment.getProperty("plugin.bitbucket-git.mesh.sidecar.child-process", Boolean.class, (Object)true);
        this.enabled = (Boolean)environment.getProperty("plugin.bitbucket-git.mesh.sidecar.enabled", Boolean.class, (Object)true);
        this.configFailureThreshold = (Integer)environment.getProperty("plugin.bitbucket-git.mesh.sidecar.monitoring.failure.threshold", Integer.class, (Object)5);
        this.configPingInterval = (Integer)environment.getProperty("plugin.bitbucket-git.mesh.sidecar.monitoring.ping.interval", Integer.class, (Object)10);
        this.configRestartDelay = (Integer)environment.getProperty("plugin.bitbucket-git.mesh.sidecar.monitoring.restart.delay", Integer.class, (Object)5);
        this.configShutdownTimeout = (Integer)environment.getProperty("plugin.bitbucket-git.mesh.sidecar.monitoring.shutdown.timeout", Integer.class, (Object)60);
        this.configStartupTimeout = (Integer)environment.getProperty("plugin.bitbucket-git.mesh.sidecar.monitoring.startup.timeout", Integer.class, (Object)180);
        this.node = new SidecarNode(this.enabled, this.getPort(), nodeRegistry, this.isSslEnabled());
        this.started = new AtomicBoolean(false);
        if (this.enabled) {
            meshService.registerSidecar((MeshNode)this.node);
        }
        this.healthcheckStatistics = new DefaultSidecarHealthcheckStatistics();
    }

    @Override
    @Nonnull
    public SidecarHealthcheckStatistics getHealthcheckStatistics() {
        return this.healthcheckStatistics;
    }

    @Override
    @Nonnull
    public SidecarNode getSidecar() {
        return this.node;
    }

    @Override
    public boolean isAlive() {
        return this.isStarted() && this.mesh.isAlive();
    }

    @Override
    public boolean isReady() {
        return this.sidecarMonitor != null && this.sidecarMonitor.awaitStartup().getNow(false) != false;
    }

    @Override
    public boolean isStarted() {
        return this.mesh != null;
    }

    public void onApplicationEvent(@Nonnull ContextRefreshedEvent event) {
        ApplicationContext applicationContext = event.getApplicationContext();
        this.managementClient = (RpcManagementClient)applicationContext.getBean(RpcManagementClient.class);
        this.initialized = true;
    }

    public void onAttached(@Nonnull DataStore dataStore) {
        if (this.initialized) {
            if (this.managementClient.addDataStore(dataStore)) {
                log.debug("The sidecar successfully attached ds/{} ({})", (Object)dataStore.getId(), (Object)dataStore.getPath());
            } else {
                log.warn("The sidecar failed to register ds/{} ({})", (Object)dataStore.getId(), (Object)dataStore.getPath());
            }
        } else {
            log.warn("The sidecar was not notified about ds/{} ({}); it is not running", (Object)dataStore.getId(), (Object)dataStore.getPath());
        }
    }

    @PostConstruct
    public void start() throws IOException {
        if (this.enabled) {
            if (this.childProcess) {
                this.monitoringExecutorService = this.executorServiceFactory.get();
                this.startSidecarMonitor();
                this.internalStart();
                this.restartCount = 0;
            } else {
                log.debug("Sidecar is an independent process. Not starting it..");
            }
        } else {
            log.debug("Sidecar has been disabled");
        }
    }

    @PreDestroy
    public void stop() {
        if (this.mesh != null) {
            this.sidecarMonitor.close();
            this.internalStop();
            MoreExecutors.shutdownAndAwaitTermination((ExecutorService)this.monitoringExecutorService, (long)30L, (TimeUnit)TimeUnit.SECONDS);
        }
    }

    private static <E extends Exception> Runnable wrapForErrorHandling(ThrowingRunnable<E> runnable) {
        return () -> {
            try {
                runnable.run();
            }
            catch (Exception | StackOverflowError e) {
                log.error("Unhandled exception caught", e);
            }
        };
    }

    private int getPort() {
        if (this.enabled && this.childProcess) {
            return this.launcher.getSidecarPort();
        }
        return (Integer)this.environment.getProperty("plugin.bitbucket-git.mesh.sidecar.default-port", Integer.class, (Object)7777);
    }

    private void internalStart() throws IOException {
        if (this.started.compareAndSet(false, true)) {
            log.debug("Preparing and starting sidecar");
            this.startSidecar();
        } else {
            log.debug("Sidecar already started. Not starting it again.");
        }
    }

    private void internalStop() {
        if (this.started.compareAndSet(true, false)) {
            this.sidecarMonitor.stop();
            if (this.mesh == null) {
                log.debug("Sidecar was never started");
                return;
            }
            try {
                try {
                    this.mesh.getOutputStream().close();
                }
                catch (IOException e) {
                    log.trace("Failed to close Sidecar output stream", (Throwable)e);
                }
                if (this.mesh.waitFor(this.configShutdownTimeout, TimeUnit.SECONDS)) {
                    log.info("Sidecar has stopped (Exit code: {})", (Object)this.mesh.exitValue());
                } else {
                    log.warn("Sidecar did not stop within the allotted delay; terminating");
                    this.mesh.destroy();
                    if (this.mesh.waitFor(this.configShutdownTimeout / 2, TimeUnit.SECONDS)) {
                        log.info("Sidecar has stopped after termination (Exit code: {})", (Object)this.mesh.exitValue());
                    } else {
                        log.warn("Sidecar still did not stop within the allotted delay; terminating forcibly");
                        Process proc = this.mesh.destroyForcibly();
                        if (this.mesh.waitFor(5L, TimeUnit.SECONDS)) {
                            log.info("Sidecar has stopped after forced termination (Exit code: {})", (Object)proc.exitValue());
                        } else {
                            log.warn("Sidecar did not stop within the allotted delay; giving up");
                        }
                    }
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.debug("Interrupted while waiting for sidecar to stop", (Throwable)(log.isTraceEnabled() ? e : null));
            }
            catch (Exception e) {
                log.warn("Failed trying to stop sidecar", (Throwable)e);
            }
        }
    }

    private boolean isSslEnabled() {
        return (Boolean)this.environment.getProperty("plugin.bitbucket-git.mesh.sidecar.ssl", Boolean.class, (Object)Boolean.FALSE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startSidecar() throws IOException {
        block11: {
            long start = System.currentTimeMillis();
            try {
                this.mesh = this.launcher.start();
            }
            catch (RuntimeException e) {
                log.error("Sidecar failed to start", (Throwable)e);
                return;
            }
            finally {
                this.sidecarMonitor.start();
            }
            try {
                boolean released = this.sidecarMonitor.awaitStartup().get(15L, TimeUnit.SECONDS);
                if (this.mesh.isAlive()) {
                    if (released) {
                        this.sidecarMonitor.forwardSidecarLogs();
                        log.info("Sidecar started after {}ms", (Object)(System.currentTimeMillis() - start));
                    } else {
                        log.warn("Sidecar has not fully started after {}ms. {} will continue starting. More details may be available in the Mesh logs", (Object)(System.currentTimeMillis() - start), (Object)Product.NAME);
                        this.sidecarMonitor.forwardSidecarLogs();
                    }
                    break block11;
                }
                throw new SidecarUnavailableException("Sidecar could not be started. Failed to start Mesh. (Exit code: " + this.mesh.exitValue() + ")");
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                log.warn("Interrupted after {}ms while waiting for sidecar to start", (Object)(System.currentTimeMillis() - start));
            }
        }
    }

    private void startSidecarMonitor() {
        this.sidecarMonitor = new SidecarMonitor();
        this.monitoringExecutorService.scheduleAtFixedRate(DefaultSidecarManager.wrapForErrorHandling(this.sidecarMonitor::run), 120L, 60L, TimeUnit.SECONDS);
    }

    private <T> T withSidecarMonitor(Function<SidecarMonitor, T> monitor, T defaultValue) {
        SidecarMonitor sidecarMonitor = this.sidecarMonitor;
        if (sidecarMonitor == null) {
            return defaultValue;
        }
        return monitor.apply(sidecarMonitor);
    }

    private class DefaultSidecarHealthcheckStatistics
    implements SidecarHealthcheckStatistics {
        private DefaultSidecarHealthcheckStatistics() {
        }

        @Override
        public Duration getLastDurationUntilReady() {
            return DefaultSidecarManager.this.withSidecarMonitor(monitor -> monitor.sidecarReady ? Duration.between(monitor.startTime, monitor.readyTime) : Duration.ZERO, Duration.ZERO);
        }

        @Override
        public long getLastGrpcPingLatencyMs() {
            return DefaultSidecarManager.this.withSidecarMonitor(monitor -> monitor.lastGrpcPingDuration, -1L);
        }

        @Override
        public Instant getLastGrpcPingResponse() {
            return DefaultSidecarManager.this.withSidecarMonitor(monitor -> monitor.lastGrpcPingReceived, Instant.MIN);
        }

        @Override
        public Instant getLastPingSent() {
            return DefaultSidecarManager.this.withSidecarMonitor(monitor -> monitor.lastPingSent, Instant.MIN);
        }

        @Override
        public Instant getLastPongReceived() {
            return DefaultSidecarManager.this.withSidecarMonitor(monitor -> monitor.lastPongReceived, Instant.MIN);
        }

        @Override
        public int getRestartCount() {
            return DefaultSidecarManager.this.restartCount;
        }

        @Override
        public boolean isRunning() {
            return DefaultSidecarManager.this.sidecarMonitor != null && DefaultSidecarManager.this.sidecarMonitor.sidecarReady;
        }
    }

    private class SidecarMonitor
    implements Runnable,
    AutoCloseable {
        static final int MAX_MESH_LOG_LINES = 100;
        final long gracePeriod;
        final Thread shutdownHook;
        ScheduledFuture<?> futureHeartbeatTask;
        Future<?> futureOutputProcessor;
        long lastGrpcPingDuration;
        Instant lastGrpcPingReceived;
        Instant lastPingSent = Instant.MIN;
        Instant lastPongReceived = Instant.MIN;
        OutputProcessorTask outputProcessorTask;
        CompletableFuture<Boolean> readyFuture;
        volatile Instant readyTime;
        volatile boolean sidecarReady;
        volatile Instant startTime;

        SidecarMonitor() {
            this.gracePeriod = (long)DefaultSidecarManager.this.configPingInterval * (long)DefaultSidecarManager.this.configFailureThreshold;
            this.shutdownHook = new Thread(this::stop);
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        }

        @Override
        public void close() {
            Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            this.stop();
        }

        public void forwardSidecarLogs() {
            Collection<String> logTail;
            if (this.outputProcessorTask != null && !(logTail = this.outputProcessorTask.drainLogTail()).isEmpty()) {
                for (String line : logTail) {
                    log.info("mesh-launcher.log: {}", (Object)line);
                }
            }
            Instant startTime = this.startTime;
            Path sidecarHome = DefaultSidecarManager.this.launcher.getHomeDir();
            Path sidecarLog = sidecarHome.resolve(Paths.get("log", "atlassian-mesh.log"));
            LinkedList<Pair> messages = new LinkedList<Pair>();
            int lineCount = 0;
            try (ReversedLinesFileReader reader = ((ReversedLinesFileReader.Builder)new ReversedLinesFileReader.Builder().setPath(sidecarLog)).get();){
                String line;
                LinkedList<String> lines = new LinkedList<String>();
                while ((line = reader.readLine()) != null && lineCount <= 100) {
                    ++lineCount;
                    ParsePosition parsePosition = new ParsePosition(0);
                    Optional<Instant> date = this.parseDate(line, parsePosition);
                    if (date.isPresent()) {
                        boolean hasError;
                        if ((startTime == null || startTime.isBefore(date.get())) && ((hasError = line.contains("ERROR")) || line.contains("WARN"))) {
                            String lineWithoutDate = line.substring(parsePosition.getIndex() + 1);
                            lines.addFirst(lineWithoutDate);
                            messages.addFirst(Pair.of((Object)(hasError ? LogLevel.ERROR : LogLevel.WARN), (Object)String.join((CharSequence)"\n", lines)));
                        }
                        lines.clear();
                        continue;
                    }
                    lines.addFirst(line);
                }
            }
            catch (IOException e) {
                log.debug("Error while reading sidecar logs", (Throwable)e);
            }
            messages.forEach(message -> {
                if (message.getLeft() == LogLevel.ERROR) {
                    log.error("atlassian-mesh.log: {}", message.getRight());
                } else {
                    log.warn("atlassian-mesh.log: {}", message.getRight());
                }
            });
        }

        @Override
        public void run() {
            if (this.startTime == null || !DefaultSidecarManager.this.initialized) {
                return;
            }
            final Instant now = DefaultSidecarManager.this.clock.instant();
            if (!this.sidecarReady) {
                if (this.startTime.isBefore(now.minus(DefaultSidecarManager.this.configStartupTimeout, ChronoUnit.SECONDS))) {
                    log.warn("Sidecar has timed out while attempting to start, restarting...");
                    this.forwardSidecarLogs();
                    this.executeRestart();
                }
                return;
            }
            Instant faultThreshold = now.minus(Duration.ofSeconds(this.gracePeriod));
            if (this.startTime.isAfter(faultThreshold)) {
                return;
            }
            if (this.lastPingSent.isBefore(faultThreshold)) {
                log.warn("Ping hasn't been sent for {} periods ({}), attempting restart", (Object)DefaultSidecarManager.this.configFailureThreshold, (Object)this.describeTime(this.lastPingSent, now));
                this.executeRestart();
                return;
            }
            if (this.lastPongReceived.isBefore(faultThreshold)) {
                log.warn("Pong hasn't been received for {} periods ({}), attempting restart", (Object)DefaultSidecarManager.this.configFailureThreshold, (Object)this.describeTime(this.lastPongReceived, now));
                this.executeRestart();
                return;
            }
            if (this.lastGrpcPingReceived.isBefore(faultThreshold)) {
                log.warn("gRPC ping response hasn't been received for {} periods ({}), attempting restart", (Object)DefaultSidecarManager.this.configFailureThreshold, (Object)this.describeTime(this.lastGrpcPingReceived, now));
                this.executeRestart();
                return;
            }
            log.debug("Sidecar is still alive. Last pong received {}ms ago.", new Object(){

                public String toString() {
                    return String.valueOf(Duration.between(SidecarMonitor.this.lastPongReceived, now).toMillis());
                }
            });
        }

        CompletableFuture<Boolean> awaitStartup() {
            if (this.startTime == null) {
                return CompletableFuture.completedFuture(false);
            }
            return this.readyFuture;
        }

        void executeRestart() {
            try {
                this.stop();
                DefaultSidecarManager.this.internalStop();
                ++DefaultSidecarManager.this.restartCount;
                DefaultSidecarManager.this.internalStart();
            }
            catch (IOException e) {
                log.error("Exception while executing restart", (Throwable)e);
            }
        }

        void onGrpcPingReceived(long ping) {
            this.lastGrpcPingReceived = DefaultSidecarManager.this.clock.instant();
            this.lastGrpcPingDuration = ping;
        }

        void onPingSent() {
            this.lastPingSent = DefaultSidecarManager.this.clock.instant();
        }

        void onPongReceived() {
            this.lastPongReceived = DefaultSidecarManager.this.clock.instant();
        }

        void onSidecarReady() {
            this.sidecarReady = true;
            this.readyTime = DefaultSidecarManager.this.clock.instant();
            this.readyFuture.complete(true);
            this.futureHeartbeatTask = DefaultSidecarManager.this.monitoringExecutorService.scheduleAtFixedRate(DefaultSidecarManager.wrapForErrorHandling(this::sendHeartbeat), DefaultSidecarManager.this.configPingInterval, DefaultSidecarManager.this.configPingInterval, TimeUnit.SECONDS);
        }

        void onSidecarStopped() {
            this.readyFuture.complete(false);
            if (this.startTime != null) {
                DefaultSidecarManager.this.internalStop();
                log.warn("Sidecar stopped unexpectedly, scheduling restart...");
                this.forwardSidecarLogs();
                DefaultSidecarManager.this.monitoringExecutorService.schedule(DefaultSidecarManager.wrapForErrorHandling(this::executeRestart), (long)DefaultSidecarManager.this.configRestartDelay, TimeUnit.SECONDS);
            }
        }

        void sendHeartbeat() {
            if (DefaultSidecarManager.this.mesh != null && DefaultSidecarManager.this.mesh.isAlive()) {
                OutputStream outputStream = DefaultSidecarManager.this.mesh.getOutputStream();
                try {
                    outputStream.write(PING);
                    outputStream.flush();
                    this.onPingSent();
                }
                catch (IOException e) {
                    log.info("Failed to send heartbeat ping", (Throwable)(log.isDebugEnabled() ? e : null));
                }
                try {
                    if (DefaultSidecarManager.this.managementClient == null) {
                        this.onGrpcPingReceived(-1L);
                    } else {
                        long ping = DefaultSidecarManager.this.managementClient.ping((MeshNode)DefaultSidecarManager.this.node);
                        this.onGrpcPingReceived(ping);
                    }
                }
                catch (ServiceException | StatusRuntimeException e) {
                    log.info("Failed to send gRPC ping", log.isDebugEnabled() ? e : null);
                }
            }
        }

        void start() {
            this.startTime = DefaultSidecarManager.this.clock.instant();
            this.readyFuture = new CompletableFuture();
            this.lastPingSent = Instant.MIN;
            this.lastPongReceived = Instant.MIN;
            this.lastGrpcPingReceived = Instant.MIN;
            this.outputProcessorTask = new OutputProcessorTask();
            this.futureOutputProcessor = DefaultSidecarManager.this.monitoringExecutorService.submit(DefaultSidecarManager.wrapForErrorHandling(this.outputProcessorTask::run));
        }

        void stop() {
            if (this.startTime != null) {
                this.startTime = null;
                this.readyTime = null;
                this.outputProcessorTask.stop();
                this.futureOutputProcessor.cancel(true);
                this.futureOutputProcessor = null;
                if (this.futureHeartbeatTask != null) {
                    this.futureHeartbeatTask.cancel(true);
                    this.futureHeartbeatTask = null;
                }
            }
        }

        private String describeTime(Instant before, Instant now) {
            return before == Instant.MIN ? "never" : Duration.between(before, now).toMillis() + "ms ago";
        }

        private Optional<Instant> parseDate(String line, ParsePosition position) {
            Date date = DATE_FORMAT_A.parse(line, position);
            if (date == null) {
                date = DATE_FORMAT_B.parse(line, position);
                if (date == null) {
                    return Optional.empty();
                }
                position.setErrorIndex(-1);
                return Optional.of(date.toInstant());
            }
            return Optional.of(date.toInstant());
        }

        private class OutputProcessorTask
        implements Runnable {
            Deque<String> logTail = new ArrayDeque<String>(20);
            volatile boolean started;

            OutputProcessorTask() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                this.started = true;
                if (DefaultSidecarManager.this.mesh == null) {
                    log.debug("Sidecar is not running - not parsing log output");
                    return;
                }
                Path launcherLog = DefaultSidecarManager.this.homeLayout.getLogDir().resolve("mesh-launcher.log");
                try (InputStream stdout = DefaultSidecarManager.this.mesh.getInputStream();
                     BufferedReader reader = new BufferedReader(new InputStreamReader(stdout, StandardCharsets.UTF_8));
                     BufferedWriter writer = Files.newBufferedWriter(launcherLog, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        if (!this.started) {
                            break;
                        }
                        if (!this.process(line)) continue;
                        writer.write(line);
                        writer.write(10);
                        writer.flush();
                    }
                }
                catch (IOException e) {
                    log.warn("Failed reading stdout", (Throwable)e);
                }
                finally {
                    if (this.started) {
                        SidecarMonitor.this.onSidecarStopped();
                    }
                }
            }

            public void stop() {
                this.started = false;
            }

            private Collection<String> drainLogTail() {
                ImmutableList returnValue = ImmutableList.copyOf(this.logTail);
                this.logTail.clear();
                return returnValue;
            }

            private boolean process(String line) {
                if ("Ready".equals(line)) {
                    SidecarMonitor.this.onSidecarReady();
                    return false;
                }
                if ("pong".equalsIgnoreCase(line)) {
                    SidecarMonitor.this.onPongReceived();
                    return false;
                }
                if (this.logTail.size() >= 20) {
                    this.logTail.removeFirst();
                }
                this.logTail.add(line);
                return true;
            }
        }
    }

    private static interface ThrowingRunnable<E extends Throwable> {
        public void run() throws E;
    }
}

