/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm.git.mesh;

import com.atlassian.bitbucket.ServiceException;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.mesh.rpc.v1.RpcGitError;
import com.atlassian.bitbucket.repository.NoSuchBranchException;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.git.command.branch.GitBranchNotMergedException;
import com.atlassian.stash.internal.scm.git.mesh.DefaultErrorTranslator;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public class DeleteBranchErrorTranslator
extends DefaultErrorTranslator {
    public DeleteBranchErrorTranslator(@Nonnull I18nService i18nService, @Nullable Repository repository) {
        super(i18nService, repository);
    }

    @Override
    @Nonnull
    protected ServiceException translate(@Nonnull RpcGitError error, @Nullable Throwable cause) {
        switch (error.getErrorOneofCase()) {
            case BRANCH_NOT_MERGED: {
                return new GitBranchNotMergedException(this.i18nService.createKeyedMessage("bitbucket.service.repository.branchnotmerged", new Object[]{error.getBranchNotMerged().getBranchName()}));
            }
            case NO_SUCH_OBJECT: {
                String branch = error.getNoSuchObject().getObjectId().toStringUtf8();
                if (this.repository == null) {
                    return new NoSuchBranchException(this.i18nService.createKeyedMessage("bitbucket.service.repository.branchnotfound.generic", new Object[]{branch}), branch);
                }
                return new NoSuchBranchException(this.i18nService.createKeyedMessage("bitbucket.service.repository.branchnotfound", new Object[]{branch, this.repository.getName()}), branch);
            }
        }
        return super.translate(error, cause);
    }
}

